namespace Compound
end Compound
namespace Cint
noncomputable def is_bool (x : ℤ) := x = (0 : ℤ) ∨ x = (1 : ℤ)
axiom is_uint8 : ℤ -> Prop
axiom is_uint8_def (x : ℤ) : is_uint8 x = ((0 : ℤ) ≤ x ∧ x < (256 : ℤ))
axiom is_sint8 : ℤ -> Prop
axiom is_sint8_def (x : ℤ) : is_sint8 x = (-(128 : ℤ) ≤ x ∧ x < (128 : ℤ))
axiom is_uint16 : ℤ -> Prop
axiom is_uint16_def (x : ℤ) : is_uint16 x = ((0 : ℤ) ≤ x ∧ x < (65536 : ℤ))
noncomputable def is_sint16 (x : ℤ) := -(32768 : ℤ) ≤ x ∧ x < (32768 : ℤ)
axiom is_uint32 : ℤ -> Prop
axiom is_uint32_def (x : ℤ) : is_uint32 x = ((0 : ℤ) ≤ x ∧ x < (4294967296 : ℤ))
axiom is_sint32 : ℤ -> Prop
axiom is_sint32_def (x : ℤ) : is_sint32 x = (-(2147483648 : ℤ) ≤ x ∧ x < (2147483648 : ℤ))
axiom is_uint64 : ℤ -> Prop
axiom is_uint64_def (x : ℤ) : is_uint64 x = ((0 : ℤ) ≤ x ∧ x < (18446744073709551616 : ℤ))
axiom is_sint64 : ℤ -> Prop
axiom is_sint64_def (x : ℤ) : is_sint64 x = (-(9223372036854775808 : ℤ) ≤ x ∧ x < (9223372036854775808 : ℤ))
axiom is_bool0 : is_bool (0 : ℤ)
axiom is_bool1 : is_bool (1 : ℤ)
noncomputable def to_bool (x : ℤ) := if x = (0 : ℤ) then (0 : ℤ) else (1 : ℤ)
axiom to_uint8 : ℤ -> ℤ
axiom to_sint8 : ℤ -> ℤ
axiom to_uint16 : ℤ -> ℤ
axiom to_sint16 : ℤ -> ℤ
axiom to_uint32 : ℤ -> ℤ
axiom to_sint32 : ℤ -> ℤ
axiom to_uint64 : ℤ -> ℤ
axiom to_sint64 : ℤ -> ℤ
axiom two_power_abs : ℤ -> ℤ
noncomputable def is_uint (n : ℤ) (x : ℤ) := (0 : ℤ) ≤ x ∧ x < two_power_abs n
noncomputable def is_sint (n : ℤ) (x : ℤ) := -two_power_abs n ≤ x ∧ x < two_power_abs n
axiom to_uint : ℤ -> ℤ -> ℤ
axiom to_sint : ℤ -> ℤ -> ℤ
axiom is_to_uint8 (x : ℤ) : is_uint8 (to_uint8 x)
axiom is_to_sint8 (x : ℤ) : is_sint8 (to_sint8 x)
axiom is_to_uint16 (x : ℤ) : is_uint16 (to_uint16 x)
axiom is_to_sint16 (x : ℤ) : is_sint16 (to_sint16 x)
axiom is_to_uint32 (x : ℤ) : is_uint32 (to_uint32 x)
axiom is_to_sint32 (x : ℤ) : is_sint32 (to_sint32 x)
axiom is_to_uint64 (x : ℤ) : is_uint64 (to_uint64 x)
axiom is_to_sint64 (x : ℤ) : is_sint64 (to_sint64 x)
axiom id_uint8 (x : ℤ) (fact0 : (0 : ℤ) ≤ x) (fact1 : x < (256 : ℤ)) : to_uint8 x = x
axiom id_sint8 (x : ℤ) (fact0 : -(128 : ℤ) ≤ x) (fact1 : x < (128 : ℤ)) : to_sint8 x = x
axiom id_uint16 (x : ℤ) (fact0 : (0 : ℤ) ≤ x) (fact1 : x < (65536 : ℤ)) : to_uint16 x = x
axiom id_sint16 (x : ℤ) (fact0 : -(32768 : ℤ) ≤ x) (fact1 : x < (32768 : ℤ)) : to_sint16 x = x
axiom id_uint32 (x : ℤ) (fact0 : (0 : ℤ) ≤ x) (fact1 : x < (4294967296 : ℤ)) : to_uint32 x = x
axiom id_sint32 (x : ℤ) (fact0 : -(2147483648 : ℤ) ≤ x) (fact1 : x < (2147483648 : ℤ)) : to_sint32 x = x
axiom id_uint64 (x : ℤ) (fact0 : (0 : ℤ) ≤ x) (fact1 : x < (18446744073709551616 : ℤ)) : to_uint64 x = x
axiom id_sint64 (x : ℤ) (fact0 : -(9223372036854775808 : ℤ) ≤ x) (fact1 : x < (9223372036854775808 : ℤ)) : to_sint64 x = x
axiom proj_int8 (x : ℤ) : to_sint8 (to_uint8 x) = to_sint8 x
axiom proj_int16 (x : ℤ) : to_sint16 (to_uint16 x) = to_sint16 x
axiom proj_int32 (x : ℤ) : to_sint32 (to_uint32 x) = to_sint32 x
axiom proj_int64 (x : ℤ) : to_sint64 (to_uint64 x) = to_sint64 x
axiom lnot : ℤ -> ℤ
axiom land : ℤ -> ℤ -> ℤ
axiom lxor : ℤ -> ℤ -> ℤ
axiom lor : ℤ -> ℤ -> ℤ
axiom lsl : ℤ -> ℤ -> ℤ
axiom lsr : ℤ -> ℤ -> ℤ
axiom bit_testb : ℤ -> ℤ -> Bool
axiom bit_test : ℤ -> ℤ -> Prop
end Cint
namespace Axiomatic
noncomputable def l_storage (mptr_0 : Memory.addr -> Memory.addr) (s : Memory.addr) := mptr_0 (Memory.shift s (0 : ℤ))
noncomputable def l_size (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) := mint_0 (Memory.shift s (2 : ℤ))
noncomputable def p_equalranges_1' (mint_0 : Memory.addr -> ℤ) (mint_1 : Memory.addr -> ℤ) (a : Memory.addr) (n : ℤ) (b : Memory.addr) := ∀(i : ℤ), (0 : ℤ) ≤ i → i < n → mint_1 (Memory.shift a i) = mint_0 (Memory.shift b i)
noncomputable def p_equal (mptr_0 : Memory.addr -> Memory.addr) (mint_0 : Memory.addr -> ℤ) (mptr_1 : Memory.addr -> Memory.addr) (mint_1 : Memory.addr -> ℤ) (s : Memory.addr) (t : Memory.addr) := let x : ℤ := l_size mint_1 s; l_size mint_0 t = x ∧ p_equalranges_1' mint_0 mint_1 (l_storage mptr_1 s) x (l_storage mptr_0 t)
noncomputable def l_capacity (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) := mint_0 (Memory.shift s (1 : ℤ))
noncomputable def p_invariant (malloc_0 : ℤ -> ℤ) (mptr_0 : Memory.addr -> Memory.addr) (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) := let x : ℤ := l_capacity mint_0 s; let x_1 : ℤ := l_size mint_0 s; let a : Memory.addr := Memory.shift (l_storage mptr_0 s) (0 : ℤ); (0 : ℤ) < x ∧ x_1 ≤ x ∧ (0 : ℤ) ≤ x_1 ∧ Memory.valid_rw malloc_0 a x ∧ Memory.separated s (3 : ℤ) a x
noncomputable def p_empty (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) := l_size mint_0 s = (0 : ℤ)
noncomputable def p_unchanged_1' (mint_0 : Memory.addr -> ℤ) (mint_1 : Memory.addr -> ℤ) (a : Memory.addr) (m : ℤ) (n : ℤ) := ∀(i : ℤ), let a_1 : Memory.addr := Memory.shift a i; m ≤ i → i < n → mint_1 a_1 = mint_0 a_1
noncomputable def p_full (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) := l_size mint_0 s = l_capacity mint_0 s
noncomputable def p_separated (mptr_0 : Memory.addr -> Memory.addr) (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) (t : Memory.addr) := let a : Memory.addr := Memory.shift (mptr_0 (Memory.shift s (0 : ℤ))) (0 : ℤ); let x : ℤ := mint_0 (Memory.shift s (1 : ℤ)); let a_1 : Memory.addr := Memory.shift (mptr_0 (Memory.shift t (0 : ℤ))) (0 : ℤ); let x_1 : ℤ := mint_0 (Memory.shift t (1 : ℤ)); Memory.separated s (3 : ℤ) t (3 : ℤ) ∧ Memory.separated s (3 : ℤ) a x ∧ Memory.separated s (3 : ℤ) a_1 x_1 ∧ Memory.separated t (3 : ℤ) a_1 x_1 ∧ Memory.separated a x t (3 : ℤ) ∧ Memory.separated a x a_1 x_1
axiom Q_TL_Size (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) : Cint.is_uint32 (l_size mint_0 s)
axiom Q_TL_Capacity (mint_0 : Memory.addr -> ℤ) (s : Memory.addr) : Cint.is_uint32 (l_capacity mint_0 s)
end Axiomatic
