import Why3.Base
import Why3.why3.Ref.Ref
open Classical
open Lean4Why3
namespace avl_AVL_balanceqtvc
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
axiom zero : t
axiom op : t -> t -> t
axiom assoc (a : t) (b : t) (c : t) : op a (op b c) = op (op a b) c
axiom neutral (x : t) : op x zero = x ∧ x = op zero x
axiom agg :  {α : Type} -> [Inhabited α] -> (α -> t) -> List α -> t
axiom agg_empty {α : Type} [Inhabited α] (f : α -> t) : agg f ([] : List α) = zero
axiom agg_sing {α : Type} [Inhabited α] (s : List α) (f : α -> t) (fact0 : Int.ofNat (List.length s) = (1 : ℤ)) : agg f s = f (s[(0 : ℕ)]!)
axiom agg_cat {α : Type} [Inhabited α] (f : α -> t) (s1 : List α) (s2 : List α) : agg f (s1 ++ s2) = op (agg f s1) (agg f s2)
axiom t1 : Type -> Type
axiom inhabited_axiom_t1 {α : Type} [Inhabited α] : Inhabited (t1 α)
attribute [instance] inhabited_axiom_t1
axiom measure :  {α : Type} -> [Inhabited α] -> t1 α -> t
axiom balancing : ℕ
axiom balancing'def : (0 : ℤ) < Int.ofNat balancing
inductive tree (α : Type) where
  | Empty : tree α
  | Node : tree α -> t1 α -> tree α -> ℕ -> t -> tree α
axiom inhabited_axiom_tree {α : Type} [Inhabited α] : Inhabited (tree α)
attribute [instance] inhabited_axiom_tree
structure m (α : Type) where
  seq : List (t1 α)
  hgt : ℤ
axiom inhabited_axiom_m {α : Type} [Inhabited α] : Inhabited (m α)
attribute [instance] inhabited_axiom_m
noncomputable def node_model {α : Type} [Inhabited α] (l : List α) (d : α) (r : List α) := l ++ List.cons d r
noncomputable def seq_model {α : Type} [Inhabited α] : tree α -> List (t1 α)
  | (tree.Empty : tree α) => ([] : List (t1 α))
  | (tree.Node l d r x x0) => node_model (seq_model l) d (seq_model r)
noncomputable def real_height {α : Type} [Inhabited α] : tree α -> ℤ
  | (tree.Empty : tree α) => (0 : ℤ)
  | (tree.Node l x r x0 x1) => let hl : ℤ := real_height l; let hr : ℤ := real_height r; (1 : ℤ) + (if hl < hr then hr else hl)
axiom measure_closure :  {α : Type} -> [Inhabited α] -> t1 α -> t
axiom measure_closure_def {α : Type} [Inhabited α] (y : t1 α) : measure_closure y = measure y
noncomputable def balanced {α : Type} [Inhabited α] : tree α -> Prop
  | (tree.Empty : tree α) => True
  | (tree.Node l x r h m1) => Int.ofNat h = real_height (tree.Node l x r h m1) ∧ m1 = agg measure_closure (seq_model (tree.Node l x r h m1)) ∧ (-Int.ofNat balancing ≤ real_height r - real_height l ∧ real_height r - real_height l ≤ Int.ofNat balancing) ∧ balanced l ∧ balanced r
axiom t2 : Type -> Type
axiom inhabited_axiom_t2 {α : Type} [Inhabited α] : Inhabited (t2 α)
attribute [instance] inhabited_axiom_t2
axiom repr :  {α : Type} -> [Inhabited α] -> t2 α -> tree α
axiom m1 :  {α : Type} -> [Inhabited α] -> t2 α -> m α
axiom t'invariant {α : Type} [Inhabited α] (self : t2 α) : balanced (repr self) ∧ m.seq (m1 self) = seq_model (repr self) ∧ m.hgt (m1 self) = real_height (repr self)
noncomputable def t'eq {α : Type} [Inhabited α] (a : t2 α) (b : t2 α) := repr a = repr b ∧ m1 a = m1 b
axiom t'inj {α : Type} [Inhabited α] (a : t2 α) (b : t2 α) (fact0 : t'eq a b) : a = b
inductive view (α : Type) where
  | AEmpty : view α
  | ANode : t2 α -> t1 α -> t2 α -> ℕ -> t -> view α
axiom inhabited_axiom_view {α : Type} [Inhabited α] : Inhabited (view α)
attribute [instance] inhabited_axiom_view
theorem balance'vc {α : Type} [Inhabited α] (l : t2 α) (r : t2 α) (hl : ℕ) (hr : ℕ) (o1 : ℕ) (d : t1 α) (fact0 : -Int.ofNat balancing - (1 : ℤ) ≤ m.hgt (m1 l) - m.hgt (m1 r)) (fact1 : m.hgt (m1 l) - m.hgt (m1 r) ≤ Int.ofNat balancing + (1 : ℤ)) (fact2 : Int.ofNat hl = m.hgt (m1 l)) (fact3 : Int.ofNat hr = m.hgt (m1 r)) (fact4 : Int.ofNat o1 = -Int.ofNat hr) : Int.ofNat o1 ≤ Int.ofNat hl - Int.ofNat hr ∧ Int.ofNat hl - Int.ofNat hr ≤ Int.ofNat hl ∧ (∀(df : ℕ), Int.ofNat df = Int.ofNat hl - Int.ofNat hr → (if balancing < df then ∀(o2 : view α), (match o2 with | (view.AEmpty : view α) => m.hgt (m1 l) = (0 : ℤ) ∧ m.seq (m1 l) = ([] : List (t1 α)) | view.ANode l1 d r1 h s => m.seq (m1 l) = node_model (m.seq (m1 l1)) d (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 l)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 l) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) → (match o2 with | (view.AEmpty : view α) => False | view.ANode ll ld lr _ _ => (∀(o3 : ℕ), Int.ofNat o3 = m.hgt (m1 lr) → (∀(o4 : ℕ), Int.ofNat o4 = m.hgt (m1 ll) → (if o3 ≤ o4 then (-Int.ofNat balancing ≤ m.hgt (m1 lr) - m.hgt (m1 r) ∧ m.hgt (m1 lr) - m.hgt (m1 r) ≤ Int.ofNat balancing) ∧ (∀(o5 : t2 α), m.seq (m1 o5) = node_model (m.seq (m1 lr)) d (m.seq (m1 r)) ∧ m.hgt (m1 o5) = (1 : ℤ) + (if m.hgt (m1 lr) < m.hgt (m1 r) then m.hgt (m1 r) else m.hgt (m1 lr)) → -Int.ofNat balancing ≤ m.hgt (m1 ll) - m.hgt (m1 o5) ∧ m.hgt (m1 ll) - m.hgt (m1 o5) ≤ Int.ofNat balancing) else ∀(o5 : view α), (match o5 with | (view.AEmpty : view α) => m.hgt (m1 lr) = (0 : ℤ) ∧ m.seq (m1 lr) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 lr) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 lr)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 lr) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) → (match o5 with | (view.AEmpty : view α) => False | view.ANode lrl lrd lrr _ _ => (-Int.ofNat balancing ≤ m.hgt (m1 lrr) - m.hgt (m1 r) ∧ m.hgt (m1 lrr) - m.hgt (m1 r) ≤ Int.ofNat balancing) ∧ (∀(o6 : t2 α), m.seq (m1 o6) = node_model (m.seq (m1 lrr)) d (m.seq (m1 r)) ∧ m.hgt (m1 o6) = (1 : ℤ) + (if m.hgt (m1 lrr) < m.hgt (m1 r) then m.hgt (m1 r) else m.hgt (m1 lrr)) → (-Int.ofNat balancing ≤ m.hgt (m1 ll) - m.hgt (m1 lrl) ∧ m.hgt (m1 ll) - m.hgt (m1 lrl) ≤ Int.ofNat balancing) ∧ (∀(o7 : t2 α), m.seq (m1 o7) = node_model (m.seq (m1 ll)) ld (m.seq (m1 lrl)) ∧ m.hgt (m1 o7) = (1 : ℤ) + (if m.hgt (m1 ll) < m.hgt (m1 lrl) then m.hgt (m1 lrl) else m.hgt (m1 ll)) → -Int.ofNat balancing ≤ m.hgt (m1 o7) - m.hgt (m1 o6) ∧ m.hgt (m1 o7) - m.hgt (m1 o6) ≤ Int.ofNat balancing))))))) else ∀(o2 : ℕ), Int.ofNat o2 = -Int.ofNat balancing → (if df < o2 then ∀(o3 : view α), (match o3 with | (view.AEmpty : view α) => m.hgt (m1 r) = (0 : ℤ) ∧ m.seq (m1 r) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 r) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 r)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 r) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) → (match o3 with | (view.AEmpty : view α) => False | view.ANode rl rd rr _ _ => (∀(o4 : ℕ), Int.ofNat o4 = m.hgt (m1 rl) → (∀(o5 : ℕ), Int.ofNat o5 = m.hgt (m1 rr) → (if o4 ≤ o5 then (-Int.ofNat balancing ≤ m.hgt (m1 l) - m.hgt (m1 rl) ∧ m.hgt (m1 l) - m.hgt (m1 rl) ≤ Int.ofNat balancing) ∧ (∀(o6 : t2 α), m.seq (m1 o6) = node_model (m.seq (m1 l)) d (m.seq (m1 rl)) ∧ m.hgt (m1 o6) = (1 : ℤ) + (if m.hgt (m1 l) < m.hgt (m1 rl) then m.hgt (m1 rl) else m.hgt (m1 l)) → -Int.ofNat balancing ≤ m.hgt (m1 o6) - m.hgt (m1 rr) ∧ m.hgt (m1 o6) - m.hgt (m1 rr) ≤ Int.ofNat balancing) else ∀(o6 : view α), (match o6 with | (view.AEmpty : view α) => m.hgt (m1 rl) = (0 : ℤ) ∧ m.seq (m1 rl) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 rl) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 rl)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 rl) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) → (match o6 with | (view.AEmpty : view α) => False | view.ANode rll rld rlr _ _ => (-Int.ofNat balancing ≤ m.hgt (m1 rlr) - m.hgt (m1 rr) ∧ m.hgt (m1 rlr) - m.hgt (m1 rr) ≤ Int.ofNat balancing) ∧ (∀(o7 : t2 α), m.seq (m1 o7) = node_model (m.seq (m1 rlr)) rd (m.seq (m1 rr)) ∧ m.hgt (m1 o7) = (1 : ℤ) + (if m.hgt (m1 rlr) < m.hgt (m1 rr) then m.hgt (m1 rr) else m.hgt (m1 rlr)) → (-Int.ofNat balancing ≤ m.hgt (m1 l) - m.hgt (m1 rll) ∧ m.hgt (m1 l) - m.hgt (m1 rll) ≤ Int.ofNat balancing) ∧ (∀(o8 : t2 α), m.seq (m1 o8) = node_model (m.seq (m1 l)) d (m.seq (m1 rll)) ∧ m.hgt (m1 o8) = (1 : ℤ) + (if m.hgt (m1 l) < m.hgt (m1 rll) then m.hgt (m1 rll) else m.hgt (m1 l)) → -Int.ofNat balancing ≤ m.hgt (m1 o8) - m.hgt (m1 o7) ∧ m.hgt (m1 o8) - m.hgt (m1 o7) ≤ Int.ofNat balancing))))))) else -Int.ofNat balancing ≤ m.hgt (m1 l) - m.hgt (m1 r) ∧ m.hgt (m1 l) - m.hgt (m1 r) ≤ Int.ofNat balancing)) ∧ (∀(result : t2 α), (if balancing < df then ∃(o2 : view α), (match o2 with | (view.AEmpty : view α) => m.hgt (m1 l) = (0 : ℤ) ∧ m.seq (m1 l) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 l) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 l)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 l) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) ∧ (match o2 with | (view.AEmpty : view α) => False | view.ANode ll ld lr _ _ => (∃(o3 : ℕ), Int.ofNat o3 = m.hgt (m1 lr) ∧ (∃(o4 : ℕ), Int.ofNat o4 = m.hgt (m1 ll) ∧ (if o3 ≤ o4 then ∃(o5 : t2 α), (m.seq (m1 o5) = node_model (m.seq (m1 lr)) d (m.seq (m1 r)) ∧ m.hgt (m1 o5) = (1 : ℤ) + (if m.hgt (m1 lr) < m.hgt (m1 r) then m.hgt (m1 r) else m.hgt (m1 lr))) ∧ m.seq (m1 result) = node_model (m.seq (m1 ll)) ld (m.seq (m1 o5)) ∧ m.hgt (m1 result) = (1 : ℤ) + (if m.hgt (m1 ll) < m.hgt (m1 o5) then m.hgt (m1 o5) else m.hgt (m1 ll)) else ∃(o5 : view α), (match o5 with | (view.AEmpty : view α) => m.hgt (m1 lr) = (0 : ℤ) ∧ m.seq (m1 lr) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 lr) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 lr)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 lr) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) ∧ (match o5 with | (view.AEmpty : view α) => False | view.ANode lrl lrd lrr _ _ => (∃(o6 : t2 α), (m.seq (m1 o6) = node_model (m.seq (m1 lrr)) d (m.seq (m1 r)) ∧ m.hgt (m1 o6) = (1 : ℤ) + (if m.hgt (m1 lrr) < m.hgt (m1 r) then m.hgt (m1 r) else m.hgt (m1 lrr))) ∧ (∃(o7 : t2 α), (m.seq (m1 o7) = node_model (m.seq (m1 ll)) ld (m.seq (m1 lrl)) ∧ m.hgt (m1 o7) = (1 : ℤ) + (if m.hgt (m1 ll) < m.hgt (m1 lrl) then m.hgt (m1 lrl) else m.hgt (m1 ll))) ∧ m.seq (m1 result) = node_model (m.seq (m1 o7)) lrd (m.seq (m1 o6)) ∧ m.hgt (m1 result) = (1 : ℤ) + (if m.hgt (m1 o7) < m.hgt (m1 o6) then m.hgt (m1 o6) else m.hgt (m1 o7))))))))) else ∃(o2 : ℕ), Int.ofNat o2 = -Int.ofNat balancing ∧ (if df < o2 then ∃(o3 : view α), (match o3 with | (view.AEmpty : view α) => m.hgt (m1 r) = (0 : ℤ) ∧ m.seq (m1 r) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 r) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 r)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 r) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) ∧ (match o3 with | (view.AEmpty : view α) => False | view.ANode rl rd rr _ _ => (∃(o4 : ℕ), Int.ofNat o4 = m.hgt (m1 rl) ∧ (∃(o5 : ℕ), Int.ofNat o5 = m.hgt (m1 rr) ∧ (if o4 ≤ o5 then ∃(o6 : t2 α), (m.seq (m1 o6) = node_model (m.seq (m1 l)) d (m.seq (m1 rl)) ∧ m.hgt (m1 o6) = (1 : ℤ) + (if m.hgt (m1 l) < m.hgt (m1 rl) then m.hgt (m1 rl) else m.hgt (m1 l))) ∧ m.seq (m1 result) = node_model (m.seq (m1 o6)) rd (m.seq (m1 rr)) ∧ m.hgt (m1 result) = (1 : ℤ) + (if m.hgt (m1 o6) < m.hgt (m1 rr) then m.hgt (m1 rr) else m.hgt (m1 o6)) else ∃(o6 : view α), (match o6 with | (view.AEmpty : view α) => m.hgt (m1 rl) = (0 : ℤ) ∧ m.seq (m1 rl) = ([] : List (t1 α)) | view.ANode l1 d1 r1 h s => m.seq (m1 rl) = node_model (m.seq (m1 l1)) d1 (m.seq (m1 r1)) ∧ s = agg measure_closure (m.seq (m1 rl)) ∧ (let hl1 : ℤ := m.hgt (m1 l1); let hr1 : ℤ := m.hgt (m1 r1); (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing) ∧ m.hgt (m1 rl) = Int.ofNat h ∧ Int.ofNat h = (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1))) ∧ (match o6 with | (view.AEmpty : view α) => False | view.ANode rll rld rlr _ _ => (∃(o7 : t2 α), (m.seq (m1 o7) = node_model (m.seq (m1 rlr)) rd (m.seq (m1 rr)) ∧ m.hgt (m1 o7) = (1 : ℤ) + (if m.hgt (m1 rlr) < m.hgt (m1 rr) then m.hgt (m1 rr) else m.hgt (m1 rlr))) ∧ (∃(o8 : t2 α), (m.seq (m1 o8) = node_model (m.seq (m1 l)) d (m.seq (m1 rll)) ∧ m.hgt (m1 o8) = (1 : ℤ) + (if m.hgt (m1 l) < m.hgt (m1 rll) then m.hgt (m1 rll) else m.hgt (m1 l))) ∧ m.seq (m1 result) = node_model (m.seq (m1 o8)) rld (m.seq (m1 o7)) ∧ m.hgt (m1 result) = (1 : ℤ) + (if m.hgt (m1 o8) < m.hgt (m1 o7) then m.hgt (m1 o7) else m.hgt (m1 o8))))))))) else m.seq (m1 result) = node_model (m.seq (m1 l)) d (m.seq (m1 r)) ∧ m.hgt (m1 result) = (1 : ℤ) + (if m.hgt (m1 l) < m.hgt (m1 r) then m.hgt (m1 r) else m.hgt (m1 l)))) → m.seq (m1 result) = node_model (m.seq (m1 l)) d (m.seq (m1 r)) ∧ (let hl1 : ℤ := m.hgt (m1 l); let hr1 : ℤ := m.hgt (m1 r); let he : ℤ := (1 : ℤ) + (if hl1 < hr1 then hr1 else hl1); let hres : ℤ := m.hgt (m1 result); ((0 : ℤ) ≤ he - hres ∧ he - hres ≤ (1 : ℤ)) ∧ (-Int.ofNat balancing ≤ hl1 - hr1 ∧ hl1 - hr1 ≤ Int.ofNat balancing → he = hres))))
  := sorry
end avl_AVL_balanceqtvc
