theory priority_queue_PQueue_opqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "../../lib/isabelle/avl_SelectionTypes"
begin
consts balancing :: "nat"
axiomatization where balancing'def:   "(0 :: int) < int balancing"
typedecl 'a t
typedecl  t1
consts key :: "'a t \<Rightarrow> t1"
consts le :: "t1 \<Rightarrow> t1 \<Rightarrow> bool"
axiomatization where Refl:   "le x x"
  for x :: "t1"
axiomatization where Trans:   "le x z"
 if "le x y"
 and "le y z"
  for x :: "t1"
  and y :: "t1"
  and z :: "t1"
consts eq :: "t1 \<Rightarrow> t1 \<Rightarrow> bool"
axiomatization where eq_def:   "eq x y \<longleftrightarrow> le x y \<and> le y x"
  for x :: "t1"
  and y :: "t1"
consts lt :: "t1 \<Rightarrow> t1 \<Rightarrow> bool"
axiomatization where lt_def:   "lt x y \<longleftrightarrow> le x y \<and> \<not>le y x"
  for x :: "t1"
  and y :: "t1"
axiomatization where Total:   "le x y \<or> le y x"
  for x :: "t1"
  and y :: "t1"
typedecl  t2
definition op :: "t1 option \<Rightarrow> t1 option \<Rightarrow> t1 option"
  where "op x y = (case x of None \<Rightarrow> y | Some a \<Rightarrow> (case y of None \<Rightarrow> x | Some b \<Rightarrow> (if lt b a then y else x)))" for x y
axiomatization where assoc:   "op a (op b c) = op (op a b) c"
  for a :: "t1 option"
  and b :: "t1 option"
  and c :: "t1 option"
axiomatization where neutral'0:   "op x None = x"
  for x :: "t1 option"
axiomatization where neutral'1:   "x = op None x"
  for x :: "t1 option"
consts agg :: "('a \<Rightarrow> t1 option) \<Rightarrow> 'a list \<Rightarrow> t1 option"
axiomatization where agg'def:   "if int (length s) = (0 :: int) then agg f s = None else agg f s = op (f (s ! (0 :: nat))) (agg f (drop (1 :: nat) s))"
  for s :: "'a list"
  and f :: "'a \<Rightarrow> t1 option"
theorem op'vc:
  fixes x :: "t1 option"
  fixes y :: "t1 option"
  shows "case x of None \<Rightarrow> True | Some a \<Rightarrow> (case y of None \<Rightarrow> True | Some b \<Rightarrow> True)"
  and "\<forall>(result :: t1 option). (case x of None \<Rightarrow> result = y | Some a \<Rightarrow> (case y of None \<Rightarrow> result = x | Some b \<Rightarrow> (\<exists>(o1 :: int). (((0 :: int) < o1 \<longleftrightarrow> lt a b) \<and> (o1 < (0 :: int) \<longleftrightarrow> lt b a) \<and> (o1 = (0 :: int) \<longleftrightarrow> eq b a)) \<and> (if o1 < (0 :: int) then result = y else result = x)))) \<longrightarrow> result = op x y"
  sorry
end
