theory bellman_ford_BellmanFord_bellman_fordqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_IntInf" "Why3STD.map_Const" "./bellman_ford_Graph"
begin
typedecl  set
consts to_fset :: "set \<Rightarrow> (vertex \<times> vertex) fset"
consts choose1 :: "set \<Rightarrow> vertex \<times> vertex"
axiomatization where choose'spec:   "choose1 s |\<in>| to_fset s"
 if "\<not>to_fset s = fempty"
  for s :: "set"
typedecl 'a t
consts contents :: "'a t \<Rightarrow> vertex \<Rightarrow> 'a"
consts create :: "'a \<Rightarrow> 'a t"
axiomatization where create'spec:   "contents (create x) = (const :: 'a \<Rightarrow> vertex \<Rightarrow> 'a) x"
  for x :: "'a"
consts mixfix_lbrb :: "'a t \<Rightarrow> vertex \<Rightarrow> 'a"
axiomatization where mixfix_lbrb'spec:   "mixfix_lbrb m k = contents m k"
  for m :: "'a t"
  and k :: "vertex"
consts mixfix_lblsmnrb :: "'a t \<Rightarrow> vertex \<Rightarrow> 'a \<Rightarrow> 'a t"
axiomatization where mixfix_lblsmnrb'spec:   "contents (mixfix_lblsmnrb m k v) = (contents m)(k := v)"
  for m :: "'a t"
  and k :: "vertex"
  and v :: "'a"
typedecl  distmap
definition inv1 :: "int_IntInf.t t \<Rightarrow> int \<Rightarrow> (vertex \<times> vertex) fset \<Rightarrow> _"
  where "inv1 m pass via \<longleftrightarrow> (\<forall>(v :: vertex). v |\<in>| vertices \<longrightarrow> (case mixfix_lbrb m v of Finite n \<Rightarrow> (\<exists>(l :: vertex list). path s l v \<and> path_weight l v = n) \<and> (\<forall>(l :: vertex list). path s l v \<longrightarrow> int (length l) < pass \<longrightarrow> n \<le> path_weight l v) \<and> (\<forall>(u :: vertex) (l :: vertex list). path s l u \<longrightarrow> int (length l) < pass \<longrightarrow> (u, v) |\<in>| via \<longrightarrow> n \<le> path_weight l u + weight u v) | Infinite \<Rightarrow> (\<forall>(l :: vertex list). path s l v \<longrightarrow> pass \<le> int (length l)) \<and> (\<forall>(u :: vertex). (u, v) |\<in>| via \<longrightarrow> (\<forall>(lu :: vertex list). path s lu u \<longrightarrow> pass \<le> int (length lu)))))" for m pass via
definition inv2 :: "int_IntInf.t t \<Rightarrow> (vertex \<times> vertex) fset \<Rightarrow> _"
  where "inv2 m via \<longleftrightarrow> (\<forall>(u :: vertex) (v :: vertex). (u, v) |\<in>| via \<longrightarrow> le (mixfix_lbrb m v) (add (mixfix_lbrb m u) (Finite (weight u v))))" for m via
theorem bellman_ford'vc:
  shows "let m :: int_IntInf.t t = mixfix_lblsmnrb (create Infinite) s (Finite (0 :: int)); o1 :: int = int (fcard vertices) - (1 :: int) in ((1 :: int) \<le> o1 + (1 :: int) \<longrightarrow> inv1 m (1 :: int) fempty \<and> (\<forall>(m1 :: int_IntInf.t t). (\<forall>(i :: int). ((1 :: int) \<le> i \<and> i \<le> o1) \<and> inv1 m1 i fempty \<longrightarrow> (\<forall>(es :: set). to_fset es = edges \<longrightarrow> (to_fset es |\<subseteq>| edges \<and> inv1 m1 i (edges |-| to_fset es)) \<and> (\<forall>(es1 :: set) (m2 :: int_IntInf.t t). to_fset es1 |\<subseteq>| edges \<and> inv1 m2 i (edges |-| to_fset es1) \<longrightarrow> (if \<not>to_fset es1 = fempty then let via :: (vertex \<times> vertex) fset = edges |-| to_fset es1 in \<not>to_fset es1 = fempty \<and> (\<forall>(es2 :: set). let o2 :: vertex \<times> vertex = choose1 es1 in o2 |\<in>| to_fset es1 \<and> to_fset es2 = fset_remove o2 (to_fset es1) \<longrightarrow> (case o2 of (u, v) \<Rightarrow> (((1 :: int) \<le> i \<and> (u, v) |\<in>| edges \<and> \<not>(u, v) |\<in>| via) \<and> inv1 m2 i via) \<and> (\<forall>(m3 :: int_IntInf.t t). inv1 m3 i (finsert (u, v) via) \<longrightarrow> ((0 :: int) \<le> int (fcard (to_fset es1)) \<and> fcard (to_fset es2) < fcard (to_fset es1)) \<and> to_fset es2 |\<subseteq>| edges \<and> inv1 m3 i (edges |-| to_fset es2)))) else inv1 m2 (i + (1 :: int)) fempty)))) \<and> (inv1 m1 (o1 + (1 :: int)) fempty \<longrightarrow> (\<forall>(es :: set). to_fset es = edges \<longrightarrow> (to_fset es |\<subseteq>| edges \<and> inv2 m1 (edges |-| to_fset es)) \<and> (\<forall>(es1 :: set). to_fset es1 |\<subseteq>| edges \<and> inv2 m1 (edges |-| to_fset es1) \<longrightarrow> (if \<not>to_fset es1 = fempty then \<not>to_fset es1 = fempty \<and> (\<forall>(es2 :: set). let o2 :: vertex \<times> vertex = choose1 es1 in o2 |\<in>| to_fset es1 \<and> to_fset es2 = fset_remove o2 (to_fset es1) \<longrightarrow> (case o2 of (u, v) \<Rightarrow> (let o3 :: int_IntInf.t = mixfix_lbrb m1 v in o3 = contents m1 v \<longrightarrow> (let o4 :: int_IntInf.t = mixfix_lbrb m1 u in o4 = contents m1 u \<longrightarrow> (if lt (add o4 (Finite (weight u v))) o3 then \<exists>(v1 :: vertex). negative_cycle v1 else ((0 :: int) \<le> int (fcard (to_fset es1)) \<and> fcard (to_fset es2) < fcard (to_fset es1)) \<and> to_fset es2 |\<subseteq>| edges \<and> inv2 m1 (edges |-| to_fset es2)))))) else \<forall>(v :: vertex). v |\<in>| vertices \<longrightarrow> (case mixfix_lbrb m1 v of Finite n \<Rightarrow> (\<exists>(l :: vertex list). path s l v \<and> path_weight l v = n) \<and> (\<forall>(l :: vertex list). path s l v \<longrightarrow> n \<le> path_weight l v) | Infinite \<Rightarrow> (\<forall>(l :: vertex list). \<not>path s l v)))))))) \<and> (o1 + (1 :: int) < (1 :: int) \<longrightarrow> (\<forall>(es :: set). to_fset es = edges \<longrightarrow> (to_fset es |\<subseteq>| edges \<and> inv2 m (edges |-| to_fset es)) \<and> (\<forall>(es1 :: set). to_fset es1 |\<subseteq>| edges \<and> inv2 m (edges |-| to_fset es1) \<longrightarrow> (if \<not>to_fset es1 = fempty then \<not>to_fset es1 = fempty \<and> (\<forall>(es2 :: set). let o2 :: vertex \<times> vertex = choose1 es1 in o2 |\<in>| to_fset es1 \<and> to_fset es2 = fset_remove o2 (to_fset es1) \<longrightarrow> (case o2 of (u, v) \<Rightarrow> (let o3 :: int_IntInf.t = mixfix_lbrb m v in o3 = contents m v \<longrightarrow> (let o4 :: int_IntInf.t = mixfix_lbrb m u in o4 = contents m u \<longrightarrow> (if lt (add o4 (Finite (weight u v))) o3 then \<exists>(v1 :: vertex). negative_cycle v1 else ((0 :: int) \<le> int (fcard (to_fset es1)) \<and> fcard (to_fset es2) < fcard (to_fset es1)) \<and> to_fset es2 |\<subseteq>| edges \<and> inv2 m (edges |-| to_fset es2)))))) else \<forall>(v :: vertex). v |\<in>| vertices \<longrightarrow> (case mixfix_lbrb m v of Finite n \<Rightarrow> (\<exists>(l :: vertex list). path s l v \<and> path_weight l v = n) \<and> (\<forall>(l :: vertex list). path s l v \<longrightarrow> n \<le> path_weight l v) | Infinite \<Rightarrow> (\<forall>(l :: vertex list). \<not>path s l v))))))"
  sorry
end
