theory bellman_ford_Graph_simple_pathqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  vertex
consts vertices :: "vertex fset"
consts edges :: "(vertex \<times> vertex) fset"
definition edge :: "vertex \<Rightarrow> vertex \<Rightarrow> _"
  where "edge x y \<longleftrightarrow> (x, y) |\<in>| edges" for x y
axiomatization where edges_def'0:   "x |\<in>| vertices"
 if "(x, y) |\<in>| edges"
  for x :: "vertex"
  and y :: "vertex"
axiomatization where edges_def'1:   "y |\<in>| vertices"
 if "(x, y) |\<in>| edges"
  for x :: "vertex"
  and y :: "vertex"
consts s :: "vertex"
axiomatization where s'def:   "s |\<in>| vertices"
inductive path :: "vertex \<Rightarrow> vertex list \<Rightarrow> vertex \<Rightarrow> bool" where
   Path_empty: "path x (Nil :: vertex list) x" for x :: "vertex"
 | Path_cons: "edge x y \<Longrightarrow> path y l z \<Longrightarrow> path x (Cons x l) z" for x :: "vertex" and y :: "vertex" and l :: "vertex list" and z :: "vertex"
axiomatization where path_right_extension:   "path x (l @ Cons y (Nil :: vertex list)) z"
 if "path x l y"
 and "edge y z"
  for x :: "vertex"
  and l :: "vertex list"
  and y :: "vertex"
  and z :: "vertex"
axiomatization where path_right_inversion:   "x = z \<and> l = (Nil :: vertex list) \<or> (\<exists>(y :: vertex) (l' :: vertex list). path x l' y \<and> edge y z \<and> l = l' @ Cons y (Nil :: vertex list))"
 if "path x l z"
  for x :: "vertex"
  and l :: "vertex list"
  and z :: "vertex"
axiomatization where path_trans:   "path x (l1 @ l2) z"
 if "path x l1 y"
 and "path y l2 z"
  for x :: "vertex"
  and l1 :: "vertex list"
  and y :: "vertex"
  and l2 :: "vertex list"
  and z :: "vertex"
axiomatization where empty_path:   "x = y"
 if "path x (Nil :: vertex list) y"
  for x :: "vertex"
  and y :: "vertex"
axiomatization where path_decomposition'0:   "path x l1 y"
 if "path x (l1 @ Cons y l2) z"
  for x :: "vertex"
  and l1 :: "vertex list"
  and y :: "vertex"
  and l2 :: "vertex list"
  and z :: "vertex"
axiomatization where path_decomposition'1:   "path y (Cons y l2) z"
 if "path x (l1 @ Cons y l2) z"
  for x :: "vertex"
  and l1 :: "vertex list"
  and y :: "vertex"
  and l2 :: "vertex list"
  and z :: "vertex"
consts weight :: "vertex \<Rightarrow> vertex \<Rightarrow> int"
fun path_weight :: "vertex list \<Rightarrow> vertex \<Rightarrow> int"
  where "path_weight (Nil :: vertex list) dst = (0 :: int)" for dst
      | "path_weight (Cons x (Nil :: vertex list)) dst = weight x dst" for x dst
      | "path_weight (Cons x (Cons y x0)) dst = weight x y + path_weight (Cons y x0) dst" for x y x0 dst
axiomatization where path_weight_right_extension:   "path_weight (l @ Cons x (Nil :: vertex list)) y = path_weight l x + weight x y"
  for l :: "vertex list"
  and x :: "vertex"
  and y :: "vertex"
axiomatization where path_weight_decomposition:   "path_weight (l1 @ Cons y l2) z = path_weight l1 y + path_weight (Cons y l2) z"
  for l1 :: "vertex list"
  and y :: "vertex"
  and l2 :: "vertex list"
  and z :: "vertex"
definition pigeon_set :: "vertex fset \<Rightarrow> _"
  where "pigeon_set s1 \<longleftrightarrow> (\<forall>(l :: vertex list). (\<forall>(e :: vertex). e \<in> set l \<longrightarrow> e |\<in>| s1) \<longrightarrow> fcard s1 < length l \<longrightarrow> (\<exists>(e :: vertex) (l1 :: vertex list) (l2 :: vertex list) (l3 :: vertex list). l = l1 @ Cons e (l2 @ Cons e l3)))" for s1
axiomatization where Induction:   "pigeon_set s1"
 if "\<forall>(s1 :: vertex fset). s1 = fempty \<longrightarrow> pigeon_set s1"
 and "\<forall>(s1 :: vertex fset). pigeon_set s1 \<longrightarrow> (\<forall>(t :: vertex). pigeon_set (finsert t s1))"
  for s1 :: "vertex fset"
axiomatization where corner:   "(\<exists>(e :: vertex) (l1 :: vertex list) (l2 :: vertex list) (l3 :: vertex list). l = l1 @ Cons e (l2 @ Cons e l3)) \<or> (\<forall>(e :: vertex). e |\<in>| s1 \<longrightarrow> e \<in> set l)"
 if "length l = fcard s1"
 and "\<forall>(e :: vertex). e \<in> set l \<longrightarrow> e |\<in>| s1"
  for l :: "vertex list"
  and s1 :: "vertex fset"
axiomatization where pigeon_0:   "pigeon_set fempty"
axiomatization where pigeon_1:   "pigeon_set (finsert t s1)"
 if "pigeon_set s1"
  for s1 :: "vertex fset"
  and t :: "vertex"
axiomatization where pigeon_2:   "pigeon_set s1"
  for s1 :: "vertex fset"
axiomatization where pigeonhole:   "\<exists>(e :: vertex) (l1 :: vertex list) (l2 :: vertex list) (l3 :: vertex list). l = l1 @ Cons e (l2 @ Cons e l3)"
 if "\<forall>(e :: vertex). e \<in> set l \<longrightarrow> e |\<in>| s1"
 and "fcard s1 < length l"
  for l :: "vertex list"
  and s1 :: "vertex fset"
definition cyc_decomp :: "vertex \<Rightarrow> vertex list \<Rightarrow> vertex \<Rightarrow> vertex list \<Rightarrow> vertex list \<Rightarrow> vertex list \<Rightarrow> _"
  where "cyc_decomp v l vi l1 l2 l3 \<longleftrightarrow> l = (l1 @ l2) @ l3 \<and> (0 :: int) < int (length l2) \<and> path s l1 vi \<and> path vi l2 vi \<and> path vi l3 v" for v l vi l1 l2 l3
theorem simple_path'vc:
  fixes l :: "vertex list"
  fixes v :: "vertex"
  assumes fact0: "path s l v"
  shows "\<exists>(l' :: vertex list). path s l' v \<and> length l' < fcard vertices"
  sorry
end
