From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Open Scope Z_scope.
Axiom vertex : Type.
Axiom vertex_inhabited : Inhabited vertex.
Global Existing Instance vertex_inhabited.
Axiom vertex_countable : Countable vertex.
Global Existing Instance vertex_countable.
Axiom vertices : gset vertex.
Axiom edges : gset (vertex * vertex).
Definition edge (x : vertex) (y : vertex) := (x, y) ∈ edges.
Axiom edges_def : forall  (x : vertex) (y : vertex) (fact0 : (x, y) ∈ edges), x ∈ vertices ∧ y ∈ vertices.
Axiom s : vertex.
Axiom s'def : s ∈ vertices.
Inductive path : vertex -> list vertex -> vertex -> Prop :=
 | Path_empty (x : vertex) : path x ([] : list vertex) x
 | Path_cons (x : vertex) (y : vertex) (l : list vertex) (z : vertex) : edge x y -> path y l z -> path x (cons x l) z.
Axiom path_right_extension : forall  (x : vertex) (l : list vertex) (y : vertex) (z : vertex) (fact0 : path x l y) (fact1 : edge y z), path x (l ++ cons y ([] : list vertex)) z.
Axiom path_right_inversion : forall  (x : vertex) (l : list vertex) (z : vertex) (fact0 : path x l z), x = z ∧ l = ([] : list vertex) ∨ (∃(y : vertex) (l' : list vertex), path x l' y ∧ edge y z ∧ l = l' ++ cons y ([] : list vertex)).
Axiom path_trans : forall  (x : vertex) (l1 : list vertex) (y : vertex) (l2 : list vertex) (z : vertex) (fact0 : path x l1 y) (fact1 : path y l2 z), path x (l1 ++ l2) z.
Axiom empty_path : forall  (x : vertex) (y : vertex) (fact0 : path x ([] : list vertex) y), x = y.
Axiom path_decomposition : forall  (x : vertex) (l1 : list vertex) (y : vertex) (l2 : list vertex) (z : vertex) (fact0 : path x (l1 ++ cons y l2) z), path x l1 y ∧ path y (cons y l2) z.
Axiom weight : vertex -> vertex -> Z.
Program Fixpoint path_weight (l : list vertex) (dst : vertex) : Z :=
match l with | [] => 0%Z | cons x [] => weight x dst | cons x (cons y _ as r) => weight x y + path_weight r dst end.
Admit Obligations.
Axiom path_weight_right_extension : forall  (l : list vertex) (x : vertex) (y : vertex), path_weight (l ++ cons x ([] : list vertex)) y = path_weight l x + weight x y.
Axiom path_weight_decomposition : forall  (l1 : list vertex) (y : vertex) (l2 : list vertex) (z : vertex), path_weight (l1 ++ cons y l2) z = path_weight l1 y + path_weight (cons y l2) z.
Theorem path_in_vertices'vc (v1 : vertex) (l : list vertex) (v2 : vertex) (fact0 : v1 ∈ vertices) (fact1 : path v1 l v2) : v2 ∈ vertices.
Admitted.
