theory bitwalker_Bitwalker_peekqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.WellFounded_WellFounded" "Why3STD.Ref_Ref" "mach.bv_BVCheck8" "mach.bv_BVCheck32" "mach.bv_BVCheck64"
begin
definition nth8_stream :: "8 word list \<Rightarrow> int \<Rightarrow> bool"
  where "nth8_stream stream pos = (take_bit (nat ((7 :: int) - pos emod (8 :: int))) (stream ! nat (pos ediv (8 :: int))) \<noteq> (0))" for stream pos
definition maxvalue :: "32 word \<Rightarrow> 64 word"
  where "maxvalue len = (1 :: 64 word) << unat (u32_to_u64 len)" for len
theorem peek'vc:
  fixes len :: "32 word"
  fixes start :: "32 word"
  fixes addr :: "8 word list"
  assumes fact0: "uint len \<le> (64 :: int)"
  assumes fact1: "uint start + uint len < (4294967296 :: int)"
  assumes fact2: "(8 :: int) * int (length addr) < (4294967296 :: int)"
  shows "uint start + uint len < (4294967296 :: int) \<or> u32_to_u128 start + u32_to_u128 len \<le> u32_to_u128 (4294967295 :: 32 word)"
  and "uint (start + len) = uint start + uint len \<longrightarrow> (if (8 :: int) * int (length addr) < uint (start + len) then uint start + uint len \<le> (8 :: int) * int (length addr) \<longrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < uint len \<longrightarrow> (take_bit (nat i) (0 :: 64 word) \<noteq> (0)) = nth8_stream addr (uint start + uint len - i - (1 :: int))) \<and> (\<forall>(i :: int). uint len \<le> i \<and> i < (64 :: int) \<longrightarrow> (take_bit (nat i) (0 :: 64 word) \<noteq> (0)) = False) else (uint len \<le> (64 :: int) \<or> (64 :: 32 word) \<ge> len) \<and> (let lstart :: 32 word = (64 :: 32 word) - len in uint lstart = (64 :: int) - uint len \<longrightarrow> (((0 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> uint len) \<and> (\<forall>(j :: int). uint len - (0 :: int) \<le> j \<and> j < uint len \<longrightarrow> (take_bit (nat j) (0 :: 64 word) \<noteq> (0)) = nth8_stream addr (uint start + uint len - j - (1 :: int))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < uint len - (0 :: int) \<longrightarrow> (take_bit (nat j) (0 :: 64 word) \<noteq> (0)) = False) \<and> (\<forall>(j :: int). uint len \<le> j \<and> j < (64 :: int) \<longrightarrow> (take_bit (nat j) (0 :: 64 word) \<noteq> (0)) = False)) \<and> (\<forall>(i :: 32 word) (retval :: 64 word). ((0 :: int) \<le> uint i \<and> uint i \<le> uint len) \<and> (\<forall>(j :: int). uint len - uint i \<le> j \<and> j < uint len \<longrightarrow> (take_bit (nat j) retval \<noteq> (0)) = nth8_stream addr (uint start + uint len - j - (1 :: int))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < uint len - uint i \<longrightarrow> (take_bit (nat j) retval \<noteq> (0)) = False) \<and> (\<forall>(j :: int). uint len \<le> j \<and> j < (64 :: int) \<longrightarrow> (take_bit (nat j) retval \<noteq> (0)) = False) \<longrightarrow> (if i < len then (uint start + uint i < (4294967296 :: int) \<or> u32_to_u128 start + u32_to_u128 i \<le> u32_to_u128 (4294967295 :: 32 word)) \<and> (uint (start + i) = uint start + uint i \<longrightarrow> ((8 :: int) * int (length addr) < (4294967296 :: int) \<and> uint (start + i) < (8 :: int) * int (length addr)) \<and> (uint lstart + uint i < (4294967296 :: int) \<or> u32_to_u128 lstart + u32_to_u128 i \<le> u32_to_u128 (4294967295 :: 32 word)) \<and> (uint (lstart + i) = uint lstart + uint i \<longrightarrow> uint (lstart + i) < (64 :: int) \<and> (\<forall>(o1 :: 64 word). (\<forall>(i1 :: int). ((0 :: int) \<le> i1 \<and> i1 < (64 :: int)) \<and> \<not>i1 = (63 :: int) - uint (lstart + i) \<longrightarrow> (take_bit (nat i1) o1 \<noteq> (0)) = (take_bit (nat i1) retval \<noteq> (0))) \<and> nth8_stream addr (uint (start + i)) = (take_bit (nat ((63 :: int) - uint (lstart + i))) o1 \<noteq> (0)) \<longrightarrow> (uint i + (1 :: int) < (4294967296 :: int) \<or> u32_to_u128 i + u32_to_u128 (1 :: 32 word) \<le> u32_to_u128 (4294967295 :: 32 word)) \<and> (uint (i + (1 :: 32 word)) = uint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> uint len - uint i \<and> uint len - uint (i + (1 :: 32 word)) < uint len - uint i) \<and> ((0 :: int) \<le> uint (i + (1 :: 32 word)) \<and> uint (i + (1 :: 32 word)) \<le> uint len) \<and> (\<forall>(j :: int). uint len - uint (i + (1 :: 32 word)) \<le> j \<and> j < uint len \<longrightarrow> (take_bit (nat j) o1 \<noteq> (0)) = nth8_stream addr (uint start + uint len - j - (1 :: int))) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < uint len - uint (i + (1 :: 32 word)) \<longrightarrow> (take_bit (nat j) o1 \<noteq> (0)) = False) \<and> (\<forall>(j :: int). uint len \<le> j \<and> j < (64 :: int) \<longrightarrow> (take_bit (nat j) o1 \<noteq> (0)) = False))))) else ((8 :: int) * int (length addr) < uint start + uint len \<longrightarrow> retval = (0 :: 64 word)) \<and> (uint start + uint len \<le> (8 :: int) * int (length addr) \<longrightarrow> (\<forall>(i1 :: int). (0 :: int) \<le> i1 \<and> i1 < uint len \<longrightarrow> (take_bit (nat i1) retval \<noteq> (0)) = nth8_stream addr (uint start + uint len - i1 - (1 :: int))) \<and> (\<forall>(i1 :: int). uint len \<le> i1 \<and> i1 < (64 :: int) \<longrightarrow> (take_bit (nat i1) retval \<noteq> (0)) = False))))))"
  sorry
end
