theory bitwalker_Bitwalker_pokeqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.WellFounded_WellFounded" "Why3STD.Ref_Ref" "mach.bv_BVCheck8" "mach.bv_BVCheck32" "mach.bv_BVCheck64"
begin
definition nth8_stream :: "8 word list \<Rightarrow> int \<Rightarrow> bool"
  where "nth8_stream stream pos = (take_bit (nat ((7 :: int) - pos emod (8 :: int))) (stream ! nat (pos ediv (8 :: int))) \<noteq> (0))" for stream pos
definition maxvalue :: "32 word \<Rightarrow> 64 word"
  where "maxvalue len = (1 :: 64 word) << unat (u32_to_u64 len)" for len
theorem poke'vc:
  fixes len :: "32 word"
  fixes start :: "32 word"
  fixes addr :: "8 word list"
  fixes "value" :: "64 word"
  assumes fact0: "uint len < (64 :: int)"
  assumes fact1: "uint start + uint len < (4294967296 :: int)"
  assumes fact2: "(8 :: int) * int (length addr) < (4294967296 :: int)"
  shows "uint start + uint len < (4294967296 :: int) \<or> u32_to_u128 start + u32_to_u128 len \<le> u32_to_u128 (4294967295 :: 32 word)"
  and "uint (start + len) = uint start + uint len \<longrightarrow> (if (8 :: int) * int (length addr) < uint (start + len) then (-(2 :: int) \<le> -(1 :: int) \<and> -(1 :: int) \<le> (0 :: int)) \<and> (8 :: int) * int (length addr) < uint start + uint len \<and> (-(1 :: int) = -(2 :: int) \<longleftrightarrow> uint (maxvalue len) \<le> uint value \<and> uint start + uint len \<le> (8 :: int) * int (length addr)) \<and> (-(1 :: int) = (0 :: int) \<longleftrightarrow> uint value < uint (maxvalue len) \<and> uint start + uint len \<le> (8 :: int) * int (length addr)) \<and> (-(1 :: int) = (0 :: int) \<longrightarrow> (\<forall>(i :: int). uint start \<le> i \<and> i < uint start + uint len \<longrightarrow> nth8_stream addr i = (take_bit (nat (uint len - i - (1 :: int) + uint start)) value \<noteq> (0)))) else if value \<ge> maxvalue len then (-(2 :: int) \<le> -(2 :: int) \<and> -(2 :: int) \<le> (0 :: int)) \<and> (-(2 :: int) = -(1 :: int) \<longleftrightarrow> (8 :: int) * int (length addr) < uint start + uint len) \<and> (uint (maxvalue len) \<le> uint value \<and> uint start + uint len \<le> (8 :: int) * int (length addr)) \<and> (-(2 :: int) = (0 :: int) \<longleftrightarrow> uint value < uint (maxvalue len) \<and> uint start + uint len \<le> (8 :: int) * int (length addr)) \<and> (-(2 :: int) = (0 :: int) \<longrightarrow> (\<forall>(i :: int). uint start \<le> i \<and> i < uint start + uint len \<longrightarrow> nth8_stream addr i = (take_bit (nat (uint len - i - (1 :: int) + uint start)) value \<noteq> (0)))) else (uint len \<le> (64 :: int) \<or> (64 :: 32 word) \<ge> len) \<and> (let lstart :: 32 word = (64 :: 32 word) - len in uint lstart = (64 :: int) - uint len \<longrightarrow> (((0 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> uint len) \<and> (\<forall>(j :: int). uint start \<le> j \<and> j < uint start + (0 :: int) \<longrightarrow> nth8_stream addr j = (take_bit (nat (uint len - j - (1 :: int) + uint start)) value \<noteq> (0)))) \<and> (\<forall>(i :: 32 word) (addr1 :: 8 word list). length addr1 = length addr \<longrightarrow> ((0 :: int) \<le> uint i \<and> uint i \<le> uint len) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < uint start \<longrightarrow> nth8_stream addr j = nth8_stream addr1 j) \<and> (\<forall>(j :: int). uint start \<le> j \<and> j < uint start + uint i \<longrightarrow> nth8_stream addr1 j = (take_bit (nat (uint len - j - (1 :: int) + uint start)) value \<noteq> (0))) \<and> (\<forall>(j :: int). uint start + uint i \<le> j \<and> j < (8 :: int) * int (length addr1) \<longrightarrow> nth8_stream addr1 j = nth8_stream addr j) \<longrightarrow> (if i < len then (uint lstart + uint i < (4294967296 :: int) \<or> u32_to_u128 lstart + u32_to_u128 i \<le> u32_to_u128 (4294967295 :: 32 word)) \<and> (uint (lstart + i) = uint lstart + uint i \<longrightarrow> uint (lstart + i) < (64 :: int) \<and> (uint start + uint i < (4294967296 :: int) \<or> u32_to_u128 start + u32_to_u128 i \<le> u32_to_u128 (4294967295 :: 32 word)) \<and> (uint (start + i) = uint start + uint i \<longrightarrow> ((8 :: int) * int (length addr1) < (4294967296 :: int) \<and> uint (start + i) < (8 :: int) * int (length addr1)) \<and> (\<forall>(addr2 :: 8 word list). length addr2 = length addr1 \<longrightarrow> (\<forall>(i1 :: int). (0 :: int) \<le> i1 \<and> i1 < (8 :: int) * int (length addr2) \<longrightarrow> \<not>i1 = uint (start + i) \<longrightarrow> nth8_stream addr2 i1 = nth8_stream addr1 i1) \<and> nth8_stream addr2 (uint (start + i)) = (take_bit (nat ((63 :: int) - uint (lstart + i))) value \<noteq> (0)) \<longrightarrow> (uint i + (1 :: int) < (4294967296 :: int) \<or> u32_to_u128 i + u32_to_u128 (1 :: 32 word) \<le> u32_to_u128 (4294967295 :: 32 word)) \<and> (uint (i + (1 :: 32 word)) = uint i + (1 :: int) \<longrightarrow> ((0 :: int) \<le> uint len - uint i \<and> uint len - uint (i + (1 :: 32 word)) < uint len - uint i) \<and> ((0 :: int) \<le> uint (i + (1 :: 32 word)) \<and> uint (i + (1 :: 32 word)) \<le> uint len) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < uint start \<longrightarrow> nth8_stream addr j = nth8_stream addr2 j) \<and> (\<forall>(j :: int). uint start \<le> j \<and> j < uint start + uint (i + (1 :: 32 word)) \<longrightarrow> nth8_stream addr2 j = (take_bit (nat (uint len - j - (1 :: int) + uint start)) value \<noteq> (0))) \<and> (\<forall>(j :: int). uint start + uint (i + (1 :: 32 word)) \<le> j \<and> j < (8 :: int) * int (length addr2) \<longrightarrow> nth8_stream addr2 j = nth8_stream addr j))))) else (-(2 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> (0 :: int)) \<and> ((0 :: int) = -(1 :: int) \<longleftrightarrow> (8 :: int) * int (length addr1) < uint start + uint len) \<and> ((0 :: int) = -(2 :: int) \<longleftrightarrow> uint (maxvalue len) \<le> uint value \<and> uint start + uint len \<le> (8 :: int) * int (length addr1)) \<and> (uint value < uint (maxvalue len) \<and> uint start + uint len \<le> (8 :: int) * int (length addr1)) \<and> (\<forall>(i1 :: int). (0 :: int) \<le> i1 \<and> i1 < uint start \<longrightarrow> nth8_stream addr i1 = nth8_stream addr1 i1) \<and> (\<forall>(i1 :: int). uint start \<le> i1 \<and> i1 < uint start + uint len \<longrightarrow> nth8_stream addr1 i1 = (take_bit (nat (uint len - i1 - (1 :: int) + uint start)) value \<noteq> (0))) \<and> (\<forall>(i1 :: int). uint start + uint len \<le> i1 \<and> i1 < (8 :: int) * int (length addr1) \<longrightarrow> nth8_stream addr1 i1 = nth8_stream addr i1)))))"
  sorry
end
