From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.bintree.Tree.
Require Import Why3.bintree.Size.
Require Import Why3.bintree.Occ.
Open Scope Z_scope.
Axiom elt : Type.
Axiom elt_inhabited : Inhabited elt.
Global Existing Instance elt_inhabited.
Axiom elt_countable : Countable elt.
Global Existing Instance elt_countable.
Axiom le : elt -> elt -> Prop.
Axiom Refl : forall  (x : elt), le x x.
Axiom Trans : forall  (x : elt) (y : elt) (z : elt) (fact0 : le x y) (fact1 : le y z), le x z.
Axiom Total : forall  (x : elt) (y : elt), le x y ∨ le y x.
Definition le_root (e : elt) (t : tree elt) := match t with | Empty => True | Node _ x _ => le e x end.
Program Fixpoint heap (t : tree elt) : Prop :=
match t with | Empty => True | Node l x r => le_root x l ∧ heap l ∧ le_root x r ∧ heap r end.
Admit Obligations.
Axiom minimum : tree elt -> elt.
Axiom minimum_def : forall  (l : tree elt) (x : elt) (r : tree elt), minimum (Node l x r) = x.
Definition is_minimum (x : elt) (t : tree elt) := mem x t ∧ (∀(e : elt), mem e t -> le x e).
Program Fixpoint inv (t : tree elt) : Prop :=
match t with | Empty => True | Node l _ r => (Size.size l = Size.size r ∨ Size.size l = Size.size r + 1%Z) ∧ inv l ∧ inv r end.
Admit Obligations.
Axiom empty : tree elt.
Axiom empty'def : heap empty ∧ inv empty ∧ Size.size empty = 0%Z ∧ (∀(e : elt), ¬ mem e empty).
Theorem diff'vc (t : tree elt) (m : Z) (fact0 : inv t) (fact1 : 0%Z ≤ m) (fact2 : m ≤ Size.size t) (fact3 : Size.size t ≤ m + 1%Z) : (match t with | Empty => True | Node l _ r => ¬ m = 0%Z -> ¬ 2%Z = 0%Z ∧ (if decide (Z.quot m 2%Z = 1%Z) then ¬ 2%Z = 0%Z ∧ (let o1 : Z := Z.rem m 2%Z in (match t with | Empty => False | Node f _ f1 => f = l ∨ f1 = l end) ∧ inv l ∧ 0%Z ≤ o1 ∧ o1 ≤ Size.size l ∧ Size.size l ≤ o1 + 1%Z) else ¬ 2%Z = 0%Z ∧ (let o1 : Z := Z.rem (m - 1%Z) 2%Z in (match t with | Empty => False | Node f _ f1 => f = r ∨ f1 = r end) ∧ inv r ∧ 0%Z ≤ o1 ∧ o1 ≤ Size.size r ∧ Size.size r ≤ o1 + 1%Z)) end) ∧ (∀(result : Z), (match t with | Empty => result = 0%Z | Node l _ r => (if decide (m = 0%Z) then result = 1%Z else if decide (Z.quot m 2%Z = 1%Z) then Size.size l = Z.rem m 2%Z + result else Size.size r = Z.rem (m - 1%Z) 2%Z + result) end) -> Size.size t = m + result).
Admitted.
