theory ccursor_PtrCursor_nextqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_MapEq" "mach.int_Unsigned" "mach.c_C"
begin
typedecl  cursor
consts current :: "cursor \<Rightarrow> 32 word ptr"
consts new :: "cursor \<Rightarrow> bool"
consts len :: "cursor \<Rightarrow> 32 word"
consts freed :: "cursor \<Rightarrow> bool"
consts bound :: "cursor \<Rightarrow> 32 word"
axiomatization where cursor'invariant'0:   "(0 :: int) < sint (len self)"
  for self :: "cursor"
axiomatization where cursor'invariant'1:   "\<not>freed self = True \<longrightarrow> plength (current self) = sint (len self) \<and> offset (current self) = (0 :: int) \<and> valid (current self) (sint (len self)) \<and> c_C.min (current self) = (0 :: int) \<and> c_C.max (current self) = sint (len self) \<and> is_not_null (current self) \<and> writable (current self) = True \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (len self) \<longrightarrow> sint (data (current self) ! nat i) < sint (bound self))"
  for self :: "cursor"
definition cursor'eq :: "cursor \<Rightarrow> cursor \<Rightarrow> _"
  where "cursor'eq a b \<longleftrightarrow> current a = current b \<and> new a = new b \<and> len a = len b \<and> freed a = freed b \<and> bound a = bound b" for a b
axiomatization where cursor'inj:   "a = b"
 if "cursor'eq a b"
  for a :: "cursor"
  and b :: "cursor"
theorem next'vc:
  fixes c :: "cursor"
  assumes fact0: "\<not>freed c = True"
  assumes fact1: "(0 :: int) < sint (bound c)"
  assumes fact2: "sint (bound c) < (2147483647 :: int)"
  shows "\<not>freed c = True"
  and "\<forall>(a :: 32 word list). int (length a) = plength (current c) \<and> map_eq_sub (nth a o nat) (pelts (current c)) (0 :: int) (sint (len c)) \<longrightarrow> (let n :: 32 word = len c; b :: 32 word = bound c in int'32_in_bounds (sint n - (1 :: int)) \<and> (\<forall>(o1 :: 32 word). sint o1 = sint n - (1 :: int) \<longrightarrow> ((-(1 :: int) \<le> sint o1 \<and> sint o1 < sint n) \<and> (\<forall>(s :: int). sint o1 < s \<and> s < sint (len c) \<longrightarrow> sint (a ! nat s) = sint b - (1 :: int))) \<and> (\<forall>(r :: 32 word). (-(1 :: int) \<le> sint r \<and> sint r < sint n) \<and> (\<forall>(s :: int). sint r < s \<and> s < sint (len c) \<longrightarrow> sint (a ! nat s) = sint b - (1 :: int)) \<longrightarrow> ((0 :: int) \<le> sint r \<longrightarrow> int'32_in_bounds (sint b - (1 :: int)) \<and> (\<forall>(o2 :: 32 word). sint o2 = sint b - (1 :: int) \<longrightarrow> (0 :: int) \<le> sint r \<and> sint r < int (length a))) \<and> (\<forall>(o2 :: bool). (if (0 :: int) \<le> sint r then \<exists>(o3 :: 32 word). sint o3 = sint b - (1 :: int) \<and> (let o4 :: 32 word = a ! nat (sint r) in o2 = (if o4 = o3 then True else False) \<and> (sint o4 = sint o3 \<longrightarrow> o2 = True)) else o2 = False) \<longrightarrow> (if o2 = True then int'32_in_bounds (sint r - (1 :: int)) \<and> (\<forall>(o3 :: 32 word). sint o3 = sint r - (1 :: int) \<longrightarrow> sint o3 < sint r \<and> (-(1 :: int) \<le> sint o3 \<and> sint o3 < sint n) \<and> (\<forall>(s :: int). sint o3 < s \<and> s < sint (len c) \<longrightarrow> sint (a ! nat s) = sint b - (1 :: int))) else if sint r < (0 :: int) then (0 :: int) < sint (len c) \<and> (\<not>freed c = True \<longrightarrow> plength (current c) = sint (len c) \<and> offset (current c) = (0 :: int) \<and> valid (current c) (sint (len c)) \<and> c_C.min (current c) = (0 :: int) \<and> c_C.max (current c) = sint (len c) \<and> is_not_null (current c) \<and> writable (current c) = True \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (len c) \<longrightarrow> sint (data (current c) ! nat i) < sint (bound c))) else ((0 :: int) \<le> sint r \<and> sint r < int (length a)) \<and> (let o3 :: 32 word = a ! nat (sint r) in int'32_in_bounds (sint o3 + (1 :: int)) \<and> (\<forall>(o4 :: 32 word). sint o4 = sint o3 + (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint r \<and> sint r < int (length a)) \<and> (\<forall>(c_current :: 32 word ptr). length (data c_current) = length a \<longrightarrow> length (data c_current) = length (data (current c)) \<and> offset c_current = offset (current c) \<and> c_C.min c_current = c_C.min (current c) \<and> c_C.max c_current = c_C.max (current c) \<and> writable c_current = writable (current c) \<and> zone1 c_current = zone1 (current c) \<longrightarrow> nth (data c_current) o nat = (nth a o nat)(sint r := o4) \<and> data c_current = a[nat (sint r) := o4] \<longrightarrow> int'32_in_bounds (sint n - (1 :: int)) \<and> (\<forall>(o5 :: 32 word). sint o5 = sint n - (1 :: int) \<longrightarrow> int'32_in_bounds (sint r + (1 :: int)) \<and> (\<forall>(o6 :: 32 word). sint o6 = sint r + (1 :: int) \<longrightarrow> (sint o6 \<le> sint o5 + (1 :: int) \<longrightarrow> ((\<forall>(j :: int). sint r + (1 :: int) \<le> j \<and> j < sint o6 \<longrightarrow> sint (data c_current ! nat j) = (0 :: int)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < sint r \<longrightarrow> data c_current ! nat j = a ! nat j) \<and> sint (data c_current ! nat (sint r)) = sint (a ! nat (sint r)) + (1 :: int)) \<and> (\<forall>(c_current1 :: 32 word ptr). length (data c_current1) = length (data c_current) \<longrightarrow> length (data c_current1) = length (data c_current) \<and> offset c_current1 = offset c_current \<and> c_C.min c_current1 = c_C.min c_current \<and> c_C.max c_current1 = c_C.max c_current \<and> writable c_current1 = writable c_current \<and> zone1 c_current1 = zone1 c_current \<longrightarrow> (\<forall>(i :: 32 word). let i1 :: int = sint i in (sint o6 \<le> i1 \<and> i1 \<le> sint o5) \<and> (\<forall>(j :: int). sint r + (1 :: int) \<le> j \<and> j < i1 \<longrightarrow> sint (data c_current1 ! nat j) = (0 :: int)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < sint r \<longrightarrow> data c_current1 ! nat j = a ! nat j) \<and> sint (data c_current1 ! nat (sint r)) = sint (a ! nat (sint r)) + (1 :: int) \<longrightarrow> ((0 :: int) \<le> sint i \<and> sint i < int (length (data c_current1))) \<and> (length ((data c_current1)[nat (sint i) := 0 :: 32 word]) = length (data c_current1) \<longrightarrow> nth ((data c_current1)[nat (sint i) := 0 :: 32 word]) o nat = (nth (data c_current1) o nat)(sint i := 0 :: 32 word) \<longrightarrow> (\<forall>(j :: int). sint r + (1 :: int) \<le> j \<and> j < i1 + (1 :: int) \<longrightarrow> sint ((data c_current1)[nat (sint i) := 0 :: 32 word] ! nat j) = (0 :: int)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < sint r \<longrightarrow> (data c_current1)[nat (sint i) := 0 :: 32 word] ! nat j = a ! nat j) \<and> sint ((data c_current1)[nat (sint i) := 0 :: 32 word] ! nat (sint r)) = sint (a ! nat (sint r)) + (1 :: int))) \<and> ((\<forall>(j :: int). sint r + (1 :: int) \<le> j \<and> j < sint o5 + (1 :: int) \<longrightarrow> sint (data c_current1 ! nat j) = (0 :: int)) \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < sint r \<longrightarrow> data c_current1 ! nat j = a ! nat j) \<and> sint (data c_current1 ! nat (sint r)) = sint (a ! nat (sint r)) + (1 :: int) \<longrightarrow> (0 :: int) < sint (len c) \<and> (\<not>freed c = True \<longrightarrow> plength c_current1 = sint (len c) \<and> offset c_current1 = (0 :: int) \<and> valid c_current1 (sint (len c)) \<and> c_C.min c_current1 = (0 :: int) \<and> c_C.max c_current1 = sint (len c) \<and> is_not_null c_current1 \<and> writable c_current1 = True \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (len c) \<longrightarrow> sint (data c_current1 ! nat i) < sint (bound c)))))) \<and> (sint o5 + (1 :: int) < sint o6 \<longrightarrow> (0 :: int) < sint (len c) \<and> (\<not>freed c = True \<longrightarrow> plength c_current = sint (len c) \<and> offset c_current = (0 :: int) \<and> valid c_current (sint (len c)) \<and> c_C.min c_current = (0 :: int) \<and> c_C.max c_current = sint (len c) \<and> is_not_null c_current \<and> writable c_current = True \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < sint (len c) \<longrightarrow> sint (data c_current ! nat i) < sint (bound c))))))))))))))"
  sorry
end
