From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import defunctionalization_vcg.defunctionalization.Expr.
Require Import defunctionalization_vcg.defunctionalization.DirectSem.
Require Import defunctionalization_vcg.defunctionalization.Defunctionalization.
Require Import defunctionalization_vcg.defunctionalization.SemWithError.
Open Scope Z_scope.
Inductive context :=
  | Empty : context
  | Left : context -> expr -> context
  | Right : Z -> context -> context.
Axiom context_inhabited : Inhabited context.
Global Existing Instance context_inhabited.
Axiom context_countable : Countable context.
Global Existing Instance context_countable.
Program Fixpoint size_c (c : context) : Z :=
match c with | Empty => 0%Z | Left c1 e => 2%Z + size_c c1 + Defunctionalization.size_e e | Right _ c1 => 1%Z + size_c c1 end.
Admit Obligations.
Theorem size_c_pos'vc (c : context) : 0%Z ≤ size_c c.
Admitted.
