theory division_Hoare_divisionqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
typedecl  integer
consts zero :: "integer"
consts one :: "integer"
consts infix_pl :: "integer \<Rightarrow> integer \<Rightarrow> integer"
consts infix_mn :: "integer \<Rightarrow> integer \<Rightarrow> integer"
consts infix_as :: "integer \<Rightarrow> integer \<Rightarrow> integer"
consts infix_lseq :: "integer \<Rightarrow> integer \<Rightarrow> bool"
axiomatization where A1:   "infix_pl x y = infix_pl y x"
  for x :: "integer"
  and y :: "integer"
axiomatization where A2:   "infix_as x y = infix_as y x"
  for x :: "integer"
  and y :: "integer"
axiomatization where A3:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "integer"
  and y :: "integer"
  and z :: "integer"
axiomatization where A4:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "integer"
  and y :: "integer"
  and z :: "integer"
axiomatization where A5:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "integer"
  and y :: "integer"
  and z :: "integer"
axiomatization where A6:   "infix_pl (infix_mn x y) y = x"
 if "infix_lseq y x"
  for y :: "integer"
  and x :: "integer"
axiomatization where A7:   "infix_pl x zero = x"
  for x :: "integer"
axiomatization where A8:   "infix_as x zero = zero"
  for x :: "integer"
axiomatization where A9:   "infix_as x one = x"
  for x :: "integer"
theorem division'vc:
  fixes x :: "integer"
  fixes y :: "integer"
  shows "x = infix_pl x (infix_as y zero)"
  and "\<forall>(q :: integer) (r :: integer). x = infix_pl r (infix_as y q) \<longrightarrow> (if infix_lseq y r then x = infix_pl (infix_mn r y) (infix_as y (infix_pl one q)) else \<not>infix_lseq y r \<and> x = infix_pl r (infix_as y q))"
  sorry
end
