theory euler011_ProductFour_find_maxqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.matrix_Matrix"
begin
datatype  direction = Left_bottom | Right_bottom | Bottom | Right
definition left_diag :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int option"
  where "left_diag m i j = (if i < rows m \<and> (0 :: int) \<le> j \<and> (3 :: int) \<le> i \<and> j < columns m - (3 :: int) then Some (elts m i j * elts m (i - (1 :: int)) (j + (1 :: int)) * elts m (i - (2 :: int)) (j + (2 :: int)) * elts m (i - (3 :: int)) (j + (3 :: int))) else None)" for m i j
definition right_diag :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int option"
  where "right_diag m i j = (if i < rows m - (3 :: int) \<and> (0 :: int) \<le> i \<and> j < columns m - (3 :: int) \<and> (0 :: int) \<le> j then Some (elts m i j * elts m (i + (1 :: int)) (j + (1 :: int)) * elts m (i + (2 :: int)) (j + (2 :: int)) * elts m (i + (3 :: int)) (j + (3 :: int))) else None)" for m i j
definition line :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int option"
  where "line m i j = (if ((0 :: int) \<le> j \<and> j < columns m) \<and> (0 :: int) \<le> i \<and> i < rows m - (3 :: int) then Some (elts m i j * elts m (i + (1 :: int)) j * elts m (i + (2 :: int)) j * elts m (i + (3 :: int)) j) else None)" for m i j
definition column :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int option"
  where "column m i j = (if ((0 :: int) \<le> i \<and> i < rows m) \<and> (0 :: int) \<le> j \<and> j < columns m - (3 :: int) then Some (elts m i j * elts m i (j + (1 :: int)) * elts m i (j + (2 :: int)) * elts m i (j + (3 :: int))) else None)" for m i j
definition compute4 :: "int matrix \<Rightarrow> int \<Rightarrow> int \<Rightarrow> direction \<Rightarrow> int option"
  where "compute4 m i j d = (if d = Left_bottom then left_diag m i j else if d = Right_bottom then right_diag m i j else if d = Bottom then column m i j else if d = Right then line m i j else None)" for m i j d
theorem find_max'vc:
  fixes m :: "int matrix"
  fixes o1 :: "int"
  assumes fact0: "(4 :: int) < rows m"
  assumes fact1: "(4 :: int) < columns m"
  assumes fact2: "case line m (0 :: int) (0 :: int) of None \<Rightarrow> o1 = (0 :: int) | Some v \<Rightarrow> o1 = v"
  shows "let o2 :: int = rows m - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> ((\<forall>(i' :: int) (j' :: int) (d :: direction). ((0 :: int) \<le> i' \<and> i' < (0 :: int)) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> o1)) \<and> Some o1 = compute4 m (0 :: int) (0 :: int) Right) \<and> (\<forall>(cur_d :: direction) (cur_j :: int) (cur_i :: int) (cur_max :: int). (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> o2) \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max)) \<and> Some cur_max = compute4 m cur_i cur_j cur_d \<longrightarrow> (let o3 :: int = columns m - (1 :: int) in ((0 :: int) \<le> o3 + (1 :: int) \<longrightarrow> (Some cur_max = compute4 m cur_i cur_j cur_d \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < (0 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max))) \<and> (\<forall>(cur_d1 :: direction) (cur_j1 :: int) (cur_i1 :: int) (cur_max1 :: int). (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o3) \<and> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max1)) \<longrightarrow> (case left_diag m i j of None \<Rightarrow> (case right_diag m i j of None \<Rightarrow> (case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max1)) | Some v \<Rightarrow> (if cur_max1 < v then Some v = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> v)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> cur_max1)))) | Some v \<Rightarrow> (if cur_max1 < v then case column m i j of None \<Rightarrow> Some v = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> v)) | Some v1 \<Rightarrow> (if v < v1 then Some v1 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) else Some v = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v))) else (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> cur_max1)) | Some v1 \<Rightarrow> (if cur_max1 < v1 then Some v1 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> cur_max1)))))) | Some v \<Rightarrow> (if cur_max1 < v then case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some v = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> v)) | Some v1 \<Rightarrow> (if v < v1 then Some v1 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) else Some v = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v)))) | Some v1 \<Rightarrow> (if v < v1 then case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) | Some v2 \<Rightarrow> (if v1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1))) else (case column m i j of None \<Rightarrow> Some v = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v)) | Some v2 \<Rightarrow> (if v < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v))))) else (case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> cur_max1)) | Some v1 \<Rightarrow> (if cur_max1 < v1 then Some v1 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> cur_max1)))) | Some v1 \<Rightarrow> (if cur_max1 < v1 then case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) | Some v2 \<Rightarrow> (if v1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1))) else (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> cur_max1)) | Some v2 \<Rightarrow> (if cur_max1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> cur_max1)))))))) | Some v \<Rightarrow> (if cur_max1 < v then case right_diag m i j of None \<Rightarrow> (case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> v)) | Some v1 \<Rightarrow> (if v < v1 then Some v1 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) else Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v)))) | Some v1 \<Rightarrow> (if v < v1 then case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) | Some v2 \<Rightarrow> (if v1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1))) else (case column m i j of None \<Rightarrow> Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v)) | Some v2 \<Rightarrow> (if v < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v)))))) | Some v1 \<Rightarrow> (if v < v1 then case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) | Some v2 \<Rightarrow> (if v1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1)))) | Some v2 \<Rightarrow> (if v1 < v2 then case column m i j of None \<Rightarrow> Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) | Some v3 \<Rightarrow> (if v2 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v2))) else (case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1)) | Some v3 \<Rightarrow> (if v1 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v1))))) else (case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v)) | Some v2 \<Rightarrow> (if v < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v)))) | Some v2 \<Rightarrow> (if v < v2 then case column m i j of None \<Rightarrow> Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) | Some v3 \<Rightarrow> (if v2 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v2))) else (case column m i j of None \<Rightarrow> Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v)) | Some v3 \<Rightarrow> (if v < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v = compute4 m i j Left_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v))))))) else (case right_diag m i j of None \<Rightarrow> (case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v1 \<Rightarrow> v1 \<le> cur_max1)) | Some v1 \<Rightarrow> (if cur_max1 < v1 then Some v1 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> cur_max1)))) | Some v1 \<Rightarrow> (if cur_max1 < v1 then case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) | Some v2 \<Rightarrow> (if v1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v1 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1))) else (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> cur_max1)) | Some v2 \<Rightarrow> (if cur_max1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> cur_max1)))))) | Some v1 \<Rightarrow> (if cur_max1 < v1 then case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> v1)) | Some v2 \<Rightarrow> (if v1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1)))) | Some v2 \<Rightarrow> (if v1 < v2 then case column m i j of None \<Rightarrow> Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) | Some v3 \<Rightarrow> (if v2 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v2))) else (case column m i j of None \<Rightarrow> Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v1)) | Some v3 \<Rightarrow> (if v1 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v1 = compute4 m i j Right_bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v1))))) else (case line m i j of None \<Rightarrow> (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v2 \<Rightarrow> v2 \<le> cur_max1)) | Some v2 \<Rightarrow> (if cur_max1 < v2 then Some v2 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> cur_max1)))) | Some v2 \<Rightarrow> (if cur_max1 < v2 then case column m i j of None \<Rightarrow> Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> v2)) | Some v3 \<Rightarrow> (if v2 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some v2 = compute4 m i j Right \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v2))) else (case column m i j of None \<Rightarrow> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v3 \<Rightarrow> v3 \<le> cur_max1)) | Some v3 \<Rightarrow> (if cur_max1 < v3 then Some v3 = compute4 m i j Bottom \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> v3)) else Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < j + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v4 \<Rightarrow> v4 \<le> cur_max1))))))))))) \<and> (Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 \<and> (\<forall>(i' :: int) (j' :: int) (d :: direction). i' = i \<and> (0 :: int) \<le> j' \<and> j' < o3 + (1 :: int) \<or> ((0 :: int) \<le> i' \<and> i' < i) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max1)) \<longrightarrow> (\<forall>(i' :: int) (j' :: int) (d :: direction). ((0 :: int) \<le> i' \<and> i' < i + (1 :: int)) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max1)) \<and> Some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1))) \<and> (o3 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(i' :: int) (j' :: int) (d :: direction). ((0 :: int) \<le> i' \<and> i' < i + (1 :: int)) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max)) \<and> Some cur_max = compute4 m cur_i cur_j cur_d))) \<and> ((\<forall>(i' :: int) (j' :: int) (d :: direction). ((0 :: int) \<le> i' \<and> i' < o2 + (1 :: int)) \<and> (0 :: int) \<le> j' \<and> j' < columns m \<longrightarrow> (case compute4 m i' j' d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max)) \<and> Some cur_max = compute4 m cur_i cur_j cur_d \<longrightarrow> (\<forall>(i :: int) (j :: int) (d :: direction). (case compute4 m i j d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> cur_max)) \<and> (\<exists>(i :: int) (j :: int) (d :: direction). Some cur_max = compute4 m i j d)))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(i :: int) (j :: int) (d :: direction). (case compute4 m i j d of None \<Rightarrow> True | Some v \<Rightarrow> v \<le> o1)) \<and> (\<exists>(i :: int) (j :: int) (d :: direction). Some o1 = compute4 m i j d))"
  sorry
end
