import Why3.Base
import Why3.why3.Ref.Ref
import Why3.matrix.Matrix
open Classical
open Lean4Why3
namespace euler011_ProductFour_find_maxqtvc
inductive direction where
  | Left_bottom : direction
  | Right_bottom : direction
  | Bottom : direction
  | Right : direction
axiom inhabited_axiom_direction : Inhabited direction
attribute [instance] inhabited_axiom_direction
noncomputable def left_diag (m : Matrix.matrix ℤ) (i : ℤ) (j : ℤ) := if i < Matrix.rows m ∧ (0 : ℤ) ≤ j ∧ (3 : ℤ) ≤ i ∧ j < Matrix.columns m - (3 : ℤ) then Option.some (Matrix.elts m i j * Matrix.elts m (i - (1 : ℤ)) (j + (1 : ℤ)) * Matrix.elts m (i - (2 : ℤ)) (j + (2 : ℤ)) * Matrix.elts m (i - (3 : ℤ)) (j + (3 : ℤ))) else Option.none
noncomputable def right_diag (m : Matrix.matrix ℤ) (i : ℤ) (j : ℤ) := if i < Matrix.rows m - (3 : ℤ) ∧ (0 : ℤ) ≤ i ∧ j < Matrix.columns m - (3 : ℤ) ∧ (0 : ℤ) ≤ j then Option.some (Matrix.elts m i j * Matrix.elts m (i + (1 : ℤ)) (j + (1 : ℤ)) * Matrix.elts m (i + (2 : ℤ)) (j + (2 : ℤ)) * Matrix.elts m (i + (3 : ℤ)) (j + (3 : ℤ))) else Option.none
noncomputable def line (m : Matrix.matrix ℤ) (i : ℤ) (j : ℤ) := if ((0 : ℤ) ≤ j ∧ j < Matrix.columns m) ∧ (0 : ℤ) ≤ i ∧ i < Matrix.rows m - (3 : ℤ) then Option.some (Matrix.elts m i j * Matrix.elts m (i + (1 : ℤ)) j * Matrix.elts m (i + (2 : ℤ)) j * Matrix.elts m (i + (3 : ℤ)) j) else Option.none
noncomputable def column (m : Matrix.matrix ℤ) (i : ℤ) (j : ℤ) := if ((0 : ℤ) ≤ i ∧ i < Matrix.rows m) ∧ (0 : ℤ) ≤ j ∧ j < Matrix.columns m - (3 : ℤ) then Option.some (Matrix.elts m i j * Matrix.elts m i (j + (1 : ℤ)) * Matrix.elts m i (j + (2 : ℤ)) * Matrix.elts m i (j + (3 : ℤ))) else Option.none
noncomputable def compute4 (m : Matrix.matrix ℤ) (i : ℤ) (j : ℤ) (d : direction) := if d = direction.Left_bottom then left_diag m i j else if d = direction.Right_bottom then right_diag m i j else if d = direction.Bottom then column m i j else if d = direction.Right then line m i j else Option.none
theorem find_max'vc (m : Matrix.matrix ℤ) (o1 : ℤ) (fact0 : (4 : ℤ) < Matrix.rows m) (fact1 : (4 : ℤ) < Matrix.columns m) (fact2 : match line m (0 : ℤ) (0 : ℤ) with | Option.none => o1 = (0 : ℤ) | Option.some v => o1 = v) : let o2 : ℤ := Matrix.rows m - (1 : ℤ); ((0 : ℤ) ≤ o2 + (1 : ℤ) → ((∀(i' : ℤ) (j' : ℤ) (d : direction), ((0 : ℤ) ≤ i' ∧ i' < (0 : ℤ)) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ o1)) ∧ Option.some o1 = compute4 m (0 : ℤ) (0 : ℤ) direction.Right) ∧ (∀(cur_d : direction) (cur_j : ℤ) (cur_i : ℤ) (cur_max : ℤ), (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i ≤ o2) ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max)) ∧ Option.some cur_max = compute4 m cur_i cur_j cur_d → (let o3 : ℤ := Matrix.columns m - (1 : ℤ); ((0 : ℤ) ≤ o3 + (1 : ℤ) → (Option.some cur_max = compute4 m cur_i cur_j cur_d ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < (0 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max))) ∧ (∀(cur_d1 : direction) (cur_j1 : ℤ) (cur_i1 : ℤ) (cur_max1 : ℤ), (∀(j : ℤ), ((0 : ℤ) ≤ j ∧ j ≤ o3) ∧ Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max1)) → (match left_diag m i j with | Option.none => (match right_diag m i j with | Option.none => (match line m i j with | Option.none => (match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max1)) | Option.some v => (if cur_max1 < v then Option.some v = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ v)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ cur_max1)))) | Option.some v => (if cur_max1 < v then match column m i j with | Option.none => Option.some v = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ v)) | Option.some v1 => (if v < v1 then Option.some v1 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) else Option.some v = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v))) else match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ cur_max1)) | Option.some v1 => (if cur_max1 < v1 then Option.some v1 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ cur_max1))))) | Option.some v => (if cur_max1 < v then match line m i j with | Option.none => (match column m i j with | Option.none => Option.some v = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ v)) | Option.some v1 => (if v < v1 then Option.some v1 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) else Option.some v = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v)))) | Option.some v1 => (if v < v1 then match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) | Option.some v2 => (if v1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1))) else match column m i j with | Option.none => Option.some v = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v)) | Option.some v2 => (if v < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v)))) else match line m i j with | Option.none => (match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ cur_max1)) | Option.some v1 => (if cur_max1 < v1 then Option.some v1 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ cur_max1)))) | Option.some v1 => (if cur_max1 < v1 then match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) | Option.some v2 => (if v1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1))) else match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ cur_max1)) | Option.some v2 => (if cur_max1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ cur_max1)))))) | Option.some v => (if cur_max1 < v then match right_diag m i j with | Option.none => (match line m i j with | Option.none => (match column m i j with | Option.none => Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ v)) | Option.some v1 => (if v < v1 then Option.some v1 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) else Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v)))) | Option.some v1 => (if v < v1 then match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) | Option.some v2 => (if v1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1))) else match column m i j with | Option.none => Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v)) | Option.some v2 => (if v < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v))))) | Option.some v1 => (if v < v1 then match line m i j with | Option.none => (match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) | Option.some v2 => (if v1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1)))) | Option.some v2 => (if v1 < v2 then match column m i j with | Option.none => Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) | Option.some v3 => (if v2 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v2))) else match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1)) | Option.some v3 => (if v1 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v1)))) else match line m i j with | Option.none => (match column m i j with | Option.none => Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v)) | Option.some v2 => (if v < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v)))) | Option.some v2 => (if v < v2 then match column m i j with | Option.none => Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) | Option.some v3 => (if v2 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v2))) else match column m i j with | Option.none => Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v)) | Option.some v3 => (if v < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v = compute4 m i j direction.Left_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v))))) else match right_diag m i j with | Option.none => (match line m i j with | Option.none => (match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v1 => v1 ≤ cur_max1)) | Option.some v1 => (if cur_max1 < v1 then Option.some v1 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ cur_max1)))) | Option.some v1 => (if cur_max1 < v1 then match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) | Option.some v2 => (if v1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v1 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1))) else match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ cur_max1)) | Option.some v2 => (if cur_max1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ cur_max1))))) | Option.some v1 => (if cur_max1 < v1 then match line m i j with | Option.none => (match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ v1)) | Option.some v2 => (if v1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1)))) | Option.some v2 => (if v1 < v2 then match column m i j with | Option.none => Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) | Option.some v3 => (if v2 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v2))) else match column m i j with | Option.none => Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v1)) | Option.some v3 => (if v1 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v1 = compute4 m i j direction.Right_bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v1)))) else match line m i j with | Option.none => (match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v2 => v2 ≤ cur_max1)) | Option.some v2 => (if cur_max1 < v2 then Option.some v2 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ cur_max1)))) | Option.some v2 => (if cur_max1 < v2 then match column m i j with | Option.none => Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ v2)) | Option.some v3 => (if v2 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some v2 = compute4 m i j direction.Right ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v2))) else match column m i j with | Option.none => Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v3 => v3 ≤ cur_max1)) | Option.some v3 => (if cur_max1 < v3 then Option.some v3 = compute4 m i j direction.Bottom ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ v3)) else Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < j + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v4 => v4 ≤ cur_max1)))))))) ∧ (Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1 ∧ (∀(i' : ℤ) (j' : ℤ) (d : direction), i' = i ∧ (0 : ℤ) ≤ j' ∧ j' < o3 + (1 : ℤ) ∨ ((0 : ℤ) ≤ i' ∧ i' < i) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max1)) → (∀(i' : ℤ) (j' : ℤ) (d : direction), ((0 : ℤ) ≤ i' ∧ i' < i + (1 : ℤ)) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max1)) ∧ Option.some cur_max1 = compute4 m cur_i1 cur_j1 cur_d1))) ∧ (o3 + (1 : ℤ) < (0 : ℤ) → (∀(i' : ℤ) (j' : ℤ) (d : direction), ((0 : ℤ) ≤ i' ∧ i' < i + (1 : ℤ)) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max)) ∧ Option.some cur_max = compute4 m cur_i cur_j cur_d))) ∧ ((∀(i' : ℤ) (j' : ℤ) (d : direction), ((0 : ℤ) ≤ i' ∧ i' < o2 + (1 : ℤ)) ∧ (0 : ℤ) ≤ j' ∧ j' < Matrix.columns m → (match compute4 m i' j' d with | Option.none => True | Option.some v => v ≤ cur_max)) ∧ Option.some cur_max = compute4 m cur_i cur_j cur_d → (∀(i : ℤ) (j : ℤ) (d : direction), match compute4 m i j d with | Option.none => True | Option.some v => v ≤ cur_max) ∧ (∃(i : ℤ) (j : ℤ) (d : direction), Option.some cur_max = compute4 m i j d)))) ∧ (o2 + (1 : ℤ) < (0 : ℤ) → (∀(i : ℤ) (j : ℤ) (d : direction), match compute4 m i j d with | Option.none => True | Option.some v => v ≤ o1) ∧ (∃(i : ℤ) (j : ℤ) (d : direction), Option.some o1 = compute4 m i j d))
  := sorry
end euler011_ProductFour_find_maxqtvc
