From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import euler_sieve_vcg.euler_sieve.ArithmeticResults.
Require Import euler_sieve_vcg.euler_sieve.DivisibilityResults.
Require Import euler_sieve_vcg.euler_sieve.EulerSieveSpec.
Require Import Why3.mach.array.ArrayInt63.
Open Scope Z_scope.
Axiom t : Type.
Axiom t_inhabited : Inhabited t.
Global Existing Instance t_inhabited.
Axiom t_countable : Countable t.
Global Existing Instance t_countable.
Axiom nexts : t -> list Z.
Axiom marked : t -> list bool.
Axiom arr : t -> ArrayInt63.array63.
Axiom max : t -> bv 63%N.
Axiom max_arr : t -> bv 63%N.
Axiom t'invariant : forall  (self : t), bv_signed (max self) < bv_signed int'63_max ∧ 3%Z ≤ bv_signed (max self) ∧ length (nexts self) = length (marked self) ∧ Z.of_nat (length (marked self)) = bv_signed (max self) + 1%Z ∧ ZEuclid.div (bv_signed (max self) - 1%Z) 2%Z = bv_signed (max_arr self) ∧ Z.of_nat (length (elts (arr self))) = bv_signed (max_arr self) + 1%Z ∧ inv_nexts (nexts self) (Z.of_nat (length (nexts self))) ∧ all_eliminated_marked (marked self) (nexts self) ∧ (∀(i : Z), 3%Z ≤ i ∧ i ≤ bv_signed (max self) -> ZEuclid.modulo i 2%Z = 0%Z -> nth (Z.to_nat i) (marked self) inhabitant = true) ∧ (∀(i : Z), 3%Z ≤ i ∧ i < bv_signed (max self) - 1%Z -> ZEuclid.modulo i 2%Z = 1%Z -> ZEuclid.modulo (nth (Z.to_nat i) (nexts self) inhabitant) 2%Z = 1%Z ∨ nth (Z.to_nat i) (nexts self) inhabitant = bv_signed (max self) + 1%Z) ∧ nth (Z.to_nat (bv_signed (max self))) (nexts self) inhabitant = bv_signed (max self) + 1%Z ∧ (ZEuclid.modulo (bv_signed (max self) - 1%Z) 2%Z = 0%Z -> nth (Z.to_nat (bv_signed (max self) - 1%Z)) (nexts self) inhabitant = bv_signed (max self)) ∧ (ZEuclid.modulo (bv_signed (max self) - 1%Z) 2%Z = 1%Z -> nth (Z.to_nat (bv_signed (max self) - 1%Z)) (nexts self) inhabitant = bv_signed (max self) + 1%Z) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ bv_signed (max_arr self) -> - (bv_signed (max self) + 1%Z) ≤ nth (Z.to_nat i) (elts (arr self)) inhabitant ∧ nth (Z.to_nat i) (elts (arr self)) inhabitant ≤ bv_signed (max self) + 1%Z) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ bv_signed (max_arr self) -> (nth (Z.to_nat (2%Z * i + 1%Z)) (marked self) inhabitant = true) = (nth (Z.to_nat i) (elts (arr self)) inhabitant < 0%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ bv_signed (max_arr self) -> ¬ nth (Z.to_nat (2%Z * i + 1%Z)) (marked self) inhabitant = true -> nth (Z.to_nat i) (elts (arr self)) inhabitant = nth (Z.to_nat (2%Z * i + 1%Z)) (nexts self) inhabitant) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ bv_signed (max_arr self) -> nth (Z.to_nat (2%Z * i + 1%Z)) (marked self) inhabitant = true -> nth (Z.to_nat i) (elts (arr self)) inhabitant = - nth (Z.to_nat (2%Z * i + 1%Z)) (nexts self) inhabitant) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ bv_signed (max_arr self) -> (i < ZEuclid.div (Z.abs (nth (Z.to_nat i) (elts (arr self)) inhabitant)) 2%Z ∧ ZEuclid.div (Z.abs (nth (Z.to_nat i) (elts (arr self)) inhabitant)) 2%Z ≤ bv_signed (max_arr self) + 1%Z) ∧ Z.abs (nth (Z.to_nat i) (elts (arr self)) inhabitant) ≤ bv_signed (max self) + 1%Z) ∧ (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i ≤ bv_signed (max_arr self) -> i < j ∧ j < ZEuclid.div (Z.abs (nth (Z.to_nat i) (elts (arr self)) inhabitant)) 2%Z -> nth (Z.to_nat j) (elts (arr self)) inhabitant < 0%Z).
Definition t'eq (a : t) (b : t) := nexts a = nexts b ∧ marked a = marked b ∧ arr a = arr b ∧ max a = max b ∧ max_arr a = max_arr b.
Axiom t'inj : forall  (a : t) (b : t) (fact0 : t'eq a b), a = b.
Definition inv_count (arr1 : list Z) (min : Z) := ∀(i : Z), min ≤ i ∧ i < Z.of_nat (length arr1) -> (i < ZEuclid.div (Z.abs (nth (Z.to_nat i) arr1 inhabitant)) 2%Z ∧ ZEuclid.div (Z.abs (nth (Z.to_nat i) arr1 inhabitant)) 2%Z ≤ Z.of_nat (length arr1)) ∧ (- bv_signed int'63_max ≤ nth (Z.to_nat i) arr1 inhabitant ∧ nth (Z.to_nat i) arr1 inhabitant ≤ bv_signed int'63_max) ∧ (∀(j : Z), i < j ∧ j < ZEuclid.div (Z.abs (nth (Z.to_nat i) arr1 inhabitant)) 2%Z -> nth (Z.to_nat j) arr1 inhabitant < 0%Z) ∧ (∀(j : Z), 2%Z * i + 1%Z < j ∧ j < Z.abs (nth (Z.to_nat i) arr1 inhabitant) -> ¬ prime j).
Theorem euler_sieve'vc (max1 : bv 63%N) (fact0 : bv_signed max1 < bv_signed int'63_max) (fact1 : 3%Z ≤ bv_signed max1) : bv_signed max1 < bv_signed int'63_max ∧ 3%Z ≤ bv_signed max1 ∧ (∀(t1 : t), max t1 = max1 ∧ ((nth 0%nat (marked t1) inhabitant = nth 1%nat (marked t1) inhabitant ∧ nth 1%nat (marked t1) inhabitant = true) ∧ ¬ nth 2%nat (marked t1) inhabitant = true) ∧ (∀(i : Z), 1%Z ≤ i ∧ i ≤ ZEuclid.div (bv_signed max1 - 1%Z) 2%Z -> ¬ nth (Z.to_nat (2%Z * i + 1%Z)) (marked t1) inhabitant = true) ∧ (∀(i : Z), 2%Z ≤ i ∧ i ≤ ZEuclid.div (bv_signed max1 + 1%Z) 2%Z -> 2%Z * i ≤ bv_signed max1 -> nth (Z.to_nat (2%Z * i)) (marked t1) inhabitant = true) ∧ (∀(i : Z), 1%Z ≤ i ∧ i ≤ ZEuclid.div (bv_signed max1 - 1%Z) 2%Z -> 2%Z * i + 1%Z < bv_signed max1 - 1%Z -> nth (Z.to_nat (2%Z * i + 1%Z)) (nexts t1) inhabitant = 2%Z * i + 3%Z) ∧ (∀(i : Z), 2%Z ≤ i ∧ i ≤ ZEuclid.div (bv_signed max1 - 1%Z) 2%Z -> 2%Z * i < bv_signed max1 - 1%Z -> nth (Z.to_nat (2%Z * i)) (nexts t1) inhabitant = 2%Z * i + 1%Z) ∧ (∀(i : Z), 0%Z ≤ i ∧ i ≤ bv_signed max1 -> nth (Z.to_nat i) (marked t1) inhabitant = true -> i < 2%Z ∨ (2%Z | i)) -> (∀(t2 : t), ArrayInt63.size (arr t2) = ArrayInt63.size (arr t1) -> (∀(n : bv 63%N), (max_arr t1 = max_arr t2 ∧ max t1 = max t2) ∧ (3%Z ≤ bv_signed n ∧ bv_signed n ≤ bv_signed max1) ∧ bv_signed n * bv_signed n ≤ bv_signed max1 ∧ previously_marked_multiples (marked t2) (bv_signed n) ∧ only_multiples_marked (marked t2) (bv_signed n) ∧ not_marked_impl_next_not_marked (marked t2) (nexts t2) (bv_signed n) ∧ inv_remove_products (nexts t2) (marked t2) (bv_signed n) -> (((3%Z ≤ bv_signed n ∧ bv_signed n ≤ bv_signed (max t2)) ∧ bv_signed n * bv_signed n ≤ bv_signed (max t2)) ∧ inv_remove_products (nexts t2) (marked t2) (bv_signed n) ∧ previously_marked_multiples (marked t2) (bv_signed n) ∧ only_multiples_marked (marked t2) (bv_signed n) ∧ not_marked_impl_next_not_marked (marked t2) (nexts t2) (bv_signed n)) ∧ (∀(t3 : t), ArrayInt63.size (arr t3) = ArrayInt63.size (arr t2) -> max_arr t2 = max_arr t3 ∧ max t2 = max t3 -> inv_remove_products (nexts t3) (marked t3) (bv_signed n) ∧ not_marked_impl_next_not_marked (marked t3) (nexts t3) (nth (Z.to_nat (bv_signed n)) (nexts t3) inhabitant) ∧ previously_marked_multiples (marked t3) (nth (Z.to_nat (bv_signed n)) (nexts t3) inhabitant) ∧ only_multiples_marked (marked t3) (nth (Z.to_nat (bv_signed n)) (nexts t3) inhabitant) -> ((3%Z ≤ bv_signed n ∧ bv_signed n ≤ bv_signed (max t3)) ∧ ZEuclid.modulo (bv_signed n) 2%Z = 1%Z) ∧ (∀(nn : bv 63%N), (3%Z ≤ bv_signed nn ∧ bv_signed nn ≤ bv_signed (max t3) + 1%Z) ∧ bv_signed nn = nth (Z.to_nat (bv_signed n)) (nexts t3) inhabitant ∧ (ZEuclid.modulo (bv_signed nn) 2%Z = 1%Z ∨ bv_signed nn = bv_signed (max t3) + 1%Z) -> (¬ bv_signed nn = 0%Z ∧ int'63_in_bounds (Z.rem (bv_signed max1) (bv_signed nn))) ∧ (∀(o1 : bv 63%N), bv_signed o1 = Z.rem (bv_signed max1) (bv_signed nn) -> (if decide (bv_signed nn ≤ bv_signed o1) then (0%Z ≤ bv_signed max1 + 1%Z - bv_signed n ∧ bv_signed max1 + 1%Z - bv_signed nn < bv_signed max1 + 1%Z - bv_signed n) ∧ (3%Z ≤ bv_signed nn ∧ bv_signed nn ≤ bv_signed max1) ∧ bv_signed nn * bv_signed nn ≤ bv_signed max1 ∧ previously_marked_multiples (marked t3) (bv_signed nn) ∧ only_multiples_marked (marked t3) (bv_signed nn) ∧ not_marked_impl_next_not_marked (marked t3) (nexts t3) (bv_signed nn) ∧ inv_remove_products (nexts t3) (marked t3) (bv_signed nn) else ∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length (marked t3)) -> (¬ nth (Z.to_nat i) (marked t3) inhabitant = true) = prime i)))))) ∧ (if decide (9%Z ≤ bv_signed max1) then ((3%Z ≤ 3%Z ∧ 3%Z ≤ bv_signed max1) ∧ 3%Z * 3%Z ≤ bv_signed max1 ∧ previously_marked_multiples (marked t1) 3%Z ∧ only_multiples_marked (marked t1) 3%Z ∧ not_marked_impl_next_not_marked (marked t1) (nexts t1) 3%Z ∧ inv_remove_products (nexts t1) (marked t1) 3%Z) ∧ (∀(t2 : t), ArrayInt63.size (arr t2) = ArrayInt63.size (arr t1) -> max_arr t1 = max_arr t2 ∧ max t1 = max t2 -> (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length (marked t2)) -> (¬ nth (Z.to_nat i) (marked t2) inhabitant = true) = prime i) -> (let o1 : ArrayInt63.array63 := arr t2 in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length (elts o1))) ∧ (∀(t_arr : ArrayInt63.array63), ArrayInt63.size t_arr = ArrayInt63.size o1 -> ArrayInt63.size t_arr = ArrayInt63.size (arr t2) -> elts t_arr = set_list (elts o1) 0%nat (bv_signed (2%bv : bv 63%N)) -> ((1%Z ≤ 1%Z ∧ 1%Z ≤ bv_signed (max_arr t2) + 1%Z) ∧ 1%Z ≤ 1%Z ∧ (2%Z * 1%Z + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth 1%nat (elts t_arr) inhabitant) ∧ (2%Z * 1%Z + 1%Z ≤ bv_signed max1 -> prime (2%Z * 1%Z + 1%Z)) ∧ inv_count (elts t_arr) 1%Z ∧ ordered (elts t_arr) 1%Z ∧ all_inf_or_eq (elts t_arr) 1%Z (2%Z * 1%Z) ∧ (∀(i : Z), 1%Z ≤ i ∧ i ≤ bv_signed (max_arr t2) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < 1%Z -> prime (nth (Z.to_nat i) (elts t_arr) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * 1%Z + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < 1%Z) ∧ nth (Z.to_nat j) (elts t_arr) inhabitant = i))) ∧ (∀(p : bv 63%N) (cnt : bv 63%N) (t_arr1 : ArrayInt63.array63), ArrayInt63.size t_arr1 = ArrayInt63.size t_arr -> (1%Z ≤ bv_signed p ∧ bv_signed p ≤ bv_signed (max_arr t2) + 1%Z) ∧ (1%Z ≤ bv_signed cnt ∧ bv_signed cnt ≤ bv_signed p) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed p + 1%Z)) ∧ inv_count (elts t_arr1) (bv_signed cnt) ∧ ordered (elts t_arr1) (bv_signed cnt) ∧ all_inf_or_eq (elts t_arr1) (bv_signed cnt) (2%Z * bv_signed p) ∧ (∀(i : Z), bv_signed cnt ≤ i ∧ i ≤ bv_signed (max_arr t2) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr1) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed cnt -> prime (nth (Z.to_nat i) (elts t_arr1) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed p + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed cnt) ∧ nth (Z.to_nat j) (elts t_arr1) inhabitant = i)) -> int'63_in_bounds (2%Z * bv_signed p) ∧ (∀(o2 : bv 63%N), bv_signed o2 = 2%Z * bv_signed p -> int'63_in_bounds (bv_signed o2 + 1%Z) ∧ (∀(o3 : bv 63%N), bv_signed o3 = bv_signed o2 + 1%Z -> (if decide (bv_signed o3 ≤ bv_signed max1) then (0%Z ≤ bv_signed p ∧ bv_signed p < Z.of_nat (length (elts t_arr1))) ∧ (∀(o4 : bv 63%N), bv_signed o4 = nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant -> (¬ 2%Z = 0%Z ∧ int'63_in_bounds (Z.rem (bv_signed o4) 2%Z)) ∧ (∀(next : bv 63%N), bv_signed next = Z.rem (bv_signed o4) 2%Z -> (if decide (bv_signed next ≤ bv_signed (max_arr t2)) then (0%Z ≤ bv_signed next ∧ bv_signed next < Z.of_nat (length (elts t_arr1))) ∧ (∀(o5 : bv 63%N), bv_signed o5 = nth (Z.to_nat (bv_signed next)) (elts t_arr1) inhabitant -> (if decide (bv_signed o5 < 0%Z) then (0%Z ≤ bv_signed next ∧ bv_signed next < Z.of_nat (length (elts t_arr1))) ∧ (∀(o6 : bv 63%N), bv_signed o6 = nth (Z.to_nat (bv_signed next)) (elts t_arr1) inhabitant -> int'63_in_bounds (- bv_signed o6) ∧ (∀(o7 : bv 63%N), bv_signed o7 = - bv_signed o6 -> (0%Z ≤ bv_signed p ∧ bv_signed p < Z.of_nat (length (elts t_arr1))) ∧ (∀(t_arr2 : ArrayInt63.array63), ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> elts t_arr2 = set_list (elts t_arr1) (Z.to_nat (bv_signed p)) (bv_signed o7) -> (0%Z ≤ bv_signed (max_arr t2) + 1%Z - bv_signed p ∧ bv_signed (max_arr t2) + 1%Z - bv_signed p < bv_signed (max_arr t2) + 1%Z - bv_signed p ∨ 0%Z ≤ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant ∧ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr2) inhabitant < bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (1%Z ≤ bv_signed p ∧ bv_signed p ≤ bv_signed (max_arr t2) + 1%Z) ∧ (1%Z ≤ bv_signed cnt ∧ bv_signed cnt ≤ bv_signed p) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed p)) (elts t_arr2) inhabitant) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed p + 1%Z)) ∧ inv_count (elts t_arr2) (bv_signed cnt) ∧ ordered (elts t_arr2) (bv_signed cnt) ∧ all_inf_or_eq (elts t_arr2) (bv_signed cnt) (2%Z * bv_signed p) ∧ (∀(i : Z), bv_signed cnt ≤ i ∧ i ≤ bv_signed (max_arr t2) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr2) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed cnt -> prime (nth (Z.to_nat i) (elts t_arr2) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed p + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed cnt) ∧ nth (Z.to_nat j) (elts t_arr2) inhabitant = i))))) else int'63_in_bounds (2%Z * bv_signed p) ∧ (∀(o6 : bv 63%N), bv_signed o6 = 2%Z * bv_signed p -> int'63_in_bounds (bv_signed o6 + 1%Z) ∧ (∀(o7 : bv 63%N), bv_signed o7 = bv_signed o6 + 1%Z -> (0%Z ≤ bv_signed cnt ∧ bv_signed cnt < Z.of_nat (length (elts t_arr1))) ∧ (∀(t_arr2 : ArrayInt63.array63), ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> elts t_arr2 = set_list (elts t_arr1) (Z.to_nat (bv_signed cnt)) (bv_signed o7) -> int'63_in_bounds (bv_signed cnt + 1%Z) ∧ (∀(o8 : bv 63%N), bv_signed o8 = bv_signed cnt + 1%Z -> (0%Z ≤ bv_signed (max_arr t2) + 1%Z - bv_signed p ∧ bv_signed (max_arr t2) + 1%Z - bv_signed next < bv_signed (max_arr t2) + 1%Z - bv_signed p ∨ bv_signed (max_arr t2) + 1%Z - bv_signed p = bv_signed (max_arr t2) + 1%Z - bv_signed next ∧ 0%Z ≤ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant ∧ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed next)) (elts t_arr2) inhabitant < bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (1%Z ≤ bv_signed next ∧ bv_signed next ≤ bv_signed (max_arr t2) + 1%Z) ∧ (1%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed next) ∧ (2%Z * bv_signed next + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed next)) (elts t_arr2) inhabitant) ∧ (2%Z * bv_signed next + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed next + 1%Z)) ∧ inv_count (elts t_arr2) (bv_signed o8) ∧ ordered (elts t_arr2) (bv_signed o8) ∧ all_inf_or_eq (elts t_arr2) (bv_signed o8) (2%Z * bv_signed next) ∧ (∀(i : Z), bv_signed o8 ≤ i ∧ i ≤ bv_signed (max_arr t2) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr2) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed o8 -> prime (nth (Z.to_nat i) (elts t_arr2) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed next + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed o8) ∧ nth (Z.to_nat j) (elts t_arr2) inhabitant = i)))))))) else int'63_in_bounds (2%Z * bv_signed p) ∧ (∀(o5 : bv 63%N), bv_signed o5 = 2%Z * bv_signed p -> int'63_in_bounds (bv_signed o5 + 1%Z) ∧ (∀(o6 : bv 63%N), bv_signed o6 = bv_signed o5 + 1%Z -> (0%Z ≤ bv_signed cnt ∧ bv_signed cnt < Z.of_nat (length (elts t_arr1))) ∧ (∀(t_arr2 : ArrayInt63.array63), ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> elts t_arr2 = set_list (elts t_arr1) (Z.to_nat (bv_signed cnt)) (bv_signed o6) -> int'63_in_bounds (bv_signed cnt + 1%Z) ∧ (∀(o7 : bv 63%N), bv_signed o7 = bv_signed cnt + 1%Z -> int'63_in_bounds (bv_signed (max_arr t2) + 1%Z) ∧ (∀(o8 : bv 63%N), bv_signed o8 = bv_signed (max_arr t2) + 1%Z -> (0%Z ≤ bv_signed (max_arr t2) + 1%Z - bv_signed p ∧ bv_signed (max_arr t2) + 1%Z - bv_signed o8 < bv_signed (max_arr t2) + 1%Z - bv_signed p ∨ bv_signed (max_arr t2) + 1%Z - bv_signed p = bv_signed (max_arr t2) + 1%Z - bv_signed o8 ∧ 0%Z ≤ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant ∧ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed o8)) (elts t_arr2) inhabitant < bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (1%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed (max_arr t2) + 1%Z) ∧ (1%Z ≤ bv_signed o7 ∧ bv_signed o7 ≤ bv_signed o8) ∧ (2%Z * bv_signed o8 + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed o8)) (elts t_arr2) inhabitant) ∧ (2%Z * bv_signed o8 + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed o8 + 1%Z)) ∧ inv_count (elts t_arr2) (bv_signed o7) ∧ ordered (elts t_arr2) (bv_signed o7) ∧ all_inf_or_eq (elts t_arr2) (bv_signed o7) (2%Z * bv_signed o8) ∧ (∀(i : Z), bv_signed o7 ≤ i ∧ i ≤ bv_signed (max_arr t2) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr2) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed o7 -> prime (nth (Z.to_nat i) (elts t_arr2) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed o8 + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed o7) ∧ nth (Z.to_nat j) (elts t_arr2) inhabitant = i)))))))))) else (0%Z ≤ 0%Z ∧ 0%Z ≤ bv_signed cnt ∧ 0%Z + bv_signed cnt ≤ Z.of_nat (length (elts t_arr1))) ∧ (∀(result : ArrayInt63.array63), Z.of_nat (length (elts result)) = bv_signed cnt ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed cnt -> nth (Z.to_nat i) (elts result) inhabitant = nth (Z.to_nat (0%Z + i)) (elts t_arr1) inhabitant) -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < Z.of_nat (length (elts result)) -> nth (Z.to_nat i) (elts result) inhabitant < nth (Z.to_nat j) (elts result) inhabitant) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length (elts result)) -> 2%Z ≤ nth (Z.to_nat i) (elts result) inhabitant ∧ nth (Z.to_nat i) (elts result) inhabitant ≤ bv_signed max1) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length (elts result)) -> prime (nth (Z.to_nat i) (elts result) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i ≤ bv_signed max1 -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < Z.of_nat (length (elts result))) ∧ nth (Z.to_nat j) (elts result) inhabitant = i)))))))))) else let o1 : ArrayInt63.array63 := arr t1 in (0%Z ≤ 0%Z ∧ 0%Z < Z.of_nat (length (elts o1))) ∧ (∀(t_arr : ArrayInt63.array63), ArrayInt63.size t_arr = ArrayInt63.size o1 -> ArrayInt63.size t_arr = ArrayInt63.size (arr t1) -> elts t_arr = set_list (elts o1) 0%nat (bv_signed (2%bv : bv 63%N)) -> ((1%Z ≤ 1%Z ∧ 1%Z ≤ bv_signed (max_arr t1) + 1%Z) ∧ 1%Z ≤ 1%Z ∧ (2%Z * 1%Z + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth 1%nat (elts t_arr) inhabitant) ∧ (2%Z * 1%Z + 1%Z ≤ bv_signed max1 -> prime (2%Z * 1%Z + 1%Z)) ∧ inv_count (elts t_arr) 1%Z ∧ ordered (elts t_arr) 1%Z ∧ all_inf_or_eq (elts t_arr) 1%Z (2%Z * 1%Z) ∧ (∀(i : Z), 1%Z ≤ i ∧ i ≤ bv_signed (max_arr t1) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < 1%Z -> prime (nth (Z.to_nat i) (elts t_arr) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * 1%Z + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < 1%Z) ∧ nth (Z.to_nat j) (elts t_arr) inhabitant = i))) ∧ (∀(p : bv 63%N) (cnt : bv 63%N) (t_arr1 : ArrayInt63.array63), ArrayInt63.size t_arr1 = ArrayInt63.size t_arr -> (1%Z ≤ bv_signed p ∧ bv_signed p ≤ bv_signed (max_arr t1) + 1%Z) ∧ (1%Z ≤ bv_signed cnt ∧ bv_signed cnt ≤ bv_signed p) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed p + 1%Z)) ∧ inv_count (elts t_arr1) (bv_signed cnt) ∧ ordered (elts t_arr1) (bv_signed cnt) ∧ all_inf_or_eq (elts t_arr1) (bv_signed cnt) (2%Z * bv_signed p) ∧ (∀(i : Z), bv_signed cnt ≤ i ∧ i ≤ bv_signed (max_arr t1) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr1) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed cnt -> prime (nth (Z.to_nat i) (elts t_arr1) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed p + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed cnt) ∧ nth (Z.to_nat j) (elts t_arr1) inhabitant = i)) -> int'63_in_bounds (2%Z * bv_signed p) ∧ (∀(o2 : bv 63%N), bv_signed o2 = 2%Z * bv_signed p -> int'63_in_bounds (bv_signed o2 + 1%Z) ∧ (∀(o3 : bv 63%N), bv_signed o3 = bv_signed o2 + 1%Z -> (if decide (bv_signed o3 ≤ bv_signed max1) then (0%Z ≤ bv_signed p ∧ bv_signed p < Z.of_nat (length (elts t_arr1))) ∧ (∀(o4 : bv 63%N), bv_signed o4 = nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant -> (¬ 2%Z = 0%Z ∧ int'63_in_bounds (Z.rem (bv_signed o4) 2%Z)) ∧ (∀(next : bv 63%N), bv_signed next = Z.rem (bv_signed o4) 2%Z -> (if decide (bv_signed next ≤ bv_signed (max_arr t1)) then (0%Z ≤ bv_signed next ∧ bv_signed next < Z.of_nat (length (elts t_arr1))) ∧ (∀(o5 : bv 63%N), bv_signed o5 = nth (Z.to_nat (bv_signed next)) (elts t_arr1) inhabitant -> (if decide (bv_signed o5 < 0%Z) then (0%Z ≤ bv_signed next ∧ bv_signed next < Z.of_nat (length (elts t_arr1))) ∧ (∀(o6 : bv 63%N), bv_signed o6 = nth (Z.to_nat (bv_signed next)) (elts t_arr1) inhabitant -> int'63_in_bounds (- bv_signed o6) ∧ (∀(o7 : bv 63%N), bv_signed o7 = - bv_signed o6 -> (0%Z ≤ bv_signed p ∧ bv_signed p < Z.of_nat (length (elts t_arr1))) ∧ (∀(t_arr2 : ArrayInt63.array63), ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> elts t_arr2 = set_list (elts t_arr1) (Z.to_nat (bv_signed p)) (bv_signed o7) -> (0%Z ≤ bv_signed (max_arr t1) + 1%Z - bv_signed p ∧ bv_signed (max_arr t1) + 1%Z - bv_signed p < bv_signed (max_arr t1) + 1%Z - bv_signed p ∨ 0%Z ≤ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant ∧ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr2) inhabitant < bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (1%Z ≤ bv_signed p ∧ bv_signed p ≤ bv_signed (max_arr t1) + 1%Z) ∧ (1%Z ≤ bv_signed cnt ∧ bv_signed cnt ≤ bv_signed p) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed p)) (elts t_arr2) inhabitant) ∧ (2%Z * bv_signed p + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed p + 1%Z)) ∧ inv_count (elts t_arr2) (bv_signed cnt) ∧ ordered (elts t_arr2) (bv_signed cnt) ∧ all_inf_or_eq (elts t_arr2) (bv_signed cnt) (2%Z * bv_signed p) ∧ (∀(i : Z), bv_signed cnt ≤ i ∧ i ≤ bv_signed (max_arr t1) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr2) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed cnt -> prime (nth (Z.to_nat i) (elts t_arr2) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed p + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed cnt) ∧ nth (Z.to_nat j) (elts t_arr2) inhabitant = i))))) else int'63_in_bounds (2%Z * bv_signed p) ∧ (∀(o6 : bv 63%N), bv_signed o6 = 2%Z * bv_signed p -> int'63_in_bounds (bv_signed o6 + 1%Z) ∧ (∀(o7 : bv 63%N), bv_signed o7 = bv_signed o6 + 1%Z -> (0%Z ≤ bv_signed cnt ∧ bv_signed cnt < Z.of_nat (length (elts t_arr1))) ∧ (∀(t_arr2 : ArrayInt63.array63), ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> elts t_arr2 = set_list (elts t_arr1) (Z.to_nat (bv_signed cnt)) (bv_signed o7) -> int'63_in_bounds (bv_signed cnt + 1%Z) ∧ (∀(o8 : bv 63%N), bv_signed o8 = bv_signed cnt + 1%Z -> (0%Z ≤ bv_signed (max_arr t1) + 1%Z - bv_signed p ∧ bv_signed (max_arr t1) + 1%Z - bv_signed next < bv_signed (max_arr t1) + 1%Z - bv_signed p ∨ bv_signed (max_arr t1) + 1%Z - bv_signed p = bv_signed (max_arr t1) + 1%Z - bv_signed next ∧ 0%Z ≤ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant ∧ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed next)) (elts t_arr2) inhabitant < bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (1%Z ≤ bv_signed next ∧ bv_signed next ≤ bv_signed (max_arr t1) + 1%Z) ∧ (1%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed next) ∧ (2%Z * bv_signed next + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed next)) (elts t_arr2) inhabitant) ∧ (2%Z * bv_signed next + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed next + 1%Z)) ∧ inv_count (elts t_arr2) (bv_signed o8) ∧ ordered (elts t_arr2) (bv_signed o8) ∧ all_inf_or_eq (elts t_arr2) (bv_signed o8) (2%Z * bv_signed next) ∧ (∀(i : Z), bv_signed o8 ≤ i ∧ i ≤ bv_signed (max_arr t1) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr2) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed o8 -> prime (nth (Z.to_nat i) (elts t_arr2) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed next + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed o8) ∧ nth (Z.to_nat j) (elts t_arr2) inhabitant = i)))))))) else int'63_in_bounds (2%Z * bv_signed p) ∧ (∀(o5 : bv 63%N), bv_signed o5 = 2%Z * bv_signed p -> int'63_in_bounds (bv_signed o5 + 1%Z) ∧ (∀(o6 : bv 63%N), bv_signed o6 = bv_signed o5 + 1%Z -> (0%Z ≤ bv_signed cnt ∧ bv_signed cnt < Z.of_nat (length (elts t_arr1))) ∧ (∀(t_arr2 : ArrayInt63.array63), ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> ArrayInt63.size t_arr2 = ArrayInt63.size t_arr1 -> elts t_arr2 = set_list (elts t_arr1) (Z.to_nat (bv_signed cnt)) (bv_signed o6) -> int'63_in_bounds (bv_signed cnt + 1%Z) ∧ (∀(o7 : bv 63%N), bv_signed o7 = bv_signed cnt + 1%Z -> int'63_in_bounds (bv_signed (max_arr t1) + 1%Z) ∧ (∀(o8 : bv 63%N), bv_signed o8 = bv_signed (max_arr t1) + 1%Z -> (0%Z ≤ bv_signed (max_arr t1) + 1%Z - bv_signed p ∧ bv_signed (max_arr t1) + 1%Z - bv_signed o8 < bv_signed (max_arr t1) + 1%Z - bv_signed p ∨ bv_signed (max_arr t1) + 1%Z - bv_signed p = bv_signed (max_arr t1) + 1%Z - bv_signed o8 ∧ 0%Z ≤ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant ∧ bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed o8)) (elts t_arr2) inhabitant < bv_signed max1 + 1%Z - nth (Z.to_nat (bv_signed p)) (elts t_arr1) inhabitant) ∧ (1%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed (max_arr t1) + 1%Z) ∧ (1%Z ≤ bv_signed o7 ∧ bv_signed o7 ≤ bv_signed o8) ∧ (2%Z * bv_signed o8 + 1%Z ≤ bv_signed max1 -> 0%Z ≤ nth (Z.to_nat (bv_signed o8)) (elts t_arr2) inhabitant) ∧ (2%Z * bv_signed o8 + 1%Z ≤ bv_signed max1 -> prime (2%Z * bv_signed o8 + 1%Z)) ∧ inv_count (elts t_arr2) (bv_signed o7) ∧ ordered (elts t_arr2) (bv_signed o7) ∧ all_inf_or_eq (elts t_arr2) (bv_signed o7) (2%Z * bv_signed o8) ∧ (∀(i : Z), bv_signed o7 ≤ i ∧ i ≤ bv_signed (max_arr t1) -> (0%Z ≤ nth (Z.to_nat i) (elts t_arr2) inhabitant) = prime (2%Z * i + 1%Z)) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed o7 -> prime (nth (Z.to_nat i) (elts t_arr2) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i < 2%Z * bv_signed o8 + 1%Z -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < bv_signed o7) ∧ nth (Z.to_nat j) (elts t_arr2) inhabitant = i)))))))))) else (0%Z ≤ 0%Z ∧ 0%Z ≤ bv_signed cnt ∧ 0%Z + bv_signed cnt ≤ Z.of_nat (length (elts t_arr1))) ∧ (∀(result : ArrayInt63.array63), Z.of_nat (length (elts result)) = bv_signed cnt ∧ (∀(i : Z), 0%Z ≤ i ∧ i < bv_signed cnt -> nth (Z.to_nat i) (elts result) inhabitant = nth (Z.to_nat (0%Z + i)) (elts t_arr1) inhabitant) -> (∀(i : Z) (j : Z), 0%Z ≤ i ∧ i < j ∧ j < Z.of_nat (length (elts result)) -> nth (Z.to_nat i) (elts result) inhabitant < nth (Z.to_nat j) (elts result) inhabitant) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length (elts result)) -> 2%Z ≤ nth (Z.to_nat i) (elts result) inhabitant ∧ nth (Z.to_nat i) (elts result) inhabitant ≤ bv_signed max1) ∧ (∀(i : Z), 0%Z ≤ i ∧ i < Z.of_nat (length (elts result)) -> prime (nth (Z.to_nat i) (elts result) inhabitant)) ∧ (∀(i : Z), 2%Z ≤ i ∧ i ≤ bv_signed max1 -> prime i -> (∃(j : Z), (0%Z ≤ j ∧ j < Z.of_nat (length (elts result))) ∧ nth (Z.to_nat j) (elts result) inhabitant = i)))))))))).
Admitted.
