theory fenwick_Fenwick_queryqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_Sum"
begin
datatype  fenwick = fenwick'mk (t: "int list") (leaves: "int")
definition valid :: "fenwick \<Rightarrow> _"
  where "valid f \<longleftrightarrow> (0 :: int) \<le> leaves f \<and> int (length (t f)) = (if leaves f = (0 :: int) then 0 :: int else (2 :: int) * leaves f - (1 :: int)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < leaves f - (1 :: int) \<longrightarrow> t f ! nat i = t f ! nat ((2 :: int) * i + (1 :: int)) + t f ! nat ((2 :: int) * i + (2 :: int)))" for f
definition get :: "fenwick \<Rightarrow> int \<Rightarrow> int"
  where "get f i = t f ! nat (i + leaves f - (1 :: int))" for f i
consts get_closure :: "fenwick \<Rightarrow> int \<Rightarrow> int"
axiomatization where get_closure_def:   "get_closure y y1 = get y y1"
  for y :: "fenwick"
  and y1 :: "int"
definition rget :: "fenwick \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
  where "rget f a b = sum (get_closure f) a b" for f a b
consts mixfix_lbrb_closure :: "'a list \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where mixfix_lbrb_closure_def:   "mixfix_lbrb_closure y y1 = y ! nat y1"
  for y :: "'a list"
  and y1 :: "int"
theorem query'vc:
  fixes a :: "int"
  fixes b :: "int"
  fixes f :: "fenwick"
  assumes fact0: "(0 :: int) \<le> a"
  assumes fact1: "a \<le> b"
  assumes fact2: "b \<le> leaves f"
  assumes fact3: "valid f"
  shows "\<not>(2 :: int) = (0 :: int)"
  and "let lv :: int = int (length (t f)) cdiv (2 :: int); o1 :: int = a + lv; o2 :: int = b + lv in a \<le> b \<and> ((\<forall>(f1 :: int \<Rightarrow> int) (g :: int \<Rightarrow> int). (\<forall>(i :: int). a \<le> i \<and> i < b \<longrightarrow> f1 i = g (i + lv)) \<longrightarrow> sum f1 a b = sum g (a + lv) (b + lv)) \<longrightarrow> (((0 :: int) \<le> o1 \<and> o1 \<le> o2 \<and> o2 \<le> int (length (t f))) \<and> (0 :: int) + sum (mixfix_lbrb_closure (t f)) o1 o2 = rget f a b) \<and> (\<forall>(acc :: int) (rb :: int) (ra :: int). ((0 :: int) \<le> ra \<and> ra \<le> rb \<and> rb \<le> int (length (t f))) \<and> acc + sum (mixfix_lbrb_closure (t f)) ra rb = rget f a b \<longrightarrow> (if \<not>ra = rb then \<not>(2 :: int) = (0 :: int) \<and> (if ra cmod (2 :: int) = (0 :: int) then let o3 :: int list = t f in ((0 :: int) \<le> ra \<and> ra < int (length o3)) \<and> \<not>(2 :: int) = (0 :: int) \<and> \<not>(2 :: int) = (0 :: int) \<and> (if \<not>(rb - (1 :: int)) cmod (2 :: int) = (0 :: int) then let o4 :: int list = t f in ((0 :: int) \<le> rb - (1 :: int) \<and> rb - (1 :: int) < int (length o4)) \<and> \<not>(2 :: int) = (0 :: int) \<and> (((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int)) \<and> (2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) < int (length (t f)) \<and> valid f) \<and> (sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = sum (mixfix_lbrb_closure (t f)) ((2 :: int) * (ra cdiv (2 :: int)) + (1 :: int)) ((2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) + (1 :: int)) \<longrightarrow> ((0 :: int) \<le> rb - ra \<and> (rb - (1 :: int)) cdiv (2 :: int) - ra cdiv (2 :: int) < rb - ra) \<and> ((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int) \<and> (rb - (1 :: int)) cdiv (2 :: int) \<le> int (length (t f))) \<and> acc + o3 ! nat ra + o4 ! nat (rb - (1 :: int)) + sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = rget f a b) else \<not>(2 :: int) = (0 :: int) \<and> (((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int)) \<and> (2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) < int (length (t f)) \<and> valid f) \<and> (sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = sum (mixfix_lbrb_closure (t f)) ((2 :: int) * (ra cdiv (2 :: int)) + (1 :: int)) ((2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) + (1 :: int)) \<longrightarrow> ((0 :: int) \<le> rb - ra \<and> (rb - (1 :: int)) cdiv (2 :: int) - ra cdiv (2 :: int) < rb - ra) \<and> ((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int) \<and> (rb - (1 :: int)) cdiv (2 :: int) \<le> int (length (t f))) \<and> acc + o3 ! nat ra + sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = rget f a b)) else \<not>(2 :: int) = (0 :: int) \<and> \<not>(2 :: int) = (0 :: int) \<and> (if \<not>(rb - (1 :: int)) cmod (2 :: int) = (0 :: int) then let o3 :: int list = t f in ((0 :: int) \<le> rb - (1 :: int) \<and> rb - (1 :: int) < int (length o3)) \<and> \<not>(2 :: int) = (0 :: int) \<and> (((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int)) \<and> (2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) < int (length (t f)) \<and> valid f) \<and> (sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = sum (mixfix_lbrb_closure (t f)) ((2 :: int) * (ra cdiv (2 :: int)) + (1 :: int)) ((2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) + (1 :: int)) \<longrightarrow> ((0 :: int) \<le> rb - ra \<and> (rb - (1 :: int)) cdiv (2 :: int) - ra cdiv (2 :: int) < rb - ra) \<and> ((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int) \<and> (rb - (1 :: int)) cdiv (2 :: int) \<le> int (length (t f))) \<and> acc + o3 ! nat (rb - (1 :: int)) + sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = rget f a b) else \<not>(2 :: int) = (0 :: int) \<and> (((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int)) \<and> (2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) < int (length (t f)) \<and> valid f) \<and> (sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = sum (mixfix_lbrb_closure (t f)) ((2 :: int) * (ra cdiv (2 :: int)) + (1 :: int)) ((2 :: int) * ((rb - (1 :: int)) cdiv (2 :: int)) + (1 :: int)) \<longrightarrow> ((0 :: int) \<le> rb - ra \<and> (rb - (1 :: int)) cdiv (2 :: int) - ra cdiv (2 :: int) < rb - ra) \<and> ((0 :: int) \<le> ra cdiv (2 :: int) \<and> ra cdiv (2 :: int) \<le> (rb - (1 :: int)) cdiv (2 :: int) \<and> (rb - (1 :: int)) cdiv (2 :: int) \<le> int (length (t f))) \<and> acc + sum (mixfix_lbrb_closure (t f)) (ra cdiv (2 :: int)) ((rb - (1 :: int)) cdiv (2 :: int)) = rget f a b))) else acc = rget f a b)))"
  sorry
end
