import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.Sum
open Classical
open Lean4Why3
namespace fenwick_Fenwick_addqtvc
structure fenwick where
  t : List ℤ
  leaves : ℤ
axiom inhabited_axiom_fenwick : Inhabited fenwick
attribute [instance] inhabited_axiom_fenwick
noncomputable def valid (f : fenwick) := (0 : ℤ) ≤ fenwick.leaves f ∧ Int.ofNat (List.length (fenwick.t f)) = (if fenwick.leaves f = (0 : ℤ) then (0 : ℤ) else (2 : ℤ) * fenwick.leaves f - (1 : ℤ)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < fenwick.leaves f - (1 : ℤ) → (fenwick.t f)[Int.toNat i]! = (fenwick.t f)[Int.toNat ((2 : ℤ) * i + (1 : ℤ))]! + (fenwick.t f)[Int.toNat ((2 : ℤ) * i + (2 : ℤ))]!)
noncomputable def get (f : fenwick) (i : ℤ) := (fenwick.t f)[Int.toNat (i + fenwick.leaves f - (1 : ℤ))]!
axiom get_closure : fenwick -> ℤ -> ℤ
axiom get_closure_def (y : fenwick) (y1 : ℤ) : get_closure y y1 = get y y1
noncomputable def rget (f : fenwick) (a : ℤ) (b : ℤ) := int.Sum.sum (get_closure f) a b
theorem add'vc (l : ℤ) (f : fenwick) (x : ℤ) (fact0 : (0 : ℤ) ≤ l) (fact1 : l < fenwick.leaves f) (fact2 : valid f) : ¬(2 : ℤ) = (0 : ℤ) ∧ (let o1 : ℤ := Int.tdiv (Int.ofNat (List.length (fenwick.t f))) (2 : ℤ) + l; let o2 : List ℤ := fenwick.t f; ((0 : ℤ) ≤ o1 ∧ o1 < Int.ofNat (List.length o2)) ∧ (let o3 : ℤ := o2[Int.toNat o1]! + x; let o4 : List ℤ := fenwick.t f; ((0 : ℤ) ≤ o1 ∧ o1 < Int.ofNat (List.length o4)) ∧ (∀(f1 : fenwick), let o5 : List ℤ := fenwick.t f1; List.length (fenwick.t f1) = List.length o4 → f1 = fenwick.mk (fenwick.t f1) (fenwick.leaves f) ∧ List.length (fenwick.t f1) = List.length (fenwick.t f) → getElem! o5 ∘ Int.toNat = Function.update (getElem! o4 ∘ Int.toNat) o1 o3 ∧ o5 = List.set o4 (Int.toNat o1) o3 → (((0 : ℤ) ≤ o1 ∧ o1 < Int.ofNat (List.length (fenwick.t f1))) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < fenwick.leaves f1 - (1 : ℤ) → (fenwick.t f1)[Int.toNat i]! = (fenwick.t f1)[Int.toNat ((2 : ℤ) * i + (1 : ℤ))]! + (fenwick.t f1)[Int.toNat ((2 : ℤ) * i + (2 : ℤ))]! - (if (2 : ℤ) * i + (1 : ℤ) ≤ o1 ∧ o1 ≤ (2 : ℤ) * i + (2 : ℤ) then x else (0 : ℤ)))) ∧ (∀(lc : ℤ) (f2 : fenwick), f2 = fenwick.mk (fenwick.t f2) (fenwick.leaves f1) ∧ List.length (fenwick.t f2) = List.length (fenwick.t f1) → ((0 : ℤ) ≤ lc ∧ lc < Int.ofNat (List.length (fenwick.t f2))) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < fenwick.leaves f2 - (1 : ℤ) → (fenwick.t f2)[Int.toNat i]! = (fenwick.t f2)[Int.toNat ((2 : ℤ) * i + (1 : ℤ))]! + (fenwick.t f2)[Int.toNat ((2 : ℤ) * i + (2 : ℤ))]! - (if (2 : ℤ) * i + (1 : ℤ) ≤ lc ∧ lc ≤ (2 : ℤ) * i + (2 : ℤ) then x else (0 : ℤ))) ∧ (∀(i : ℤ), fenwick.leaves f2 - (1 : ℤ) ≤ i ∧ i < Int.ofNat (List.length (fenwick.t f2)) → (fenwick.t f2)[Int.toNat i]! = (fenwick.t f1)[Int.toNat i]!) → (if ¬lc = (0 : ℤ) then ¬(2 : ℤ) = (0 : ℤ) ∧ (let o6 : List ℤ := fenwick.t f2; ((0 : ℤ) ≤ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length o6)) ∧ (let o7 : ℤ := o6[Int.toNat (Int.tdiv (lc - (1 : ℤ)) (2 : ℤ))]! + x; let o8 : List ℤ := fenwick.t f2; ((0 : ℤ) ≤ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length o8)) ∧ (∀(f3 : fenwick), let o9 : List ℤ := fenwick.t f3; List.length (fenwick.t f3) = List.length o8 → f3 = fenwick.mk (fenwick.t f3) (fenwick.leaves f2) ∧ List.length (fenwick.t f3) = List.length (fenwick.t f2) → getElem! o9 ∘ Int.toNat = Function.update (getElem! o8 ∘ Int.toNat) (Int.tdiv (lc - (1 : ℤ)) (2 : ℤ)) o7 ∧ o9 = List.set o8 (Int.toNat (Int.tdiv (lc - (1 : ℤ)) (2 : ℤ))) o7 → ((0 : ℤ) ≤ lc ∧ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) < lc) ∧ ((0 : ℤ) ≤ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length (fenwick.t f3))) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < fenwick.leaves f3 - (1 : ℤ) → (fenwick.t f3)[Int.toNat i]! = (fenwick.t f3)[Int.toNat ((2 : ℤ) * i + (1 : ℤ))]! + (fenwick.t f3)[Int.toNat ((2 : ℤ) * i + (2 : ℤ))]! - (if (2 : ℤ) * i + (1 : ℤ) ≤ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (lc - (1 : ℤ)) (2 : ℤ) ≤ (2 : ℤ) * i + (2 : ℤ) then x else (0 : ℤ))) ∧ (∀(i : ℤ), fenwick.leaves f3 - (1 : ℤ) ≤ i ∧ i < Int.ofNat (List.length (fenwick.t f3)) → (fenwick.t f3)[Int.toNat i]! = (fenwick.t f1)[Int.toNat i]!)))) else valid f2 ∧ (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i < fenwick.leaves f2) ∧ ¬i = l → get f2 i = get f i) ∧ get f2 l = get f l + x)))))
  := sorry
end fenwick_Fenwick_addqtvc
