import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.Sum
open Classical
open Lean4Why3
namespace fenwick_Fenwick_queryqtvc
structure fenwick where
  t : List ℤ
  leaves : ℤ
axiom inhabited_axiom_fenwick : Inhabited fenwick
attribute [instance] inhabited_axiom_fenwick
noncomputable def valid (f : fenwick) := (0 : ℤ) ≤ fenwick.leaves f ∧ Int.ofNat (List.length (fenwick.t f)) = (if fenwick.leaves f = (0 : ℤ) then (0 : ℤ) else (2 : ℤ) * fenwick.leaves f - (1 : ℤ)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < fenwick.leaves f - (1 : ℤ) → (fenwick.t f)[Int.toNat i]! = (fenwick.t f)[Int.toNat ((2 : ℤ) * i + (1 : ℤ))]! + (fenwick.t f)[Int.toNat ((2 : ℤ) * i + (2 : ℤ))]!)
noncomputable def get (f : fenwick) (i : ℤ) := (fenwick.t f)[Int.toNat (i + fenwick.leaves f - (1 : ℤ))]!
axiom get_closure : fenwick -> ℤ -> ℤ
axiom get_closure_def (y : fenwick) (y1 : ℤ) : get_closure y y1 = get y y1
noncomputable def rget (f : fenwick) (a : ℤ) (b : ℤ) := int.Sum.sum (get_closure f) a b
axiom mixfix_lbrb_closure :  {α : Type} -> [Inhabited α] -> List α -> ℤ -> α
axiom mixfix_lbrb_closure_def {α : Type} [Inhabited α] (y : List α) (y1 : ℤ) : mixfix_lbrb_closure y y1 = y[Int.toNat y1]!
theorem query'vc (a : ℤ) (b : ℤ) (f : fenwick) (fact0 : (0 : ℤ) ≤ a) (fact1 : a ≤ b) (fact2 : b ≤ fenwick.leaves f) (fact3 : valid f) : ¬(2 : ℤ) = (0 : ℤ) ∧ (let lv : ℤ := Int.tdiv (Int.ofNat (List.length (fenwick.t f))) (2 : ℤ); let o1 : ℤ := a + lv; let o2 : ℤ := b + lv; a ≤ b ∧ ((∀(f1 : ℤ -> ℤ) (g : ℤ -> ℤ), (∀(i : ℤ), a ≤ i ∧ i < b → f1 i = g (i + lv)) → int.Sum.sum f1 a b = int.Sum.sum g (a + lv) (b + lv)) → (((0 : ℤ) ≤ o1 ∧ o1 ≤ o2 ∧ o2 ≤ Int.ofNat (List.length (fenwick.t f))) ∧ (0 : ℤ) + int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) o1 o2 = rget f a b) ∧ (∀(acc : ℤ) (rb : ℤ) (ra : ℤ), ((0 : ℤ) ≤ ra ∧ ra ≤ rb ∧ rb ≤ Int.ofNat (List.length (fenwick.t f))) ∧ acc + int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) ra rb = rget f a b → (if ¬ra = rb then ¬(2 : ℤ) = (0 : ℤ) ∧ (if Int.tmod ra (2 : ℤ) = (0 : ℤ) then let o3 : List ℤ := fenwick.t f; ((0 : ℤ) ≤ ra ∧ ra < Int.ofNat (List.length o3)) ∧ ¬(2 : ℤ) = (0 : ℤ) ∧ ¬(2 : ℤ) = (0 : ℤ) ∧ (if ¬Int.tmod (rb - (1 : ℤ)) (2 : ℤ) = (0 : ℤ) then let o4 : List ℤ := fenwick.t f; ((0 : ℤ) ≤ rb - (1 : ℤ) ∧ rb - (1 : ℤ) < Int.ofNat (List.length o4)) ∧ ¬(2 : ℤ) = (0 : ℤ) ∧ (((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) ∧ (2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length (fenwick.t f)) ∧ valid f) ∧ (int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) ((2 : ℤ) * Int.tdiv ra (2 : ℤ) + (1 : ℤ)) ((2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) + (1 : ℤ)) → ((0 : ℤ) ≤ rb - ra ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) - Int.tdiv ra (2 : ℤ) < rb - ra) ∧ ((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ≤ Int.ofNat (List.length (fenwick.t f))) ∧ acc + o3[Int.toNat ra]! + o4[Int.toNat (rb - (1 : ℤ))]! + int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = rget f a b) else ¬(2 : ℤ) = (0 : ℤ) ∧ (((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) ∧ (2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length (fenwick.t f)) ∧ valid f) ∧ (int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) ((2 : ℤ) * Int.tdiv ra (2 : ℤ) + (1 : ℤ)) ((2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) + (1 : ℤ)) → ((0 : ℤ) ≤ rb - ra ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) - Int.tdiv ra (2 : ℤ) < rb - ra) ∧ ((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ≤ Int.ofNat (List.length (fenwick.t f))) ∧ acc + o3[Int.toNat ra]! + int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = rget f a b)) else ¬(2 : ℤ) = (0 : ℤ) ∧ ¬(2 : ℤ) = (0 : ℤ) ∧ (if ¬Int.tmod (rb - (1 : ℤ)) (2 : ℤ) = (0 : ℤ) then let o3 : List ℤ := fenwick.t f; ((0 : ℤ) ≤ rb - (1 : ℤ) ∧ rb - (1 : ℤ) < Int.ofNat (List.length o3)) ∧ ¬(2 : ℤ) = (0 : ℤ) ∧ (((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) ∧ (2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length (fenwick.t f)) ∧ valid f) ∧ (int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) ((2 : ℤ) * Int.tdiv ra (2 : ℤ) + (1 : ℤ)) ((2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) + (1 : ℤ)) → ((0 : ℤ) ≤ rb - ra ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) - Int.tdiv ra (2 : ℤ) < rb - ra) ∧ ((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ≤ Int.ofNat (List.length (fenwick.t f))) ∧ acc + o3[Int.toNat (rb - (1 : ℤ))]! + int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = rget f a b) else ¬(2 : ℤ) = (0 : ℤ) ∧ (((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) ∧ (2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) < Int.ofNat (List.length (fenwick.t f)) ∧ valid f) ∧ (int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) ((2 : ℤ) * Int.tdiv ra (2 : ℤ) + (1 : ℤ)) ((2 : ℤ) * Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) + (1 : ℤ)) → ((0 : ℤ) ≤ rb - ra ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) - Int.tdiv ra (2 : ℤ) < rb - ra) ∧ ((0 : ℤ) ≤ Int.tdiv ra (2 : ℤ) ∧ Int.tdiv ra (2 : ℤ) ≤ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ∧ Int.tdiv (rb - (1 : ℤ)) (2 : ℤ) ≤ Int.ofNat (List.length (fenwick.t f))) ∧ acc + int.Sum.sum (mixfix_lbrb_closure (fenwick.t f)) (Int.tdiv ra (2 : ℤ)) (Int.tdiv (rb - (1 : ℤ)) (2 : ℤ)) = rget f a b))) else acc = rget f a b))))
  := sorry
end fenwick_Fenwick_queryqtvc
