theory fibonacci_Mat22
  imports "NTP4Verif.NTP4Verif"
begin
datatype  t = t'mk (a11: "int") (a12: "int") (a21: "int") (a22: "int")
definition mult :: "t \<Rightarrow> t \<Rightarrow> t"
  where "mult x y = t'mk (a11 x * a11 y + a12 x * a21 y) (a11 x * a12 y + a12 x * a22 y) (a21 x * a11 y + a22 x * a21 y) (a21 x * a12 y + a22 x * a22 y)" for x y
consts power :: "t \<Rightarrow> int \<Rightarrow> t"
axiomatization where Power_0:   "power x (0 :: int) = t'mk (1 :: int) (0 :: int) (0 :: int) (1 :: int)"
  for x :: "t"
axiomatization where Power_s:   "power x (n + (1 :: int)) = mult x (power x n)"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "t"
axiomatization where Power_s_alt:   "power x n = mult x (power x (n - (1 :: int)))"
 if "(0 :: int) < n"
  for n :: "int"
  and x :: "t"
axiomatization where Power_1:   "power x (1 :: int) = x"
  for x :: "t"
axiomatization where Power_sum:   "power x (n + m) = mult (power x n) (power x m)"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "t"
axiomatization where Power_mult:   "power x (n * m) = power (power x n) m"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "t"
axiomatization where Power_comm1:   "mult (power x n) y = mult y (power x n)"
 if "mult x y = mult y x"
 and "(0 :: int) \<le> n"
  for x :: "t"
  and y :: "t"
  and n :: "int"
axiomatization where Power_comm2:   "power (mult x y) n = mult (power x n) (power y n)"
 if "mult x y = mult y x"
 and "(0 :: int) \<le> n"
  for x :: "t"
  and y :: "t"
  and n :: "int"
end
