theory fibonacci_Zeckendorf_zeckendorf_fastqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_Fibonacci" "./fibonacci_SmallestFibAbove"
begin
fun sum :: "int list \<Rightarrow> int"
  where "sum (Nil :: int list) = (0 :: int)"
      | "sum (Cons k r) = fib k + sum r" for k r
fun wf :: "int \<Rightarrow> int list \<Rightarrow> _"
  where "wf min (Nil :: int list) = True" for min
      | "wf min (Cons k r) = (min \<le> k \<and> wf (k + (2 :: int)) r)" for min k r
theorem zeckendorf_fast'vc:
  fixes n :: "int"
  assumes fact0: "(0 :: int) \<le> n"
  shows "if n = (0 :: int) then let result :: int list = (Nil :: int list) in wf (2 :: int) result \<and> n = sum result else (((1 :: int) \<le> (1 :: int) \<and> ((1 :: int) = fib (1 :: int) \<and> fib (1 :: int) \<le> n) \<and> (1 :: int) = fib ((1 :: int) + (1 :: int))) \<and> (1 :: int) \<le> (1 :: int)) \<and> (\<forall>(k :: int). ((1 :: int) \<le> k \<and> fib k \<le> n) \<and> (1 :: int) \<le> fib k \<and> (1 :: int) \<le> fib (k + (1 :: int)) \<longrightarrow> (if fib (k + (1 :: int)) \<le> n then ((0 :: int) \<le> (2 :: int) * n - (fib k + fib (k + (1 :: int))) \<and> (2 :: int) * n - (fib (k + (1 :: int)) + (fib k + fib (k + (1 :: int)))) < (2 :: int) * n - (fib k + fib (k + (1 :: int)))) \<and> ((1 :: int) \<le> k + (1 :: int) \<and> fib (k + (1 :: int)) \<le> n \<and> fib k + fib (k + (1 :: int)) = fib (k + (1 :: int) + (1 :: int))) \<and> (1 :: int) \<le> fib (k + (1 :: int)) \<and> (1 :: int) \<le> fib k + fib (k + (1 :: int)) else let o1 :: int list = Cons k (Nil :: int list); o2 :: int = n - fib k in (((1 :: int) \<le> k \<and> fib k \<le> n \<and> o2 < fib (k + (1 :: int))) \<and> ((1 :: int) \<le> fib k \<and> (1 :: int) \<le> fib (k + (1 :: int))) \<and> ((0 :: int) \<le> o2 \<and> o2 \<le> n) \<and> wf (2 :: int) o1 \<and> o2 + sum o1 = n \<and> o2 < fib (k - (1 :: int))) \<and> (\<forall>(x :: int) (l :: int list) (k1 :: int). ((1 :: int) \<le> k1 \<and> fib k1 \<le> n \<and> x < fib (k1 + (1 :: int))) \<and> ((1 :: int) \<le> fib k1 \<and> (1 :: int) \<le> fib (k1 + (1 :: int))) \<and> ((0 :: int) \<le> x \<and> x \<le> n) \<and> wf (2 :: int) l \<and> x + sum l = n \<and> (case l of Nil \<Rightarrow> True | Cons k2 _ \<Rightarrow> x < fib (k2 - (1 :: int))) \<longrightarrow> (if (0 :: int) < x then if fib k1 \<le> x then ((0 :: int) \<le> k1 \<and> k1 - (1 :: int) < k1) \<and> ((1 :: int) \<le> k1 - (1 :: int) \<and> (fib (k1 + (1 :: int)) - fib k1 = fib (k1 - (1 :: int)) \<and> fib (k1 - (1 :: int)) \<le> n) \<and> x - fib k1 < fib k1 \<and> fib k1 = fib (k1 - (1 :: int) + (1 :: int))) \<and> ((1 :: int) \<le> fib (k1 + (1 :: int)) - fib k1 \<and> (1 :: int) \<le> fib k1) \<and> ((0 :: int) \<le> x - fib k1 \<and> x - fib k1 \<le> n) \<and> wf (2 :: int) (Cons k1 l) \<and> x - fib k1 + sum (Cons k1 l) = n \<and> (case Cons k1 l of Nil \<Rightarrow> True | Cons k2 _ \<Rightarrow> x - fib k1 < fib (k2 - (1 :: int))) else ((0 :: int) \<le> k1 \<and> k1 - (1 :: int) < k1) \<and> ((1 :: int) \<le> k1 - (1 :: int) \<and> (fib (k1 + (1 :: int)) - fib k1 = fib (k1 - (1 :: int)) \<and> fib (k1 - (1 :: int)) \<le> n) \<and> x < fib k1 \<and> fib k1 = fib (k1 - (1 :: int) + (1 :: int))) \<and> ((1 :: int) \<le> fib (k1 + (1 :: int)) - fib k1 \<and> (1 :: int) \<le> fib k1) \<and> ((0 :: int) \<le> x \<and> x \<le> n) \<and> wf (2 :: int) l \<and> x + sum l = n \<and> (case l of Nil \<Rightarrow> True | Cons k2 _ \<Rightarrow> x < fib (k2 - (1 :: int))) else wf (2 :: int) l \<and> n = sum l))))"
  sorry
end
