import Why3.Base
import Why3.why3.Ref.Ref
import Why3.int.Fibonacci
import pearl.fibonacci_vcg.lean.fibonacci.SmallestFibAbove
open Classical
open Lean4Why3
namespace fibonacci_Zeckendorf_zeckendorf_fastqtvc
noncomputable def sum : List ℤ -> ℤ
  | ([] : List ℤ) => (0 : ℤ)
  | (List.cons k r) => Fibonacci.fib k + sum r
noncomputable def wf : ℤ -> List ℤ -> Prop
  | min, ([] : List ℤ) => True
  | min, (List.cons k r) => min ≤ k ∧ wf (k + (2 : ℤ)) r
theorem zeckendorf_fast'vc (n : ℤ) (fact0 : (0 : ℤ) ≤ n) : if n = (0 : ℤ) then let result : List ℤ := ([] : List ℤ); wf (2 : ℤ) result ∧ n = sum result else (((1 : ℤ) ≤ (1 : ℤ) ∧ ((1 : ℤ) = Fibonacci.fib (1 : ℤ) ∧ Fibonacci.fib (1 : ℤ) ≤ n) ∧ (1 : ℤ) = Fibonacci.fib ((1 : ℤ) + (1 : ℤ))) ∧ (1 : ℤ) ≤ (1 : ℤ)) ∧ (∀(k : ℤ), ((1 : ℤ) ≤ k ∧ Fibonacci.fib k ≤ n) ∧ (1 : ℤ) ≤ Fibonacci.fib k ∧ (1 : ℤ) ≤ Fibonacci.fib (k + (1 : ℤ)) → (if Fibonacci.fib (k + (1 : ℤ)) ≤ n then ((0 : ℤ) ≤ (2 : ℤ) * n - (Fibonacci.fib k + Fibonacci.fib (k + (1 : ℤ))) ∧ (2 : ℤ) * n - (Fibonacci.fib (k + (1 : ℤ)) + (Fibonacci.fib k + Fibonacci.fib (k + (1 : ℤ)))) < (2 : ℤ) * n - (Fibonacci.fib k + Fibonacci.fib (k + (1 : ℤ)))) ∧ ((1 : ℤ) ≤ k + (1 : ℤ) ∧ Fibonacci.fib (k + (1 : ℤ)) ≤ n ∧ Fibonacci.fib k + Fibonacci.fib (k + (1 : ℤ)) = Fibonacci.fib (k + (1 : ℤ) + (1 : ℤ))) ∧ (1 : ℤ) ≤ Fibonacci.fib (k + (1 : ℤ)) ∧ (1 : ℤ) ≤ Fibonacci.fib k + Fibonacci.fib (k + (1 : ℤ)) else let o1 : List ℤ := List.cons k ([] : List ℤ); let o2 : ℤ := n - Fibonacci.fib k; (((1 : ℤ) ≤ k ∧ Fibonacci.fib k ≤ n ∧ o2 < Fibonacci.fib (k + (1 : ℤ))) ∧ ((1 : ℤ) ≤ Fibonacci.fib k ∧ (1 : ℤ) ≤ Fibonacci.fib (k + (1 : ℤ))) ∧ ((0 : ℤ) ≤ o2 ∧ o2 ≤ n) ∧ wf (2 : ℤ) o1 ∧ o2 + sum o1 = n ∧ o2 < Fibonacci.fib (k - (1 : ℤ))) ∧ (∀(x : ℤ) (l : List ℤ) (k1 : ℤ), ((1 : ℤ) ≤ k1 ∧ Fibonacci.fib k1 ≤ n ∧ x < Fibonacci.fib (k1 + (1 : ℤ))) ∧ ((1 : ℤ) ≤ Fibonacci.fib k1 ∧ (1 : ℤ) ≤ Fibonacci.fib (k1 + (1 : ℤ))) ∧ ((0 : ℤ) ≤ x ∧ x ≤ n) ∧ wf (2 : ℤ) l ∧ x + sum l = n ∧ (match l with | ([] : List ℤ) => True | List.cons k2 _ => x < Fibonacci.fib (k2 - (1 : ℤ))) → (if (0 : ℤ) < x then if Fibonacci.fib k1 ≤ x then ((0 : ℤ) ≤ k1 ∧ k1 - (1 : ℤ) < k1) ∧ ((1 : ℤ) ≤ k1 - (1 : ℤ) ∧ (Fibonacci.fib (k1 + (1 : ℤ)) - Fibonacci.fib k1 = Fibonacci.fib (k1 - (1 : ℤ)) ∧ Fibonacci.fib (k1 - (1 : ℤ)) ≤ n) ∧ x - Fibonacci.fib k1 < Fibonacci.fib k1 ∧ Fibonacci.fib k1 = Fibonacci.fib (k1 - (1 : ℤ) + (1 : ℤ))) ∧ ((1 : ℤ) ≤ Fibonacci.fib (k1 + (1 : ℤ)) - Fibonacci.fib k1 ∧ (1 : ℤ) ≤ Fibonacci.fib k1) ∧ ((0 : ℤ) ≤ x - Fibonacci.fib k1 ∧ x - Fibonacci.fib k1 ≤ n) ∧ wf (2 : ℤ) (List.cons k1 l) ∧ x - Fibonacci.fib k1 + sum (List.cons k1 l) = n ∧ (match List.cons k1 l with | ([] : List ℤ) => True | List.cons k2 _ => x - Fibonacci.fib k1 < Fibonacci.fib (k2 - (1 : ℤ))) else ((0 : ℤ) ≤ k1 ∧ k1 - (1 : ℤ) < k1) ∧ ((1 : ℤ) ≤ k1 - (1 : ℤ) ∧ (Fibonacci.fib (k1 + (1 : ℤ)) - Fibonacci.fib k1 = Fibonacci.fib (k1 - (1 : ℤ)) ∧ Fibonacci.fib (k1 - (1 : ℤ)) ≤ n) ∧ x < Fibonacci.fib k1 ∧ Fibonacci.fib k1 = Fibonacci.fib (k1 - (1 : ℤ) + (1 : ℤ))) ∧ ((1 : ℤ) ≤ Fibonacci.fib (k1 + (1 : ℤ)) - Fibonacci.fib k1 ∧ (1 : ℤ) ≤ Fibonacci.fib k1) ∧ ((0 : ℤ) ≤ x ∧ x ≤ n) ∧ wf (2 : ℤ) l ∧ x + sum l = n ∧ (match l with | ([] : List ℤ) => True | List.cons k2 _ => x < Fibonacci.fib (k2 - (1 : ℤ))) else wf (2 : ℤ) l ∧ n = sum l))))
  := sorry
end fibonacci_Zeckendorf_zeckendorf_fastqtvc
