theory find_FIND_findqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_MapEq" "Why3STD.map_MapExchange" "Why3STD.map_MapPermut"
begin
consts x_N :: "int"
consts f :: "int"
axiomatization where f_N_range'0:   "(1 :: int) \<le> f"
axiomatization where f_N_range'1:   "f \<le> x_N"
definition found :: "int list \<Rightarrow> _"
  where "found a \<longleftrightarrow> (\<forall>(p :: int) (q :: int). (1 :: int) \<le> p \<and> p \<le> f \<and> f \<le> q \<and> q \<le> x_N \<longrightarrow> a ! nat p \<le> a ! nat f \<and> a ! nat f \<le> a ! nat q)" for a
definition m_invariant :: "int \<Rightarrow> int list \<Rightarrow> _"
  where "m_invariant m a \<longleftrightarrow> m \<le> f \<and> (\<forall>(p :: int) (q :: int). (1 :: int) \<le> p \<and> p < m \<and> m \<le> q \<and> q \<le> x_N \<longrightarrow> a ! nat p \<le> a ! nat q)" for m a
definition n_invariant :: "int \<Rightarrow> int list \<Rightarrow> _"
  where "n_invariant n a \<longleftrightarrow> f \<le> n \<and> (\<forall>(p :: int) (q :: int). (1 :: int) \<le> p \<and> p \<le> n \<and> n < q \<and> q \<le> x_N \<longrightarrow> a ! nat p \<le> a ! nat q)" for n a
definition i_invariant :: "int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int list \<Rightarrow> _"
  where "i_invariant m n i q r a \<longleftrightarrow> m \<le> i \<and> (\<forall>(p :: int). (1 :: int) \<le> p \<and> p < i \<longrightarrow> a ! nat p \<le> r) \<and> (i \<le> n \<longrightarrow> (i \<le> q \<and> q \<le> n) \<and> r \<le> a ! nat q)" for m n i q r a
definition j_invariant :: "int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int list \<Rightarrow> _"
  where "j_invariant m n j p r a \<longleftrightarrow> j \<le> n \<and> (\<forall>(q :: int). j < q \<and> q \<le> x_N \<longrightarrow> r \<le> a ! nat q) \<and> (m \<le> j \<longrightarrow> (m \<le> p \<and> p \<le> j) \<and> a ! nat p \<le> r)" for m n j p r a
definition "termination" :: "int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int list \<Rightarrow> _"
  where "termination i j i0 j0 r a \<longleftrightarrow> i0 < i \<and> j < j0 \<or> (i \<le> f \<and> f \<le> j) \<and> a ! nat f = r" for i j i0 j0 r a
theorem find'vc:
  fixes a :: "int list"
  assumes fact0: "int (length a) = x_N + (1 :: int)"
  shows "m_invariant (1 :: int) a"
  and "n_invariant x_N a"
  and "a <~~> a"
  and "(1 :: int) \<le> (1 :: int)"
  and "x_N \<le> x_N"
  and "\<forall>(n :: int) (m :: int) (a1 :: int list). length a1 = length a \<longrightarrow> m_invariant m a1 \<and> n_invariant n a1 \<and> a1 <~~> a \<and> (1 :: int) \<le> m \<and> n \<le> x_N \<longrightarrow> (if m < n then let o1 :: int = f in ((0 :: int) \<le> o1 \<and> o1 < int (length a1)) \<and> (let r :: int = a1 ! nat o1 in (i_invariant m n m f r a1 \<and> j_invariant m n n f r a1 \<and> m_invariant m a1 \<and> n_invariant n a1 \<and> (0 :: int) \<le> n \<and> m \<le> x_N + (1 :: int) \<and> termination m n m n r a1 \<and> a1 <~~> a) \<and> (\<forall>(q :: int) (p :: int) (j :: int) (i :: int) (a2 :: int list). length a2 = length a1 \<longrightarrow> i_invariant m n i q r a2 \<and> j_invariant m n j p r a2 \<and> m_invariant m a2 \<and> n_invariant n a2 \<and> (0 :: int) \<le> j \<and> i \<le> x_N + (1 :: int) \<and> termination i j m n r a2 \<and> a2 <~~> a \<longrightarrow> (if i \<le> j then (i_invariant m n i q r a2 \<and> (i \<le> i \<and> i \<le> n) \<and> termination i j m n r a2) \<and> (\<forall>(i1 :: int). i_invariant m n i1 q r a2 \<and> (i \<le> i1 \<and> i1 \<le> n) \<and> termination i1 j m n r a2 \<longrightarrow> ((0 :: int) \<le> i1 \<and> i1 < int (length a2)) \<and> (if a2 ! nat i1 < r then ((0 :: int) \<le> x_N + (1 :: int) - i1 \<and> x_N + (1 :: int) - (i1 + (1 :: int)) < x_N + (1 :: int) - i1) \<and> i_invariant m n (i1 + (1 :: int)) q r a2 \<and> (i \<le> i1 + (1 :: int) \<and> i1 + (1 :: int) \<le> n) \<and> termination (i1 + (1 :: int)) j m n r a2 else (j_invariant m n j p r a2 \<and> j \<le> j \<and> m \<le> j \<and> termination i1 j m n r a2) \<and> (\<forall>(j1 :: int). j_invariant m n j1 p r a2 \<and> j1 \<le> j \<and> m \<le> j1 \<and> termination i1 j1 m n r a2 \<longrightarrow> ((0 :: int) \<le> j1 \<and> j1 < int (length a2)) \<and> (if r < a2 ! nat j1 then ((0 :: int) \<le> j1 \<and> j1 - (1 :: int) < j1) \<and> j_invariant m n (j1 - (1 :: int)) p r a2 \<and> j1 - (1 :: int) \<le> j \<and> m \<le> j1 - (1 :: int) \<and> termination i1 (j1 - (1 :: int)) m n r a2 else if i1 \<le> j1 then ((0 :: int) \<le> i1 \<and> i1 < int (length a2)) \<and> (let w :: int = a2 ! nat i1 in ((0 :: int) \<le> j1 \<and> j1 < int (length a2)) \<and> (let o2 :: int = a2 ! nat j1 in ((0 :: int) \<le> i1 \<and> i1 < int (length a2)) \<and> (length (a2[nat i1 := o2]) = length a2 \<longrightarrow> nth (a2[nat i1 := o2]) o nat = (nth a2 o nat)(i1 := o2) \<longrightarrow> ((0 :: int) \<le> j1 \<and> j1 < int (length (a2[nat i1 := o2]))) \<and> (length (a2[nat j1 := w, nat i1 := o2]) = length (a2[nat i1 := o2]) \<longrightarrow> nth (a2[nat j1 := w, nat i1 := o2]) o nat = (nth (a2[nat i1 := o2]) o nat)(j1 := w) \<longrightarrow> (\<forall>(o3 :: int). (if i1 < j1 then o3 = i1 else o3 = j1 - (1 :: int)) \<longrightarrow> (\<forall>(o4 :: int). (if i1 < j1 then o4 = j1 else o4 = i1 + (1 :: int)) \<longrightarrow> ((0 :: int) \<le> x_N + (2 :: int) + j - i \<and> x_N + (2 :: int) + (j1 - (1 :: int)) - (i1 + (1 :: int)) < x_N + (2 :: int) + j - i) \<and> i_invariant m n (i1 + (1 :: int)) o4 r (a2[nat j1 := w, nat i1 := o2]) \<and> j_invariant m n (j1 - (1 :: int)) o3 r (a2[nat j1 := w, nat i1 := o2]) \<and> m_invariant m (a2[nat j1 := w, nat i1 := o2]) \<and> n_invariant n (a2[nat j1 := w, nat i1 := o2]) \<and> (0 :: int) \<le> j1 - (1 :: int) \<and> i1 + (1 :: int) \<le> x_N + (1 :: int) \<and> termination (i1 + (1 :: int)) (j1 - (1 :: int)) m n r (a2[nat j1 := w, nat i1 := o2]) \<and> a2[nat j1 := w, nat i1 := o2] <~~> a)))))) else ((0 :: int) \<le> x_N + (2 :: int) + j - i \<and> x_N + (2 :: int) + j1 - i1 < x_N + (2 :: int) + j - i) \<and> i_invariant m n i1 q r a2 \<and> j_invariant m n j1 p r a2 \<and> m_invariant m a2 \<and> n_invariant n a2 \<and> (0 :: int) \<le> j1 \<and> i1 \<le> x_N + (1 :: int) \<and> termination i1 j1 m n r a2 \<and> a2 <~~> a)))) else if f \<le> j then ((0 :: int) \<le> n - m \<and> j - m < n - m) \<and> m_invariant m a2 \<and> n_invariant j a2 \<and> a2 <~~> a \<and> (1 :: int) \<le> m \<and> j \<le> x_N else if i \<le> f then ((0 :: int) \<le> n - m \<and> n - i < n - m) \<and> m_invariant i a2 \<and> n_invariant n a2 \<and> a2 <~~> a \<and> (1 :: int) \<le> i \<and> n \<le> x_N else ((0 :: int) \<le> n - m \<and> f - f < n - m) \<and> m_invariant f a2 \<and> n_invariant f a2 \<and> a2 <~~> a \<and> (1 :: int) \<le> f \<and> f \<le> x_N))) else found a1 \<and> a1 <~~> a)"
  sorry
end
