theory flexible_arrays_BraunTrees
  imports "NTP4Verif.NTP4Verif" "Why3STD.bintree_Tree" "Why3STD.bintree_Size"
begin
fun braun :: "'a tree \<Rightarrow> _"
  where "braun (Empty :: 'a tree) = True"
      | "braun (Node l x r) = ((bintree_Size.size l = bintree_Size.size r \<or> bintree_Size.size l = bintree_Size.size r + (1 :: int)) \<and> braun l \<and> braun r)" for l x r
consts get_tree :: "'a tree \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where get_tree'def:   "case t of (Empty :: 'a tree) \<Rightarrow> False | Node l x r \<Rightarrow> (if i = (0 :: int) then get_tree t i = x else if i cmod (2 :: int) = (1 :: int) then get_tree t i = get_tree l (i cdiv (2 :: int)) else get_tree t i = get_tree r (i cdiv (2 :: int) - (1 :: int)))"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
consts set_tree :: "'a tree \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a tree"
axiomatization where set_tree'spec'2:   "bintree_Size.size (set_tree t i v) = bintree_Size.size t"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec'1:   "braun (set_tree t i v)"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec'0:   "get_tree (set_tree t i v) i = v"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec:   "get_tree (set_tree t i v) j = get_tree t j"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
 and "(0 :: int) \<le> j"
 and "j < bintree_Size.size t"
 and "\<not>j = i"
  for i :: "int"
  and t :: "'a tree"
  and j :: "int"
  and v :: "'a"
end
