theory flexible_arrays_BraunTrees_liat_treeqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.bintree_Tree" "Why3STD.bintree_Size"
begin
fun braun :: "'a tree \<Rightarrow> _"
  where "braun (Empty :: 'a tree) = True"
      | "braun (Node l x r) = ((bintree_Size.size l = bintree_Size.size r \<or> bintree_Size.size l = bintree_Size.size r + (1 :: int)) \<and> braun l \<and> braun r)" for l x r
consts get_tree :: "'a tree \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where get_tree'def:   "case t of (Empty :: 'a tree) \<Rightarrow> False | Node l x r \<Rightarrow> (if i = (0 :: int) then get_tree t i = x else if i cmod (2 :: int) = (1 :: int) then get_tree t i = get_tree l (i cdiv (2 :: int)) else get_tree t i = get_tree r (i cdiv (2 :: int) - (1 :: int)))"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
consts set_tree :: "'a tree \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a tree"
axiomatization where set_tree'spec'2:   "bintree_Size.size (set_tree t i v) = bintree_Size.size t"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec'1:   "braun (set_tree t i v)"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec'0:   "get_tree (set_tree t i v) i = v"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec:   "get_tree (set_tree t i v) j = get_tree t j"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
 and "(0 :: int) \<le> j"
 and "j < bintree_Size.size t"
 and "\<not>j = i"
  for i :: "int"
  and t :: "'a tree"
  and j :: "int"
  and v :: "'a"
theorem liat_tree'vc:
  fixes t :: "'a tree"
  assumes fact0: "braun t"
  assumes fact1: "(0 :: int) < bintree_Size.size t"
  shows "case t of (Empty :: 'a tree) \<Rightarrow> False | Node (Empty :: 'a tree) _ (Empty :: 'a tree) \<Rightarrow> True | Node l x r \<Rightarrow> \<not>(2 :: int) = (0 :: int) \<and> (if bintree_Size.size t cmod (2 :: int) = (0 :: int) then \<not>(2 :: int) = (0 :: int) \<and> (case t of (Empty :: 'a tree) \<Rightarrow> False | Node f _ f1 \<Rightarrow> f = l \<or> f1 = l) \<and> braun l \<and> bintree_Size.size t cdiv (2 :: int) = bintree_Size.size l \<and> (0 :: int) < bintree_Size.size l else \<not>(2 :: int) = (0 :: int) \<and> (case t of (Empty :: 'a tree) \<Rightarrow> False | Node f _ f1 \<Rightarrow> f = r \<or> f1 = r) \<and> braun r \<and> bintree_Size.size t cdiv (2 :: int) = bintree_Size.size r \<and> (0 :: int) < bintree_Size.size r)"
  and "\<forall>(r :: 'a tree). (case t of (Empty :: 'a tree) \<Rightarrow> False | Node (Empty :: 'a tree) _ (Empty :: 'a tree) \<Rightarrow> r = (Empty :: 'a tree) | Node l x r1 \<Rightarrow> (if bintree_Size.size t cmod (2 :: int) = (0 :: int) then \<exists>(o1 :: 'a tree). (bintree_Size.size o1 = bintree_Size.size l - (1 :: int) \<and> braun o1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size o1 \<longrightarrow> get_tree o1 i = get_tree l i)) \<and> r = Node o1 x r1 else \<exists>(o1 :: 'a tree). (bintree_Size.size o1 = bintree_Size.size r1 - (1 :: int) \<and> braun o1 \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size o1 \<longrightarrow> get_tree o1 i = get_tree r1 i)) \<and> r = Node l x o1)) \<longrightarrow> bintree_Size.size r = bintree_Size.size t - (1 :: int) \<and> braun r \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size r \<longrightarrow> get_tree r i = get_tree t i)"
  sorry
end
