theory flexible_arrays_BraunTrees_make_tree2qtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.bintree_Tree" "Why3STD.bintree_Size"
begin
fun braun :: "'a tree \<Rightarrow> _"
  where "braun (Empty :: 'a tree) = True"
      | "braun (Node l x r) = ((bintree_Size.size l = bintree_Size.size r \<or> bintree_Size.size l = bintree_Size.size r + (1 :: int)) \<and> braun l \<and> braun r)" for l x r
consts get_tree :: "'a tree \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where get_tree'def:   "case t of (Empty :: 'a tree) \<Rightarrow> False | Node l x r \<Rightarrow> (if i = (0 :: int) then get_tree t i = x else if i cmod (2 :: int) = (1 :: int) then get_tree t i = get_tree l (i cdiv (2 :: int)) else get_tree t i = get_tree r (i cdiv (2 :: int) - (1 :: int)))"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
consts set_tree :: "'a tree \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a tree"
axiomatization where set_tree'spec'2:   "bintree_Size.size (set_tree t i v) = bintree_Size.size t"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec'1:   "braun (set_tree t i v)"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec'0:   "get_tree (set_tree t i v) i = v"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
  for i :: "int"
  and t :: "'a tree"
  and v :: "'a"
axiomatization where set_tree'spec:   "get_tree (set_tree t i v) j = get_tree t j"
 if "(0 :: int) \<le> i"
 and "i < bintree_Size.size t"
 and "braun t"
 and "(0 :: int) \<le> j"
 and "j < bintree_Size.size t"
 and "\<not>j = i"
  for i :: "int"
  and t :: "'a tree"
  and j :: "int"
  and v :: "'a"
theorem make_tree2'vc:
  fixes n :: "int"
  fixes v :: "'a"
  assumes fact0: "(0 :: int) \<le> n"
  shows "\<not>n = (0 :: int) \<longrightarrow> \<not>(2 :: int) = (0 :: int) \<and> (if n cmod (2 :: int) = (1 :: int) then \<not>(2 :: int) = (0 :: int) \<and> (let o1 :: int = n cdiv (2 :: int) in ((0 :: int) \<le> n \<and> o1 < n) \<and> (0 :: int) \<le> o1) else \<not>(2 :: int) = (0 :: int) \<and> (let o1 :: int = n cdiv (2 :: int) - (1 :: int) in ((0 :: int) \<le> n \<and> o1 < n) \<and> (0 :: int) \<le> o1))"
  and "\<forall>(l :: 'a tree) (r :: 'a tree). (if n = (0 :: int) then l = Node (Empty :: 'a tree) v (Empty :: 'a tree) \<and> r = (Empty :: 'a tree) else if n cmod (2 :: int) = (1 :: int) then let o1 :: int = n cdiv (2 :: int) in \<exists>(l1 :: 'a tree) (r1 :: 'a tree). ((bintree_Size.size l1 = o1 + (1 :: int) \<and> bintree_Size.size r1 = o1) \<and> (braun l1 \<and> braun r1) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size l1 \<longrightarrow> get_tree l1 i = v) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size r1 \<longrightarrow> get_tree r1 i = v)) \<and> l = Node l1 v r1 \<and> r = Node r1 v r1 else let o1 :: int = n cdiv (2 :: int) - (1 :: int) in \<exists>(l1 :: 'a tree) (r1 :: 'a tree). ((bintree_Size.size l1 = o1 + (1 :: int) \<and> bintree_Size.size r1 = o1) \<and> (braun l1 \<and> braun r1) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size l1 \<longrightarrow> get_tree l1 i = v) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size r1 \<longrightarrow> get_tree r1 i = v)) \<and> l = Node l1 v l1 \<and> r = Node l1 v r1) \<longrightarrow> (bintree_Size.size l = n + (1 :: int) \<and> bintree_Size.size r = n) \<and> (braun l \<and> braun r) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size l \<longrightarrow> get_tree l i = v) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < bintree_Size.size r \<longrightarrow> get_tree r i = v)"
  sorry
end
