import Why3.Base
import Why3.map.Const
open Classical
open Lean4Why3
namespace hashtbl_impl_HashtblImpl_resizeqtvc
axiom key : Type
axiom inhabited_axiom_key : Inhabited key
attribute [instance] inhabited_axiom_key
axiom hash : key -> ℤ
axiom hash'spec (x : key) : (0 : ℤ) ≤ hash x
axiom bucket : key -> ℤ -> ℤ
axiom bucket'def (n : ℤ) (k : key) (fact0 : (0 : ℤ) < n) : bucket k n = Int.tmod (hash k) n
axiom bucket'spec (n : ℤ) (k : key) (fact0 : (0 : ℤ) < n) : (0 : ℤ) ≤ bucket k n ∧ bucket k n < n
noncomputable def in_data {α : Type} [Inhabited α] (k : key) (v : α) (d : List (List (key × α))) := (k, v) ∈ d[Int.toNat (bucket k (Int.ofNat (List.length d)))]!
noncomputable def good_data {α : Type} [Inhabited α] (k : key) (v : α) (m : key -> Option α) (d : List (List (key × α))) := (m k = Option.some v) = in_data k v d
noncomputable def good_hash {α : Type} [Inhabited α] (d : List (List (key × α))) (i : ℤ) := ∀(k : key) (v : α), (k, v) ∈ d[Int.toNat i]! → bucket k (Int.ofNat (List.length d)) = i
axiom t : Type -> Type
axiom inhabited_axiom_t {α : Type} [Inhabited α] : Inhabited (t α)
attribute [instance] inhabited_axiom_t
axiom size :  {α : Type} -> [Inhabited α] -> t α -> ℤ
axiom data :  {α : Type} -> [Inhabited α] -> t α -> List (List (key × α))
axiom view :  {α : Type} -> [Inhabited α] -> t α -> key -> Option α
axiom t'invariant {α : Type} [Inhabited α] (self : t α) : (0 : ℤ) < Int.ofNat (List.length (data self)) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length (data self)) → good_hash (data self) i) ∧ (∀(k : key) (v : α), good_data k v (view self) (data self))
noncomputable def t'eq {α : Type} [Inhabited α] (a : t α) (b : t α) := size a = size b ∧ data a = data b ∧ view a = view b
axiom t'inj {α : Type} [Inhabited α] (a : t α) (b : t α) (fact0 : t'eq a b) : a = b
theorem resize'vc {α : Type} [Inhabited α] (h : t α) : let odata : List (List (key × α)) := data h; let osize : ℤ := Int.ofNat (List.length odata); let nsize : ℤ := (2 : ℤ) * osize + (1 : ℤ); (0 : ℤ) ≤ nsize ∧ (∀(ndata : List (List (key × α))), (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < nsize → ndata[Int.toNat i]! = ([] : List (key × α))) ∧ Int.ofNat (List.length ndata) = nsize → (∀(ndata1 : List (List (key × α))) (h1 : t α), List.length ndata1 = List.length ndata → (∀(i : ℤ) (l : List (key × α)), (view h = view h1 ∧ size h = size h1) ∧ (∀(k : key) (v : α), (k, v) ∈ l → bucket k osize = i) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata1 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize < i then good_data k v (view h1) ndata1 else if bucket k osize = i then (view h1 k = Option.some v) = ((k, v) ∈ l ∨ in_data k v ndata1) else ¬in_data k v ndata1) → (match l with | ([] : List (key × α)) => (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata1 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize ≤ i then good_data k v (view h1) ndata1 else ¬in_data k v ndata1) | List.cons (k, v) r => (0 : ℤ) < nsize ∧ (let b : ℤ := bucket k nsize; (0 : ℤ) ≤ b ∧ b < nsize → ((0 : ℤ) ≤ b ∧ b < Int.ofNat (List.length ndata1)) ∧ (let o1 : List (key × α) := List.cons (k, v) (ndata1[Int.toNat b]!); ((0 : ℤ) ≤ b ∧ b < Int.ofNat (List.length ndata1)) ∧ (List.length (List.set ndata1 (Int.toNat b) o1) = List.length ndata1 → getElem! (List.set ndata1 (Int.toNat b) o1) ∘ Int.toNat = Function.update (getElem! ndata1 ∘ Int.toNat) b o1 → (match l with | ([] : List (key × α)) => False | List.cons _ f => f = r) ∧ (∀(k1 : key) (v1 : α), (k1, v1) ∈ r → bucket k1 osize = i) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash (List.set ndata1 (Int.toNat b) o1) j) ∧ (∀(k1 : key) (v1 : α), if (0 : ℤ) ≤ bucket k1 osize ∧ bucket k1 osize < i then good_data k1 v1 (view h1) (List.set ndata1 (Int.toNat b) o1) else if bucket k1 osize = i then (view h1 k1 = Option.some v1) = ((k1, v1) ∈ r ∨ in_data k1 v1 (List.set ndata1 (Int.toNat b) o1)) else ¬in_data k1 v1 (List.set ndata1 (Int.toNat b) o1)))))))) ∧ (let o1 : ℤ := osize - (1 : ℤ); ((0 : ℤ) ≤ o1 + (1 : ℤ) → ((∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize < (0 : ℤ) then good_data k v (view h) ndata else ¬in_data k v ndata)) ∧ (∀(ndata1 : List (List (key × α))), List.length ndata1 = List.length ndata → (∀(i : ℤ), ((0 : ℤ) ≤ i ∧ i ≤ o1) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata1 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize < i then good_data k v (view h) ndata1 else ¬in_data k v ndata1) → ((0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length odata)) ∧ (let o2 : List (key × α) := odata[Int.toNat i]!; ((∀(k : key) (v : α), (k, v) ∈ o2 → bucket k osize = i) ∧ (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata1 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize < i then good_data k v (view h) ndata1 else if bucket k osize = i then (view h k = Option.some v) = ((k, v) ∈ o2 ∨ in_data k v ndata1) else ¬in_data k v ndata1)) ∧ (∀(ndata2 : List (List (key × α))), List.length ndata2 = List.length ndata1 → (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata2 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize ≤ i then good_data k v (view h) ndata2 else ¬in_data k v ndata2) → (∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata2 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize < i + (1 : ℤ) then good_data k v (view h) ndata2 else ¬in_data k v ndata2)))) ∧ ((∀(j : ℤ), (0 : ℤ) ≤ j ∧ j < nsize → good_hash ndata1 j) ∧ (∀(k : key) (v : α), if (0 : ℤ) ≤ bucket k osize ∧ bucket k osize < o1 + (1 : ℤ) then good_data k v (view h) ndata1 else ¬in_data k v ndata1) → (0 : ℤ) < Int.ofNat (List.length ndata1) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length ndata1) → good_hash ndata1 i) ∧ (∀(k : key) (v : α), good_data k v (view h) ndata1)))) ∧ (o1 + (1 : ℤ) < (0 : ℤ) → (0 : ℤ) < Int.ofNat (List.length ndata) ∧ (∀(i : ℤ), (0 : ℤ) ≤ i ∧ i < Int.ofNat (List.length ndata) → good_hash ndata i) ∧ (∀(k : key) (v : α), good_data k v (view h) ndata))))
  := sorry
end hashtbl_impl_HashtblImpl_resizeqtvc
