From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import imp.imp.Syntax.
Require Import imp.imp.ConcreteSemantics.
Require Import imp.imp.Svar.
Require Import imp.imp.Constraint.
Require Import imp.imp.SymState.
Require Import imp.imp.FreshSvar.
Require Import imp.imp.SymStateSet.
Open Scope Z_scope.
Axiom compose : (svar -> Z) -> t -> program_var -> option Z.
Axiom compose'def : forall  (rho : svar -> Z) (sigma : t) (x : program_var), compose rho sigma x = (match get sigma x with | Some v => Some (rho v) | None => None end).
Definition state_extends (s : sym_state) (s' : sym_state) := Svar.to_fset (vars s) ⊆ Svar.to_fset (vars s') ∧ (∀(v : svar), v ∈ Svar.to_fset (vars s) -> SymState.rho s v = SymState.rho s' v).
Axiom svar_set_add : svar -> Svar.set -> Svar.set.
Axiom svar_set_add'def : forall  (v : svar) (vs : Svar.set), Svar.to_fset (svar_set_add v vs) = insert_set v (Svar.to_fset vs) ∧ (if decide (v ∈ Svar.to_fset vs) then size (Svar.to_fset (svar_set_add v vs)) = size (Svar.to_fset vs) else Z.of_nat (size (Svar.to_fset (svar_set_add v vs))) = Z.of_nat (size (Svar.to_fset vs)) + 1%Z).
Definition results_extend (s : sym_state) (normals : gset sym_state) (unbounds : gset sym_state) (limits : gset sym_state) := ∀(s' : sym_state), s' ∈ normals ∨ s' ∈ unbounds ∨ s' ∈ limits -> state_extends s s'.
Theorem symbolic_interp_while_list'vc (ctr : Z) (n : Z) (ss : list sym_state) (e : expr) (c : cmd) (fact0 : 0%Z ≤ ctr) (fact1 : ctr ≤ n) : (match ss with | [] => True | cons s ss' => ((0%Z ≤ Z.of_nat (length ss) ∧ 0%Z < Z.of_nat (length ss)) ∧ 0%Z ≤ ctr ∧ ctr ≤ n) ∧ (∀(normals1 : SymStateSet.set) (unbounds1 : SymStateSet.set) (limits1 : SymStateSet.set), results_extend s (SymStateSet.to_fset normals1) (SymStateSet.to_fset unbounds1) (SymStateSet.to_fset limits1) ∧ (is_solution (SymState.rho s) (SymState.constr s) -> (∀(gamma' : program_var -> option Z) (bhv : behavior), exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s) (sigma s)) e c gamma' bhv -> (∃(s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals1 | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds1 | Cloop_limit => s' ∈ SymStateSet.to_fset limits1 end) ∧ is_solution (SymState.rho s') (SymState.constr s') ∧ gamma' = compose (SymState.rho s') (sigma s')))) ∧ (∀(bhv : behavior) (s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals1 | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds1 | Cloop_limit => s' ∈ SymStateSet.to_fset limits1 end) -> is_solution (SymState.rho s') (SymState.constr s') -> is_solution (SymState.rho s) (SymState.constr s) ∧ exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s) (sigma s)) e c (compose (SymState.rho s') (sigma s')) bhv) -> (0%Z ≤ Z.of_nat (length ss) ∧ Z.of_nat (length ss') < Z.of_nat (length ss)) ∧ 0%Z ≤ ctr ∧ ctr ≤ n) end) ∧ (∀(normals : SymStateSet.set) (unbounds : SymStateSet.set) (limits : SymStateSet.set), (match ss with | [] => (SymStateSet.to_fset limits = (∅ : gset sym_state) ∧ Z.of_nat (size (SymStateSet.to_fset limits)) = 0%Z) ∧ (SymStateSet.to_fset unbounds = (∅ : gset sym_state) ∧ Z.of_nat (size (SymStateSet.to_fset unbounds)) = 0%Z) ∧ SymStateSet.to_fset normals = (∅ : gset sym_state) ∧ Z.of_nat (size (SymStateSet.to_fset normals)) = 0%Z | cons s ss' => (∃(normals1 : SymStateSet.set) (unbounds1 : SymStateSet.set) (limits1 : SymStateSet.set), (results_extend s (SymStateSet.to_fset normals1) (SymStateSet.to_fset unbounds1) (SymStateSet.to_fset limits1) ∧ (is_solution (SymState.rho s) (SymState.constr s) -> (∀(gamma' : program_var -> option Z) (bhv : behavior), exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s) (sigma s)) e c gamma' bhv -> (∃(s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals1 | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds1 | Cloop_limit => s' ∈ SymStateSet.to_fset limits1 end) ∧ is_solution (SymState.rho s') (SymState.constr s') ∧ gamma' = compose (SymState.rho s') (sigma s')))) ∧ (∀(bhv : behavior) (s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals1 | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds1 | Cloop_limit => s' ∈ SymStateSet.to_fset limits1 end) -> is_solution (SymState.rho s') (SymState.constr s') -> is_solution (SymState.rho s) (SymState.constr s) ∧ exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s) (sigma s)) e c (compose (SymState.rho s') (sigma s')) bhv)) ∧ (∃(normals2 : SymStateSet.set) (unbounds2 : SymStateSet.set) (limits2 : SymStateSet.set), ((∀(s' : sym_state), s' ∈ SymStateSet.to_fset normals2 ∨ s' ∈ SymStateSet.to_fset unbounds2 ∨ s' ∈ SymStateSet.to_fset limits2 -> (∃(s1 : sym_state), s1 ∈ SymStateSet.to_fset (of_list ss') ∧ state_extends s1 s')) ∧ (∀(s1 : sym_state), s1 ∈ SymStateSet.to_fset (of_list ss') -> is_solution (SymState.rho s1) (SymState.constr s1) -> (∀(gamma' : program_var -> option Z) (bhv : behavior), exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s1) (sigma s1)) e c gamma' bhv -> (∃(s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals2 | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds2 | Cloop_limit => s' ∈ SymStateSet.to_fset limits2 end) ∧ is_solution (SymState.rho s') (SymState.constr s') ∧ gamma' = compose (SymState.rho s') (sigma s')))) ∧ (∀(bhv : behavior) (s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals2 | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds2 | Cloop_limit => s' ∈ SymStateSet.to_fset limits2 end) -> is_solution (SymState.rho s') (SymState.constr s') -> (∃(s1 : sym_state), s1 ∈ SymStateSet.to_fset (of_list ss') ∧ is_solution (SymState.rho s1) (SymState.constr s1) ∧ exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s1) (sigma s1)) e c (compose (SymState.rho s') (sigma s')) bhv))) ∧ SymStateSet.to_fset limits = SymStateSet.to_fset limits1 ∪ SymStateSet.to_fset limits2 ∧ SymStateSet.to_fset unbounds = SymStateSet.to_fset unbounds1 ∪ SymStateSet.to_fset unbounds2 ∧ SymStateSet.to_fset normals = SymStateSet.to_fset normals1 ∪ SymStateSet.to_fset normals2)) end) -> (∀(s' : sym_state), s' ∈ SymStateSet.to_fset normals ∨ s' ∈ SymStateSet.to_fset unbounds ∨ s' ∈ SymStateSet.to_fset limits -> (∃(s : sym_state), s ∈ SymStateSet.to_fset (of_list ss) ∧ state_extends s s')) ∧ (∀(s : sym_state), s ∈ SymStateSet.to_fset (of_list ss) -> is_solution (SymState.rho s) (SymState.constr s) -> (∀(gamma' : program_var -> option Z) (bhv : behavior), exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s) (sigma s)) e c gamma' bhv -> (∃(s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds | Cloop_limit => s' ∈ SymStateSet.to_fset limits end) ∧ is_solution (SymState.rho s') (SymState.constr s') ∧ gamma' = compose (SymState.rho s') (sigma s')))) ∧ (∀(bhv : behavior) (s' : sym_state), (match bhv with | Cnormal => s' ∈ SymStateSet.to_fset normals | Cunbound_var => s' ∈ SymStateSet.to_fset unbounds | Cloop_limit => s' ∈ SymStateSet.to_fset limits end) -> is_solution (SymState.rho s') (SymState.constr s') -> (∃(s : sym_state), s ∈ SymStateSet.to_fset (of_list ss) ∧ is_solution (SymState.rho s) (SymState.constr s) ∧ exec_while (mk_loop_cnf n) ctr (compose (SymState.rho s) (sigma s)) e c (compose (SymState.rho s') (sigma s')) bhv))).
Admitted.
