theory imp_SymState
  imports "NTP4Verif.NTP4Verif" "../../lib/isabelle/imp_Syntax" "../../lib/isabelle/imp_Svar" "../../lib/isabelle/imp_Constraint"
begin
typedecl  sym_state
consts sigma :: "sym_state \<Rightarrow> t"
consts constr :: "sym_state \<Rightarrow> constr"
consts rho :: "sym_state \<Rightarrow> svar \<Rightarrow> int"
consts vars :: "sym_state \<Rightarrow> imp_Svar.set"
axiomatization where sym_state'invariant'0:   "vars_in_constraint (constr self) |\<subseteq>| to_fset (vars self)"
  for self :: "sym_state"
axiomatization where sym_state'invariant'1:   "\<forall>(x :: program_var) (v :: svar). get (sigma self) x = Some v \<longrightarrow> v |\<in>| to_fset (vars self)"
  for self :: "sym_state"
definition sym_state'eq :: "sym_state \<Rightarrow> sym_state \<Rightarrow> _"
  where "sym_state'eq a b \<longleftrightarrow> sigma a = sigma b \<and> constr a = constr b \<and> rho a = rho b \<and> vars a = vars b" for a b
axiomatization where sym_state'inj:   "a = b"
 if "sym_state'eq a b"
  for a :: "sym_state"
  and b :: "sym_state"
consts eq :: "sym_state \<Rightarrow> sym_state \<Rightarrow> bool"
axiomatization where eq'spec:   "eq s1 s2 \<longleftrightarrow> s1 = s2"
  for s1 :: "sym_state"
  and s2 :: "sym_state"
consts mk_sym_state :: "t \<Rightarrow> constr \<Rightarrow> imp_Svar.set \<Rightarrow> (svar \<Rightarrow> int) \<Rightarrow> sym_state"
axiomatization where mk_sym_state'spec'2:   "sigma (mk_sym_state sigma1 constr1 vars1 rho1) = sigma1"
 if "vars_in_constraint constr1 |\<subseteq>| to_fset vars1"
 and "\<forall>(x :: program_var) (v :: svar). get sigma1 x = Some v \<longrightarrow> v |\<in>| to_fset vars1"
  for constr1 :: "constr"
  and vars1 :: "imp_Svar.set"
  and sigma1 :: "t"
  and rho1 :: "svar \<Rightarrow> int"
axiomatization where mk_sym_state'spec'1:   "constr (mk_sym_state sigma1 constr1 vars1 rho1) = constr1"
 if "vars_in_constraint constr1 |\<subseteq>| to_fset vars1"
 and "\<forall>(x :: program_var) (v :: svar). get sigma1 x = Some v \<longrightarrow> v |\<in>| to_fset vars1"
  for constr1 :: "constr"
  and vars1 :: "imp_Svar.set"
  and sigma1 :: "t"
  and rho1 :: "svar \<Rightarrow> int"
axiomatization where mk_sym_state'spec'0:   "vars (mk_sym_state sigma1 constr1 vars1 rho1) = vars1"
 if "vars_in_constraint constr1 |\<subseteq>| to_fset vars1"
 and "\<forall>(x :: program_var) (v :: svar). get sigma1 x = Some v \<longrightarrow> v |\<in>| to_fset vars1"
  for constr1 :: "constr"
  and vars1 :: "imp_Svar.set"
  and sigma1 :: "t"
  and rho1 :: "svar \<Rightarrow> int"
axiomatization where mk_sym_state'spec:   "rho (mk_sym_state sigma1 constr1 vars1 rho1) = rho1"
 if "vars_in_constraint constr1 |\<subseteq>| to_fset vars1"
 and "\<forall>(x :: program_var) (v :: svar). get sigma1 x = Some v \<longrightarrow> v |\<in>| to_fset vars1"
  for constr1 :: "constr"
  and vars1 :: "imp_Svar.set"
  and sigma1 :: "t"
  and rho1 :: "svar \<Rightarrow> int"
end
