theory isqrt_von_neumann_VonNeumann16_isqrt16qtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.WellFounded_WellFounded" "Why3STD.Ref_Ref"
begin
definition sqr :: "16 word \<Rightarrow> 16 word"
  where "sqr x = x * x" for x
definition is_pow2 :: "16 word \<Rightarrow> 16 word \<Rightarrow> _"
  where "is_pow2 x n \<longleftrightarrow> x AND ((1 :: 16 word) << unat n) - (1 :: 16 word) = (0 :: 16 word)" for x n
theorem isqrt16'vc:
  fixes x :: "16 word"
  shows "(8 :: 16 word) \<le> (8 :: 16 word)"
  and "(128 :: 16 word) = (if (8 :: 16 word) = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat ((8 :: 16 word) - (1 :: 16 word)))"
  and "(16384 :: 16 word) = sqr (128 :: 16 word)"
  and "is_pow2 (0 :: 16 word) (8 :: 16 word)"
  and "(0 :: 16 word) < (256 :: 16 word)"
  and "(0 :: 16 word) = (0 :: 16 word) * ((1 :: 16 word) << unat (8 :: 16 word))"
  and "x \<le> x"
  and "x - x = sqr (0 :: 16 word)"
  and "(0 :: 16 word) + ((1 :: 16 word) << unat (8 :: 16 word)) \<le> (256 :: 16 word)"
  and "x \<le> sqr ((0 :: 16 word) + ((1 :: 16 word) << unat (8 :: 16 word))) - (1 :: 16 word)"
  and "\<forall>(res_g :: 16 word) (m :: 16 word) (num :: 16 word). m \<le> (8 :: 16 word) \<and> is_pow2 res_g m \<and> res_g < (256 :: 16 word) \<and> num \<le> x \<and> x - num = sqr res_g \<and> res_g + ((1 :: 16 word) << unat m) \<le> (256 :: 16 word) \<and> x \<le> sqr (res_g + ((1 :: 16 word) << unat m)) - (1 :: 16 word) \<longrightarrow> (if \<not>sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) = (0 :: 16 word) then let b :: 16 word = res_g * ((1 :: 16 word) << unat m) OR sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) in if num \<ge> b then uint (sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (2 :: 16 word)) < uint (sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word)))) \<and> m - (1 :: 16 word) \<le> (8 :: 16 word) \<and> (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (1 :: 16 word) = (if m - (1 :: 16 word) = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word) - (1 :: 16 word))) \<and> sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (2 :: 16 word) = sqr ((if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (1 :: 16 word)) \<and> is_pow2 (res_g + (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word)))) (m - (1 :: 16 word)) \<and> res_g + (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) < (256 :: 16 word) \<and> (res_g * ((1 :: 16 word) << unat m) >> unat (1 :: 16 word)) OR sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) = (res_g + (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word)))) * ((1 :: 16 word) << unat (m - (1 :: 16 word))) \<and> num - b \<le> x \<and> x - (num - b) = sqr (res_g + (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word)))) \<and> res_g + (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) + ((1 :: 16 word) << unat (m - (1 :: 16 word))) \<le> (256 :: 16 word) \<and> x \<le> sqr (res_g + (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) + ((1 :: 16 word) << unat (m - (1 :: 16 word)))) - (1 :: 16 word) else uint (sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (2 :: 16 word)) < uint (sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word)))) \<and> m - (1 :: 16 word) \<le> (8 :: 16 word) \<and> (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (1 :: 16 word) = (if m - (1 :: 16 word) = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word) - (1 :: 16 word))) \<and> sqr (if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (2 :: 16 word) = sqr ((if m = (0 :: 16 word) then 0 :: 16 word else (1 :: 16 word) << unat (m - (1 :: 16 word))) >> unat (1 :: 16 word)) \<and> is_pow2 res_g (m - (1 :: 16 word)) \<and> res_g < (256 :: 16 word) \<and> res_g * ((1 :: 16 word) << unat m) >> unat (1 :: 16 word) = res_g * ((1 :: 16 word) << unat (m - (1 :: 16 word))) \<and> num \<le> x \<and> x - num = sqr res_g \<and> res_g + ((1 :: 16 word) << unat (m - (1 :: 16 word))) \<le> (256 :: 16 word) \<and> x \<le> sqr (res_g + ((1 :: 16 word) << unat (m - (1 :: 16 word)))) - (1 :: 16 word) else sqr (res_g * ((1 :: 16 word) << unat m)) \<le> x \<and> x \<le> sqr (res_g * ((1 :: 16 word) << unat m) + (1 :: 16 word)) - (1 :: 16 word))"
  sorry
end
