theory isqrt_von_neumann_VonNeumann64_isqrt64qtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.WellFounded_WellFounded" "Why3STD.Ref_Ref"
begin
definition sqr :: "64 word \<Rightarrow> 64 word"
  where "sqr x = x * x" for x
definition is_pow2 :: "64 word \<Rightarrow> 64 word \<Rightarrow> _"
  where "is_pow2 x n \<longleftrightarrow> x AND ((1 :: 64 word) << unat n) - (1 :: 64 word) = (0 :: 64 word)" for x n
theorem isqrt64'vc:
  fixes x :: "64 word"
  shows "(32 :: 64 word) \<le> (32 :: 64 word)"
  and "(2147483648 :: 64 word) = (if (32 :: 64 word) = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat ((32 :: 64 word) - (1 :: 64 word)))"
  and "(4611686018427387904 :: 64 word) = sqr (2147483648 :: 64 word)"
  and "is_pow2 (0 :: 64 word) (32 :: 64 word)"
  and "(0 :: 64 word) < (4294967296 :: 64 word)"
  and "(0 :: 64 word) = (0 :: 64 word) * ((1 :: 64 word) << unat (32 :: 64 word))"
  and "x \<le> x"
  and "x - x = sqr (0 :: 64 word)"
  and "(0 :: 64 word) + ((1 :: 64 word) << unat (32 :: 64 word)) \<le> (4294967296 :: 64 word)"
  and "x \<le> sqr ((0 :: 64 word) + ((1 :: 64 word) << unat (32 :: 64 word))) - (1 :: 64 word)"
  and "\<forall>(res_g :: 64 word) (m :: 64 word) (num :: 64 word). m \<le> (32 :: 64 word) \<and> is_pow2 res_g m \<and> res_g < (4294967296 :: 64 word) \<and> num \<le> x \<and> x - num = sqr res_g \<and> res_g + ((1 :: 64 word) << unat m) \<le> (4294967296 :: 64 word) \<and> x \<le> sqr (res_g + ((1 :: 64 word) << unat m)) - (1 :: 64 word) \<longrightarrow> (if \<not>sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) = (0 :: 64 word) then let b :: 64 word = res_g * ((1 :: 64 word) << unat m) OR sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) in if num \<ge> b then uint (sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (2 :: 64 word)) < uint (sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word)))) \<and> m - (1 :: 64 word) \<le> (32 :: 64 word) \<and> (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (1 :: 64 word) = (if m - (1 :: 64 word) = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word) - (1 :: 64 word))) \<and> sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (2 :: 64 word) = sqr ((if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (1 :: 64 word)) \<and> is_pow2 (res_g + (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word)))) (m - (1 :: 64 word)) \<and> res_g + (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) < (4294967296 :: 64 word) \<and> (res_g * ((1 :: 64 word) << unat m) >> unat (1 :: 64 word)) OR sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) = (res_g + (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word)))) * ((1 :: 64 word) << unat (m - (1 :: 64 word))) \<and> num - b \<le> x \<and> x - (num - b) = sqr (res_g + (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word)))) \<and> res_g + (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) + ((1 :: 64 word) << unat (m - (1 :: 64 word))) \<le> (4294967296 :: 64 word) \<and> x \<le> sqr (res_g + (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) + ((1 :: 64 word) << unat (m - (1 :: 64 word)))) - (1 :: 64 word) else uint (sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (2 :: 64 word)) < uint (sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word)))) \<and> m - (1 :: 64 word) \<le> (32 :: 64 word) \<and> (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (1 :: 64 word) = (if m - (1 :: 64 word) = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word) - (1 :: 64 word))) \<and> sqr (if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (2 :: 64 word) = sqr ((if m = (0 :: 64 word) then 0 :: 64 word else (1 :: 64 word) << unat (m - (1 :: 64 word))) >> unat (1 :: 64 word)) \<and> is_pow2 res_g (m - (1 :: 64 word)) \<and> res_g < (4294967296 :: 64 word) \<and> res_g * ((1 :: 64 word) << unat m) >> unat (1 :: 64 word) = res_g * ((1 :: 64 word) << unat (m - (1 :: 64 word))) \<and> num \<le> x \<and> x - num = sqr res_g \<and> res_g + ((1 :: 64 word) << unat (m - (1 :: 64 word))) \<le> (4294967296 :: 64 word) \<and> x \<le> sqr (res_g + ((1 :: 64 word) << unat (m - (1 :: 64 word)))) - (1 :: 64 word) else sqr (res_g * ((1 :: 64 word) << unat m)) \<le> x \<and> x \<le> sqr (res_g * ((1 :: 64 word) << unat m) + (1 :: 64 word)) - (1 :: 64 word))"
  sorry
end
