theory just_join_Top_join2qtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  elt
consts lt :: "elt \<Rightarrow> elt \<Rightarrow> bool"
axiomatization where Trans:   "lt x z"
 if "lt x y"
 and "lt y z"
  for x :: "elt"
  and y :: "elt"
  and z :: "elt"
axiomatization where Asymm:   "\<not>lt y x"
 if "lt x y"
  for x :: "elt"
  and y :: "elt"
axiomatization where Trichotomy:   "lt x y \<or> lt y x \<or> x = y"
  for x :: "elt"
  and y :: "elt"
datatype  tree = E | N "int" "tree" "elt" "tree"
definition ht :: "tree \<Rightarrow> int"
  where "ht t = (case t of E \<Rightarrow> (0 :: int) | N h _ _ _ \<Rightarrow> h)" for t
definition node :: "tree \<Rightarrow> elt \<Rightarrow> tree \<Rightarrow> tree"
  where "node l x r = N ((1 :: int) + max (ht l) (ht r)) l x r" for l x r
fun height :: "tree \<Rightarrow> int"
  where "height (E :: tree) = (0 :: int)"
      | "height (N x l x0 r) = (1 :: int) + max (height l) (height r)" for x l x0 r
axiomatization where height'spec:   "(0 :: int) \<le> height t"
  for t :: "tree"
fun wf :: "tree \<Rightarrow> _"
  where "wf (E :: tree) = True"
      | "wf (N h l x_x r) = (h = height (N h l x_x r) \<and> wf l \<and> wf r)" for h l x_x r
fun mem :: "elt \<Rightarrow> tree \<Rightarrow> _"
  where "mem y (E :: tree) = False" for y
      | "mem y (N x0 l x r) = (mem y l \<or> y = x \<or> mem y r)" for y x0 l x r
definition tree_lt :: "tree \<Rightarrow> elt \<Rightarrow> _"
  where "tree_lt t y \<longleftrightarrow> (\<forall>(x :: elt). mem x t \<longrightarrow> lt x y)" for t y
definition lt_tree :: "elt \<Rightarrow> tree \<Rightarrow> _"
  where "lt_tree y t \<longleftrightarrow> (\<forall>(x :: elt). mem x t \<longrightarrow> lt y x)" for y t
fun bst :: "tree \<Rightarrow> _"
  where "bst (E :: tree) = True"
      | "bst (N x0 l x r) = (bst l \<and> tree_lt l x \<and> bst r \<and> lt_tree x r)" for x0 l x r
fun avl :: "tree \<Rightarrow> _"
  where "avl (E :: tree) = True"
      | "avl (N x l x0 r) = (avl l \<and> avl r \<and> -(1 :: int) \<le> height l - height r \<and> height l - height r \<le> (1 :: int))" for x l x0 r
theorem join2'vc:
  fixes l :: "tree"
  fixes r :: "tree"
  assumes fact0: "wf l"
  assumes fact1: "bst l"
  assumes fact2: "avl l"
  assumes fact3: "wf r"
  assumes fact4: "bst r"
  assumes fact5: "avl r"
  assumes fact6: "\<forall>(x :: elt) (y :: elt). mem x l \<longrightarrow> mem y r \<longrightarrow> lt x y"
  shows "case l of E \<Rightarrow> True | _ \<Rightarrow> (\<not>l = (E :: tree) \<and> wf l \<and> bst l \<and> avl l) \<and> (\<forall>(l1 :: tree) (k :: elt). (wf l1 \<and> bst l1 \<and> avl l1) \<and> (\<forall>(x :: elt). mem x l \<longleftrightarrow> mem x l1 \<and> lt x k \<or> x = k) \<and> tree_lt l1 k \<longrightarrow> (wf l1 \<and> wf r) \<and> (bst l1 \<and> tree_lt l1 k) \<and> (bst r \<and> lt_tree k r) \<and> avl l1 \<and> avl r)"
  and "\<forall>(t :: tree). (case l of E \<Rightarrow> t = r | _ \<Rightarrow> (\<exists>(r1 :: tree) (m :: elt). ((wf r1 \<and> bst r1 \<and> avl r1) \<and> (\<forall>(x :: elt). mem x l \<longleftrightarrow> mem x r1 \<and> lt x m \<or> x = m) \<and> tree_lt r1 m) \<and> wf t \<and> bst t \<and> (\<forall>(y :: elt). mem y t \<longleftrightarrow> mem y r1 \<or> y = m \<or> mem y r) \<and> avl t \<and> height t \<le> (1 :: int) + max (height r1) (height r))) \<longrightarrow> (wf t \<and> bst t \<and> avl t) \<and> (\<forall>(x :: elt). mem x t \<longleftrightarrow> mem x l \<or> mem x r)"
  sorry
end
