theory kleene_algebra_Dioid_le_compat_add_rightqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  t
consts zero :: "t"
consts one :: "t"
consts infix_pl :: "t \<Rightarrow> t \<Rightarrow> t"
consts infix_as :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l:   "infix_pl zero x = x"
  for x :: "t"
axiomatization where Unit_def_r:   "infix_pl x zero = x"
  for x :: "t"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l1:   "infix_as one x = x"
  for x :: "t"
axiomatization where Unit_def_r1:   "infix_as x one = x"
  for x :: "t"
axiomatization where Mul_zero_l:   "infix_as zero x = zero"
  for x :: "t"
axiomatization where Mul_zero_r:   "infix_as x zero = zero"
  for x :: "t"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
consts infix_cf :: "t \<Rightarrow> int \<Rightarrow> t"
axiomatization where infix_cf'def:   "if n = (0 :: int) then infix_cf x n = one else infix_cf x n = infix_as x (infix_cf x (n - (1 :: int)))"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "t"
axiomatization where Assoc2:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l2:   "infix_as one x = x"
  for x :: "t"
axiomatization where Unit_def_r2:   "infix_as x one = x"
  for x :: "t"
axiomatization where Power_0:   "infix_cf x (0 :: int) = one"
  for x :: "t"
axiomatization where Power_s:   "infix_cf x (n + (1 :: int)) = infix_as x (infix_cf x n)"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "t"
axiomatization where Power_s_alt:   "infix_cf x n = infix_as x (infix_cf x (n - (1 :: int)))"
 if "(0 :: int) < n"
  for n :: "int"
  and x :: "t"
axiomatization where Power_1:   "infix_cf x (1 :: int) = x"
  for x :: "t"
axiomatization where Power_sum:   "infix_cf x (n + m) = infix_as (infix_cf x n) (infix_cf x m)"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "t"
axiomatization where Power_mult:   "infix_cf x (n * m) = infix_cf (infix_cf x n) m"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "t"
axiomatization where Power_comm1:   "infix_as (infix_cf x n) y = infix_as y (infix_cf x n)"
 if "infix_as x y = infix_as y x"
 and "(0 :: int) \<le> n"
  for x :: "t"
  and y :: "t"
  and n :: "int"
axiomatization where Power_comm2:   "infix_cf (infix_as x y) n = infix_as (infix_cf x n) (infix_cf y n)"
 if "infix_as x y = infix_as y x"
 and "(0 :: int) \<le> n"
  for x :: "t"
  and y :: "t"
  and n :: "int"
axiomatization where Idem:   "infix_pl x x = x"
  for x :: "t"
definition infix_lseq :: "t \<Rightarrow> t \<Rightarrow> _"
  where "infix_lseq x y \<longleftrightarrow> infix_pl x y = y" for x y
theorem le_compat_add_right'vc:
  fixes x :: "t"
  fixes y :: "t"
  fixes z :: "t"
  assumes fact0: "infix_lseq x y"
  shows "infix_lseq (infix_as x z) (infix_as y z)"
  sorry
end
