theory kleene_algebra_RelAlgebra_Star_unfold_left
  imports "NTP4Verif.NTP4Verif" "Why3STD.map_Const" "Why3STD.map_MapExt"
begin
typedecl  a
typedecl  t
consts fc :: "a \<Rightarrow> a \<times> a"
axiomatization where fc'def:   "fc a1 = (a1, a1)"
  for a1 :: "a"
definition one :: "(a \<times> a) set"
  where "one = image fc UNIV"
consts result :: "a \<times> a \<Rightarrow> a"
consts result1 :: "a \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where result'def:   "result p = (case p of (_, a2) \<Rightarrow> a2)"
  for p :: "a \<times> a"
axiomatization where result'def1:   "result1 x p = True \<longleftrightarrow> (case p of (a1, _) \<Rightarrow> a1 = x)"
  for x :: "a"
  and p :: "a \<times> a"
definition post :: "(a \<times> a) set \<Rightarrow> a \<Rightarrow> a set"
  where "post s x = image result (set_filter s (result1 x))" for s x
axiomatization where post'spec:   "y \<in> post s x \<longleftrightarrow> (x, y) \<in> s"
  for y :: "a"
  and s :: "(a \<times> a) set"
  and x :: "a"
consts result2 :: "a \<times> a \<Rightarrow> a"
consts result3 :: "a \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where result'def2:   "result2 p = (case p of (a1, _) \<Rightarrow> a1)"
  for p :: "a \<times> a"
axiomatization where result'def3:   "result3 y p = True \<longleftrightarrow> (case p of (_, a2) \<Rightarrow> a2 = y)"
  for y :: "a"
  and p :: "a \<times> a"
definition pre :: "(a \<times> a) set \<Rightarrow> a \<Rightarrow> a set"
  where "pre s y = image result2 (set_filter s (result3 y))" for s y
axiomatization where pre'spec:   "x \<in> pre s y \<longleftrightarrow> (x, y) \<in> s"
  for x :: "a"
  and s :: "(a \<times> a) set"
  and y :: "a"
axiomatization where infix_pl'spec:   "x \<in> s1 \<union> s2 \<longleftrightarrow> x \<in> s1 \<or> x \<in> s2"
  for x :: "a \<times> a"
  and s1 :: "(a \<times> a) set"
  and s2 :: "(a \<times> a) set"
consts result4 :: "(a \<times> a) set \<Rightarrow> (a \<times> a) set \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where result'def4:   "result4 s1 s2 p = True \<longleftrightarrow> (case p of (a1, a2) \<Rightarrow> \<not>disjnt (post s1 a1) (pre s2 a2))"
  for s1 :: "(a \<times> a) set"
  and s2 :: "(a \<times> a) set"
  and p :: "a \<times> a"
definition infix_as :: "(a \<times> a) set \<Rightarrow> (a \<times> a) set \<Rightarrow> (a \<times> a) set"
  where "infix_as s1 s2 = set_filter UNIV (result4 s1 s2)" for s1 s2
axiomatization where infix_as'spec:   "(a1, a2) \<in> infix_as s1 s2 \<longleftrightarrow> (\<exists>(x :: a). (a1, x) \<in> s1 \<and> (x, a2) \<in> s2)"
  for a1 :: "a"
  and a2 :: "a"
  and s1 :: "(a \<times> a) set"
  and s2 :: "(a \<times> a) set"
axiomatization where Assoc:   "x \<union> y \<union> z = x \<union> (y \<union> z)"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Unit_def_l:   "{} \<union> x = x"
  for x :: "(a \<times> a) set"
axiomatization where Unit_def_r:   "x \<union> {} = x"
  for x :: "(a \<times> a) set"
axiomatization where Comm:   "x \<union> y = y \<union> x"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Unit_def_l1:   "infix_as one x = x"
  for x :: "(a \<times> a) set"
axiomatization where Unit_def_r1:   "infix_as x one = x"
  for x :: "(a \<times> a) set"
axiomatization where Mul_zero_l:   "infix_as {} x = {}"
  for x :: "(a \<times> a) set"
axiomatization where Mul_zero_r:   "infix_as x {} = {}"
  for x :: "(a \<times> a) set"
axiomatization where Mul_distr_l:   "infix_as x (y \<union> z) = infix_as x y \<union> infix_as x z"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Mul_distr_r:   "infix_as (y \<union> z) x = infix_as y x \<union> infix_as z x"
  for y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
  and x :: "(a \<times> a) set"
consts infix_cf :: "(a \<times> a) set \<Rightarrow> int \<Rightarrow> (a \<times> a) set"
axiomatization where infix_cf'def:   "if n = (0 :: int) then infix_cf x n = one else infix_cf x n = infix_as x (infix_cf x (n - (1 :: int)))"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Assoc2:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Unit_def_l2:   "infix_as one x = x"
  for x :: "(a \<times> a) set"
axiomatization where Unit_def_r2:   "infix_as x one = x"
  for x :: "(a \<times> a) set"
axiomatization where Power_0:   "infix_cf x (0 :: int) = one"
  for x :: "(a \<times> a) set"
axiomatization where Power_s:   "infix_cf x (n + (1 :: int)) = infix_as x (infix_cf x n)"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_s_alt:   "infix_cf x n = infix_as x (infix_cf x (n - (1 :: int)))"
 if "(0 :: int) < n"
  for n :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_1:   "infix_cf x (1 :: int) = x"
  for x :: "(a \<times> a) set"
axiomatization where Power_sum:   "infix_cf x (n + m) = infix_as (infix_cf x n) (infix_cf x m)"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_mult:   "infix_cf x (n * m) = infix_cf (infix_cf x n) m"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_comm1:   "infix_as (infix_cf x n) y = infix_as y (infix_cf x n)"
 if "infix_as x y = infix_as y x"
 and "(0 :: int) \<le> n"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and n :: "int"
axiomatization where Power_comm2:   "infix_cf (infix_as x y) n = infix_as (infix_cf x n) (infix_cf y n)"
 if "infix_as x y = infix_as y x"
 and "(0 :: int) \<le> n"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and n :: "int"
axiomatization where Idem:   "x \<union> x = x"
  for x :: "(a \<times> a) set"
definition infix_lseq :: "(a \<times> a) set \<Rightarrow> (a \<times> a) set \<Rightarrow> _"
  where "infix_lseq x y \<longleftrightarrow> x \<union> y = y" for x y
inductive in_star :: "(a \<times> a) set \<Rightarrow> a \<times> a \<Rightarrow> bool" where
   Star_0: "in_star s (x, x)" for s :: "(a \<times> a) set" and x :: "a"
 | Star_s: "in_star s (x, y) \<Longrightarrow> (y, z) \<in> s \<Longrightarrow> in_star s (x, z)" for s :: "(a \<times> a) set" and x :: "a" and y :: "a" and z :: "a"
consts in_star_closure :: "(a \<times> a) set \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where in_star_closure_def:   "in_star_closure y y1 = True \<longleftrightarrow> in_star y y1"
  for y :: "(a \<times> a) set"
  and y1 :: "a \<times> a"
definition prefix_ex :: "(a \<times> a) set \<Rightarrow> (a \<times> a) set"
  where "prefix_ex s = set_filter UNIV (in_star_closure s)" for s
axiomatization where Assoc3:   "x \<union> y \<union> z = x \<union> (y \<union> z)"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Unit_def_l3:   "{} \<union> x = x"
  for x :: "(a \<times> a) set"
axiomatization where Unit_def_r3:   "x \<union> {} = x"
  for x :: "(a \<times> a) set"
axiomatization where Comm1:   "x \<union> y = y \<union> x"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
axiomatization where Assoc4:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Unit_def_l4:   "infix_as one x = x"
  for x :: "(a \<times> a) set"
axiomatization where Unit_def_r4:   "infix_as x one = x"
  for x :: "(a \<times> a) set"
axiomatization where Mul_zero_l1:   "infix_as {} x = {}"
  for x :: "(a \<times> a) set"
axiomatization where Mul_zero_r1:   "infix_as x {} = {}"
  for x :: "(a \<times> a) set"
axiomatization where Mul_distr_l1:   "infix_as x (y \<union> z) = infix_as x y \<union> infix_as x z"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Mul_distr_r1:   "infix_as (y \<union> z) x = infix_as y x \<union> infix_as z x"
  for y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
  and x :: "(a \<times> a) set"
consts infix_cf' :: "(a \<times> a) set \<Rightarrow> int \<Rightarrow> (a \<times> a) set"
axiomatization where infix_cf'def1:   "if n = (0 :: int) then infix_cf' x n = one else infix_cf' x n = infix_as x (infix_cf' x (n - (1 :: int)))"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Assoc5:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and z :: "(a \<times> a) set"
axiomatization where Unit_def_l5:   "infix_as one x = x"
  for x :: "(a \<times> a) set"
axiomatization where Unit_def_r5:   "infix_as x one = x"
  for x :: "(a \<times> a) set"
axiomatization where Power_01:   "infix_cf' x (0 :: int) = one"
  for x :: "(a \<times> a) set"
axiomatization where Power_s1:   "infix_cf' x (n + (1 :: int)) = infix_as x (infix_cf' x n)"
 if "(0 :: int) \<le> n"
  for n :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_s_alt1:   "infix_cf' x n = infix_as x (infix_cf' x (n - (1 :: int)))"
 if "(0 :: int) < n"
  for n :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_11:   "infix_cf' x (1 :: int) = x"
  for x :: "(a \<times> a) set"
axiomatization where Power_sum1:   "infix_cf' x (n + m) = infix_as (infix_cf' x n) (infix_cf' x m)"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_mult1:   "infix_cf' x (n * m) = infix_cf' (infix_cf' x n) m"
 if "(0 :: int) \<le> n"
 and "(0 :: int) \<le> m"
  for n :: "int"
  and m :: "int"
  and x :: "(a \<times> a) set"
axiomatization where Power_comm11:   "infix_as (infix_cf' x n) y = infix_as y (infix_cf' x n)"
 if "infix_as x y = infix_as y x"
 and "(0 :: int) \<le> n"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and n :: "int"
axiomatization where Power_comm21:   "infix_cf' (infix_as x y) n = infix_as (infix_cf' x n) (infix_cf' y n)"
 if "infix_as x y = infix_as y x"
 and "(0 :: int) \<le> n"
  for x :: "(a \<times> a) set"
  and y :: "(a \<times> a) set"
  and n :: "int"
axiomatization where Idem1:   "x \<union> x = x"
  for x :: "(a \<times> a) set"
definition infix_lseq1 :: "(a \<times> a) set \<Rightarrow> (a \<times> a) set \<Rightarrow> _"
  where "infix_lseq1 x y \<longleftrightarrow> x \<union> y = y" for x y
theorem Star_unfold_left:
  fixes x :: "(a \<times> a) set"
  shows "infix_lseq1 (one \<union> infix_as x (prefix_ex x)) (prefix_ex x)"
  sorry
end
