theory kleene_algebra_RelAlgebra_infix_asqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.map_Const" "Why3STD.map_MapExt"
begin
typedecl  a
typedecl  t
consts fc :: "a \<Rightarrow> a \<times> a"
axiomatization where fc'def:   "fc a1 = (a1, a1)"
  for a1 :: "a"
definition one :: "(a \<times> a) set"
  where "one = image fc UNIV"
consts result :: "a \<times> a \<Rightarrow> a"
consts result1 :: "a \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where result'def:   "result p = (case p of (_, a2) \<Rightarrow> a2)"
  for p :: "a \<times> a"
axiomatization where result'def1:   "result1 x p = True \<longleftrightarrow> (case p of (a1, _) \<Rightarrow> a1 = x)"
  for x :: "a"
  and p :: "a \<times> a"
definition post :: "(a \<times> a) set \<Rightarrow> a \<Rightarrow> a set"
  where "post s x = image result (set_filter s (result1 x))" for s x
axiomatization where post'spec:   "y \<in> post s x \<longleftrightarrow> (x, y) \<in> s"
  for y :: "a"
  and s :: "(a \<times> a) set"
  and x :: "a"
consts result2 :: "a \<times> a \<Rightarrow> a"
consts result3 :: "a \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where result'def2:   "result2 p = (case p of (a1, _) \<Rightarrow> a1)"
  for p :: "a \<times> a"
axiomatization where result'def3:   "result3 y p = True \<longleftrightarrow> (case p of (_, a2) \<Rightarrow> a2 = y)"
  for y :: "a"
  and p :: "a \<times> a"
definition pre :: "(a \<times> a) set \<Rightarrow> a \<Rightarrow> a set"
  where "pre s y = image result2 (set_filter s (result3 y))" for s y
axiomatization where pre'spec:   "x \<in> pre s y \<longleftrightarrow> (x, y) \<in> s"
  for x :: "a"
  and s :: "(a \<times> a) set"
  and y :: "a"
axiomatization where infix_pl'spec:   "x \<in> s1 \<union> s2 \<longleftrightarrow> x \<in> s1 \<or> x \<in> s2"
  for x :: "a \<times> a"
  and s1 :: "(a \<times> a) set"
  and s2 :: "(a \<times> a) set"
consts o1 :: "(a \<times> a) set \<Rightarrow> (a \<times> a) set \<Rightarrow> a \<times> a \<Rightarrow> bool"
axiomatization where o'def:   "o1 s1 s2 p = True \<longleftrightarrow> (case p of (a1, a2) \<Rightarrow> \<not>disjnt (post s1 a1) (pre s2 a2))"
  for s1 :: "(a \<times> a) set"
  and s2 :: "(a \<times> a) set"
  and p :: "a \<times> a"
theorem infix_as'vc:
  fixes a1 :: "a"
  fixes a2 :: "a"
  fixes s1 :: "(a \<times> a) set"
  fixes s2 :: "(a \<times> a) set"
  shows "(a1, a2) \<in> set_filter UNIV (o1 s1 s2) \<longleftrightarrow> (\<exists>(x :: a). (a1, x) \<in> s1 \<and> (x, a2) \<in> s2)"
  sorry
end
