theory kleene_algebra_SemiRing_infix_cfqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  t
consts zero :: "t"
consts one :: "t"
consts infix_pl :: "t \<Rightarrow> t \<Rightarrow> t"
consts infix_as :: "t \<Rightarrow> t \<Rightarrow> t"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l:   "infix_pl zero x = x"
  for x :: "t"
axiomatization where Unit_def_r:   "infix_pl x zero = x"
  for x :: "t"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "t"
  and y :: "t"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Unit_def_l1:   "infix_as one x = x"
  for x :: "t"
axiomatization where Unit_def_r1:   "infix_as x one = x"
  for x :: "t"
axiomatization where Mul_zero_l:   "infix_as zero x = zero"
  for x :: "t"
axiomatization where Mul_zero_r:   "infix_as x zero = zero"
  for x :: "t"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "t"
  and y :: "t"
  and z :: "t"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "t"
  and z :: "t"
  and x :: "t"
theorem infix_cf'vc:
  fixes n :: "int"
  assumes fact0: "(0 :: int) \<le> n"
  assumes fact1: "\<not>n = (0 :: int)"
  shows "let o1 :: int = n - (1 :: int) in ((0 :: int) \<le> n \<and> o1 < n) \<and> (0 :: int) \<le> o1"
  sorry
end
