import Mathlib

open Classical

namespace Lean4Why3

instance {n : Nat} : HShiftLeft (BitVec n) Int (BitVec n) where
  hShiftLeft x k := x <<< k.toNat

instance {n : Nat} : HShiftRight (BitVec n) Int (BitVec n) where
  hShiftRight x k := x >>> k.toNat

abbrev sshiftRight'i {n : ℕ} (a : BitVec n) (s : Int) : BitVec n := a.sshiftRight s.toNat

abbrev make_str_i (size : Int) := String.mk (List.replicate (Int.toNat size) 'a')
abbrev _root_.List.create_i {α} (n : ℤ) (f : ℤ -> α) := (List.range n.toNat).map f
abbrev _root_.List.create {α} (n : ℕ) (f : ℕ -> α) := (List.range n).map f

abbrev _root_.Bool.imp (a b : Bool) : Bool := !a || b

abbrev _root_.List.replicate_i {α} (n : ℤ) (x : α) := List.replicate (Int.toNat n) x

abbrev take_i {α : Type} (n : ℤ) (l : List α) := List.take n.toNat l
abbrev drop_i {α : Type} (n : ℤ) (l : List α) := List.drop n.toNat l

abbrev getElem_i! {α : Type} [Inhabited α] (l : List α) (i : Int) := l[i.toNat]!
abbrev getElem_i? {α : Type} (l : List α) (i : Int) := l[i.toNat]?

abbrev length_i {α : Type} (l : List α) := Int.ofNat l.length
abbrev slice {α : Type} (l : List α) (i j : Nat) : List α :=
  (l.drop i).take (j - i)
abbrev slice_i {α : Type} (l : List α) (i j : Int) : List α :=
  (l.drop i.toNat).take (j.toNat - i.toNat)

abbrev Sorted {α : Type} [LE α] (l : List α) := List.Sorted LE.le l
abbrev _root_.List.set_i {α : Type} (l : List α) (n : ℤ) (a : α) :=
  List.set l n.toNat a

abbrev implication (P : Prop) (Q : Prop) := P -> Q

noncomputable def map_occ {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := {n | l ≤ n ∧ n < u ∧ m n = v }.ncard
noncomputable abbrev map_occ_i {α : Type} (v : α) (m : Int -> α) (l u : Int)
  := Int.ofNat (map_occ (v : α) (m : Int -> α) (l : Int) u)

abbrev _root_.BitVec.toUInt {n : Nat} (x : BitVec n) := Int.ofNat x.toNat

abbrev int'16_max : BitVec 16 := 32767
abbrev int'16_min : BitVec 16 := -32768
abbrev int'31_max : BitVec 31 := 1073741823
abbrev int'31_min : BitVec 31 := -1073741824
abbrev int'32_max : BitVec 32 := 2147483647
abbrev int'32_min : BitVec 32 := -2147483648
abbrev int'63_max : BitVec 63 := 4611686018427387903
abbrev int'63_min : BitVec 63 := -4611686018427387904
abbrev int'64_max : BitVec 64 := 9223372036854775807
abbrev int'64_min : BitVec 64 := -9223372036854775808
abbrev uint'16_max : BitVec 16 := 65535
abbrev uint'16_min : BitVec 16 := 0
abbrev uint'31_max : BitVec 31 := 2147483647
abbrev uint'31_min : BitVec 31 := 0
abbrev uint'32_max : BitVec 32 := 4294967295
abbrev uint'32_min : BitVec 32 := 0
abbrev uint'63_max : BitVec 63 := 9223372036854775807
abbrev uint'63_min : BitVec 63 := 0
abbrev uint'64_max : BitVec 64 := 18446744073709551615
abbrev uint'64_min : BitVec 64 := 0

abbrev int'16_in_bounds (x : Int) := int'16_min.toInt ≤ x ∧ x ≤ int'16_max.toInt
abbrev int'31_in_bounds (x : Int) := int'31_min.toInt ≤ x ∧ x ≤ int'31_max.toInt
abbrev int'32_in_bounds (x : Int) := int'32_min.toInt ≤ x ∧ x ≤ int'32_max.toInt
abbrev int'63_in_bounds (x : Int) := int'63_min.toInt ≤ x ∧ x ≤ int'63_max.toInt
abbrev int'64_in_bounds (x : Int) := int'64_min.toInt ≤ x ∧ x ≤ int'64_max.toInt
abbrev uint'8_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ 256
abbrev uint'16_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'16_max.toUInt
abbrev uint'31_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'31_max.toUInt
abbrev uint'32_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'32_max.toUInt
abbrev uint'63_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'63_max.toUInt
abbrev uint'64_in_bounds (x : Int) := 0 ≤ x ∧ x ≤ int'64_max.toUInt

axiom array31 : Type -> Type
axiom array32 : Type -> Type
axiom array63 : Type -> Type

axiom array31_elts : {α : Type} -> array31 α -> Int -> α
axiom array32_elts : {α : Type} -> array32 α -> Int -> α
axiom array63_elts : {α : Type} -> array63 α -> List α

noncomputable abbrev array63_nth {α : Type} [Inhabited α] (a : array63 α) (i : Int) := (array63_elts a)[i.toNat]!

axiom array31_length : {α : Type} -> array31 α -> BitVec 31
axiom array32_length : {α : Type} -> array32 α -> BitVec 32
axiom array63_length : {α : Type} -> array63 α -> BitVec 63

abbrev is_none {α : Type} (x : Option α) := x = none
abbrev is_nil {α : Type} (x : List α) := x = []

abbrev _root_.List.rev_append {α : Type} (a : List α) (b : List α) := a.reverse ++ b
abbrev _root_.Finset.is_empty {α : Type} (s : Finset α) := s = ∅
abbrev _root_.Finset.filter' {α : Type} (s : Finset α) (p : α → Prop) [DecidablePred p] : Finset α
  := Finset.filter p s

abbrev _root_.Finset.card_i {α : Type} (s : Finset α) := Int.ofNat s.card

abbrev int_power (x : Int) (n : Int) := x ^ n.toNat
abbrev bv2_power (n : Int) := Int.ofNat (2 ^ n.toNat)

abbrev take_bit_i {n : Nat} (x : BitVec n) (i : Int) := x[i.toNat]!
abbrev take_bit_bv {n m : Nat} (x : BitVec n) (i : BitVec m) := x[i.toNat]!

noncomputable def _root_.Finset.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default
noncomputable def _root_.Set.pick! {α} [Inhabited α] (s : Finset α) : α :=
  if h : s.Nonempty then Classical.choose h else default

noncomputable abbrev _root_.BitVec.eq_sub {m : Nat} (a b : BitVec m) (i n : Nat) :=
  BitVec.extractLsb (i+n-1) i a = BitVec.extractLsb (i+n-1) i b

noncomputable abbrev _root_.BitVec.eq_sub_i {m : Nat} (a b : BitVec m) (i n : Int) :=
  BitVec.eq_sub a b i.toNat n.toNat

noncomputable abbrev _root_.BitVec.eq_sub_bv {m : Nat} {m1 : Nat} {m2 : Nat} (a b : BitVec m) (i : BitVec m1) (n : BitVec m2) :=
  BitVec.eq_sub a b i.toNat n.toNat

abbrev w8_size_bv := (8 : BitVec 8)
abbrev w16_size_bv := (16 : BitVec 16)
abbrev w32_size_bv := (32 : BitVec 32)
abbrev w64_size_bv := (64 : BitVec 64)
abbrev w128_size_bv := (128 : BitVec 128)
abbrev w256_size_bv := (256 : BitVec 256)
abbrev w8_size_i := (8 : Int)
abbrev w16_size_i := (16 : Int)
abbrev w32_size_i := (32 : Int)
abbrev w64_size_i := (64 : Int)
abbrev w128_size_i := (128 : Int)
abbrev w256_size_i := (256 : Int)

abbrev _root_.Finset.erase' {α : Type} [DecidableEq α] (a : α) (s : Finset α) : Finset α
  := Finset.erase s a

abbrev _root_.BitVec.sge {n : ℕ} (x y : BitVec n) := BitVec.sle y x
abbrev _root_.BitVec.sgt {n : ℕ} (x y : BitVec n) := BitVec.slt y x

abbrev _root_.BitVec.sshiftRight_i {n : ℕ} (x : BitVec n) (s : ℤ) := BitVec.sshiftRight x s.toNat
abbrev _root_.BitVec.sshiftRight_bv {n m : ℕ} (x : BitVec n) (s : BitVec m)
  := BitVec.sshiftRight x s.toNat

abbrev _root_.BitVec.rotateLeft_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateLeft x n.toNat
abbrev _root_.BitVec.rotateLeft_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateLeft x n.toNat

abbrev _root_.BitVec.rotateRight_i {w : ℕ} (x : BitVec w) (n : ℤ) := BitVec.rotateRight x n.toNat
abbrev _root_.BitVec.rotateRight_nv {w w2 : ℕ} (x : BitVec w) (n : BitVec w2)
  := BitVec.rotateRight x n.toNat

abbrev _root_.Multiset.count_i {α : Type} [DecidableEq α] (a : α) (s : Multiset α)
  := Int.ofNat (s.count a)

abbrev _root_.Multiset.card_i {α : Type} (S : Multiset α) := Int.ofNat S.card

abbrev _root_.Int.gcd_i (a : ℤ) (b : ℤ) := Int.ofNat (Int.gcd a b)

abbrev _root_.Int.Prime (p : ℤ) := Nat.Prime p.toNat
abbrev _root_.Int.Coprime (a b : ℤ) := Nat.Coprime a.toNat b.toNat

abbrev _root_.Set.remove {α : Type} (x : α) (A : Set α) := A \ {x}
abbrev _root_.Set.filter {α : Type} (S : Set α) (P : α -> Bool) := {x ∈ S | P x }

abbrev _root_.Option.the {α : Type} [Inhabited α] (opt : Option α) := opt.getD default

noncomputable abbrev _root_.Finmap.lookup! {K : Type} {V : Type} [Inhabited V] (m : Finmap (fun _ : K => V)) (k : K) :=
  (Finmap.lookup k m).getD default

noncomputable abbrev _root_.Finmap.mapsto {K V : Type} (k : K) (v : V) (m : Finmap (fun _ : K => V))
  := Finmap.lookup k m = some v

abbrev _root_.Finmap.is_empty {K V : Type} (m : Finmap (fun _ : K => V)) := m = ∅
abbrev _root_.Finmap.size {K V : Type} (m : Finmap (fun _ : K => V)) := m.keys.card

abbrev _root_.Finset.min'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.min with
  | ⊤        => default
  | .some a  => a

abbrev _root_.Finset.max'' {α} [Inhabited α] [LinearOrder α] (s : Finset α) : α :=
  match s.max with
  | ⊥        => default
  | .some a  => a

abbrev arrayExchange {α} [Inhabited α] (a1 a2 : List α) (i j : Int) : Prop :=
  let i' := i.toNat
  let j' := j.toNat
  a1 = (a2.set i' a1[j']!).set j' (a1[i']!)

abbrev _root_.List.permut_sub {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ (0 ≤ l ∧ l ≤ a1.length) ∧ (0 ≤ u ∧ u ≤ a1.length) ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.permut_sub' {α} (a1 a2 : List α) (l u : ℕ) : Prop :=
  a1.length = a2.length ∧ slice a1 0 l = slice a2 0 l ∧
  slice a1 u a1.length = slice a2 u a1.length ∧
  List.Perm (slice a1 l u) (slice a2 l u)

abbrev _root_.List.foldr' {α β} (f : α -> β -> β) (l : List α) (x : β) := List.foldr f x l

abbrev _root_.Int.to_Real (z : ℤ) : ℝ := z

abbrev _root_.List.mem' {α} (eq : α -> α -> Bool) (x : α) (l : List α) := List.all l (eq x)

noncomputable abbrev _root_.Real.truncate (x : ℝ) : ℤ := if 0 ≤ x then Int.floor x  else Int.ceil x

alias _root_.Math.abs := abs

end Lean4Why3

open Classical
open Lean4Why3

namespace Const
axiom const :  {α : Type} -> [Inhabited α] ->  {β : Type} -> [Inhabited β] -> β -> α -> β
axiom const'def {α : Type} {β : Type} [Inhabited α] [Inhabited β] (v : β) (x : α) : (const : β -> α -> β) v x = v
end Const
namespace MapExt
noncomputable def infix_eqeq {α : Type} {β : Type} [Inhabited α] [Inhabited β] (m1 : α -> β) (m2 : α -> β) := ∀(x : α), m1 x = m2 x
axiom extensionality {α : Type} {β : Type} [Inhabited α] [Inhabited β] (m1 : α -> β) (m2 : α -> β) (fact0 : infix_eqeq m1 m2) : m1 = m2
end MapExt
namespace kleene_algebra_RelAlgebra_Assoc3
axiom a : Type
axiom inhabited_axiom_a : Inhabited a
attribute [instance] inhabited_axiom_a
axiom t : Type
axiom inhabited_axiom_t : Inhabited t
attribute [instance] inhabited_axiom_t
axiom fc : a -> a × a
axiom fc'def (a1 : a) : fc a1 = (a1, a1)
noncomputable def one := fc '' Set.univ
axiom result : a × a -> a
axiom result1 : a -> a × a -> Bool
axiom result'def (p : a × a) : result p = (match p with | (_, a2) => a2)
axiom result'def1 (x : a) (p : a × a) : (result1 x p = true) = (match p with | (a1, _) => a1 = x)
noncomputable def post (s : Set (a × a)) (x : a) := result '' Set.filter s (result1 x)
axiom post'spec (y : a) (s : Set (a × a)) (x : a) : (y ∈ post s x) = ((x, y) ∈ s)
axiom result2 : a × a -> a
axiom result3 : a -> a × a -> Bool
axiom result'def2 (p : a × a) : result2 p = (match p with | (a1, _) => a1)
axiom result'def3 (y : a) (p : a × a) : (result3 y p = true) = (match p with | (_, a2) => a2 = y)
noncomputable def pre (s : Set (a × a)) (y : a) := result2 '' Set.filter s (result3 y)
axiom pre'spec (x : a) (s : Set (a × a)) (y : a) : (x ∈ pre s y) = ((x, y) ∈ s)
axiom infix_pl'spec (x : a × a) (s1 : Set (a × a)) (s2 : Set (a × a)) : (x ∈ s1 ∪ s2) = (x ∈ s1 ∨ x ∈ s2)
axiom result4 : Set (a × a) -> Set (a × a) -> a × a -> Bool
axiom result'def4 (s1 : Set (a × a)) (s2 : Set (a × a)) (p : a × a) : (result4 s1 s2 p = true) = (match p with | (a1, a2) => ¬post s1 a1 ∩ pre s2 a2 = ∅)
noncomputable def infix_as (s1 : Set (a × a)) (s2 : Set (a × a)) := Set.filter Set.univ (result4 s1 s2)
axiom infix_as'spec (a1 : a) (a2 : a) (s1 : Set (a × a)) (s2 : Set (a × a)) : ((a1, a2) ∈ infix_as s1 s2) = (∃(x : a), (a1, x) ∈ s1 ∧ (x, a2) ∈ s2)
axiom Assoc (x : Set (a × a)) (y : Set (a × a)) (z : Set (a × a)) : x ∪ y ∪ z = x ∪ (y ∪ z)
axiom Unit_def_l (x : Set (a × a)) : (∅ : Set (a × a)) ∪ x = x
axiom Unit_def_r (x : Set (a × a)) : x ∪ (∅ : Set (a × a)) = x
axiom Comm (x : Set (a × a)) (y : Set (a × a)) : x ∪ y = y ∪ x
axiom Assoc1 (x : Set (a × a)) (y : Set (a × a)) (z : Set (a × a)) : infix_as (infix_as x y) z = infix_as x (infix_as y z)
axiom Unit_def_l1 (x : Set (a × a)) : infix_as one x = x
axiom Unit_def_r1 (x : Set (a × a)) : infix_as x one = x
axiom Mul_zero_l (x : Set (a × a)) : infix_as (∅ : Set (a × a)) x = (∅ : Set (a × a))
axiom Mul_zero_r (x : Set (a × a)) : infix_as x (∅ : Set (a × a)) = (∅ : Set (a × a))
axiom Mul_distr_l (x : Set (a × a)) (y : Set (a × a)) (z : Set (a × a)) : infix_as x (y ∪ z) = infix_as x y ∪ infix_as x z
axiom Mul_distr_r (y : Set (a × a)) (z : Set (a × a)) (x : Set (a × a)) : infix_as (y ∪ z) x = infix_as y x ∪ infix_as z x
axiom infix_cf : Set (a × a) -> ℤ -> Set (a × a)
axiom infix_cf'def (n : ℤ) (x : Set (a × a)) (fact0 : (0 : ℤ) ≤ n) : if n = (0 : ℤ) then infix_cf x n = one else infix_cf x n = infix_as x (infix_cf x (n - (1 : ℤ)))
axiom Assoc2 (x : Set (a × a)) (y : Set (a × a)) (z : Set (a × a)) : infix_as (infix_as x y) z = infix_as x (infix_as y z)
axiom Unit_def_l2 (x : Set (a × a)) : infix_as one x = x
axiom Unit_def_r2 (x : Set (a × a)) : infix_as x one = x
axiom Power_0 (x : Set (a × a)) : infix_cf x (0 : ℤ) = one
axiom Power_s (n : ℤ) (x : Set (a × a)) (fact0 : (0 : ℤ) ≤ n) : infix_cf x (n + (1 : ℤ)) = infix_as x (infix_cf x n)
axiom Power_s_alt (n : ℤ) (x : Set (a × a)) (fact0 : (0 : ℤ) < n) : infix_cf x n = infix_as x (infix_cf x (n - (1 : ℤ)))
axiom Power_1 (x : Set (a × a)) : infix_cf x (1 : ℤ) = x
axiom Power_sum (n : ℤ) (m : ℤ) (x : Set (a × a)) (fact0 : (0 : ℤ) ≤ n) (fact1 : (0 : ℤ) ≤ m) : infix_cf x (n + m) = infix_as (infix_cf x n) (infix_cf x m)
axiom Power_mult (n : ℤ) (m : ℤ) (x : Set (a × a)) (fact0 : (0 : ℤ) ≤ n) (fact1 : (0 : ℤ) ≤ m) : infix_cf x (n * m) = infix_cf (infix_cf x n) m
axiom Power_comm1 (x : Set (a × a)) (y : Set (a × a)) (n : ℤ) (fact0 : infix_as x y = infix_as y x) (fact1 : (0 : ℤ) ≤ n) : infix_as (infix_cf x n) y = infix_as y (infix_cf x n)
axiom Power_comm2 (x : Set (a × a)) (y : Set (a × a)) (n : ℤ) (fact0 : infix_as x y = infix_as y x) (fact1 : (0 : ℤ) ≤ n) : infix_cf (infix_as x y) n = infix_as (infix_cf x n) (infix_cf y n)
axiom Idem (x : Set (a × a)) : x ∪ x = x
noncomputable def infix_lseq (x : Set (a × a)) (y : Set (a × a)) := x ∪ y = y
inductive in_star : Set (a × a) -> a × a -> Prop where
 | Star_0 (s : Set (a × a)) (x : a) : in_star s (x, x)
 | Star_s (s : Set (a × a)) (x : a) (y : a) (z : a) : in_star s (x, y) → (y, z) ∈ s → in_star s (x, z)
axiom in_star_closure : Set (a × a) -> a × a -> Bool
axiom in_star_closure_def (y : Set (a × a)) (y1 : a × a) : (in_star_closure y y1 = true) = in_star y y1
noncomputable def prefix_ex (s : Set (a × a)) := Set.filter Set.univ (in_star_closure s)
axiom Assoc3 (x : Set (a × a)) (y : Set (a × a)) (z : Set (a × a)) : x ∪ y ∪ z = x ∪ (y ∪ z)
axiom Unit_def_l3 (x : Set (a × a)) : (∅ : Set (a × a)) ∪ x = x
axiom Unit_def_r3 (x : Set (a × a)) : x ∪ (∅ : Set (a × a)) = x
axiom Comm1 (x : Set (a × a)) (y : Set (a × a)) : x ∪ y = y ∪ x
lemma Assoc4 (x : Set (a × a)) (y : Set (a × a)) (z : Set (a × a)) : infix_as (infix_as x y) z = infix_as x (infix_as y z)
  := sorry
end kleene_algebra_RelAlgebra_Assoc3
