theory kmp_KnuthMorrisPratt_initnextqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
typedecl  char
definition matches1 :: "char list \<Rightarrow> int \<Rightarrow> char list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "matches1 a1 i1 a2 i2 n \<longleftrightarrow> ((0 :: int) \<le> i1 \<and> i1 \<le> int (length a1) - n) \<and> ((0 :: int) \<le> i2 \<and> i2 \<le> int (length a2) - n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> a1 ! nat (i1 + i) = a2 ! nat (i2 + i))" for a1 i1 a2 i2 n
definition is_next :: "char list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "is_next p j n \<longleftrightarrow> ((0 :: int) \<le> n \<and> n < j) \<and> matches1 p (j - n) p (0 :: int) n \<and> (\<forall>(z :: int). n < z \<and> z < j \<longrightarrow> \<not>matches1 p (j - z) p (0 :: int) z)" for p j n
theorem initnext'vc:
  fixes p :: "char list"
  assumes fact0: "(1 :: int) \<le> int (length p)"
  shows "let m :: int = int (length p) in (0 :: int) \<le> m \<and> (\<forall>(next :: int list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < m \<longrightarrow> next ! nat i = (0 :: int)) \<and> int (length next) = m \<longrightarrow> (if (1 :: int) < m then ((0 :: int) \<le> (1 :: int) \<and> (1 :: int) < int (length next)) \<and> (length (next[nat (1 :: int) := 0 :: int]) = length next \<longrightarrow> nth (next[nat (1 :: int) := 0 :: int]) o nat = (nth next o nat)(1 :: int := 0 :: int) \<longrightarrow> (((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < (1 :: int) \<and> (1 :: int) \<le> m) \<and> matches1 p ((1 :: int) - (0 :: int)) p (0 :: int) (0 :: int) \<and> (\<forall>(z :: int). (0 :: int) + (1 :: int) < z \<and> z < (1 :: int) + (1 :: int) \<longrightarrow> \<not>matches1 p ((1 :: int) + (1 :: int) - z) p (0 :: int) z) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k \<le> (1 :: int) \<longrightarrow> is_next p k (next[nat (1 :: int) := 0 :: int] ! nat k))) \<and> (\<forall>(j :: int) (i :: int) (next1 :: int list). length next1 = length (next[nat (1 :: int) := 0 :: int]) \<longrightarrow> ((0 :: int) \<le> j \<and> j < i \<and> i \<le> m) \<and> matches1 p (i - j) p (0 :: int) j \<and> (\<forall>(z :: int). j + (1 :: int) < z \<and> z < i + (1 :: int) \<longrightarrow> \<not>matches1 p (i + (1 :: int) - z) p (0 :: int) z) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k \<le> i \<longrightarrow> is_next p k (next1 ! nat k)) \<longrightarrow> (if i < m - (1 :: int) then ((0 :: int) \<le> j \<and> j < int (length p)) \<and> ((0 :: int) \<le> i \<and> i < int (length p)) \<and> (if p ! nat i = p ! nat j then ((0 :: int) \<le> i + (1 :: int) \<and> i + (1 :: int) < int (length next1)) \<and> (length (next1[nat (i + (1 :: int)) := j + (1 :: int)]) = length next1 \<longrightarrow> nth (next1[nat (i + (1 :: int)) := j + (1 :: int)]) o nat = (nth next1 o nat)(i + (1 :: int) := j + (1 :: int)) \<longrightarrow> ((0 :: int) \<le> m - i \<and> m - (i + (1 :: int)) < m - i \<or> m - i = m - (i + (1 :: int)) \<and> (0 :: int) \<le> j \<and> j + (1 :: int) < j) \<and> ((0 :: int) \<le> j + (1 :: int) \<and> j + (1 :: int) < i + (1 :: int) \<and> i + (1 :: int) \<le> m) \<and> matches1 p (i + (1 :: int) - (j + (1 :: int))) p (0 :: int) (j + (1 :: int)) \<and> (\<forall>(z :: int). j + (1 :: int) + (1 :: int) < z \<and> z < i + (1 :: int) + (1 :: int) \<longrightarrow> \<not>matches1 p (i + (1 :: int) + (1 :: int) - z) p (0 :: int) z) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k \<le> i + (1 :: int) \<longrightarrow> is_next p k (next1[nat (i + (1 :: int)) := j + (1 :: int)] ! nat k))) else if j = (0 :: int) then ((0 :: int) \<le> i + (1 :: int) \<and> i + (1 :: int) < int (length next1)) \<and> (length (next1[nat (i + (1 :: int)) := 0 :: int]) = length next1 \<longrightarrow> nth (next1[nat (i + (1 :: int)) := 0 :: int]) o nat = (nth next1 o nat)(i + (1 :: int) := 0 :: int) \<longrightarrow> ((0 :: int) \<le> m - i \<and> m - (i + (1 :: int)) < m - i \<or> m - i = m - (i + (1 :: int)) \<and> (0 :: int) \<le> j \<and> j < j) \<and> ((0 :: int) \<le> j \<and> j < i + (1 :: int) \<and> i + (1 :: int) \<le> m) \<and> matches1 p (i + (1 :: int) - j) p (0 :: int) j \<and> (\<forall>(z :: int). j + (1 :: int) < z \<and> z < i + (1 :: int) + (1 :: int) \<longrightarrow> \<not>matches1 p (i + (1 :: int) + (1 :: int) - z) p (0 :: int) z) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k \<le> i + (1 :: int) \<longrightarrow> is_next p k (next1[nat (i + (1 :: int)) := 0 :: int] ! nat k))) else ((0 :: int) \<le> j \<and> j < int (length next1)) \<and> ((0 :: int) \<le> m - i \<and> m - i < m - i \<or> (0 :: int) \<le> j \<and> next1 ! nat j < j) \<and> ((0 :: int) \<le> next1 ! nat j \<and> next1 ! nat j < i \<and> i \<le> m) \<and> matches1 p (i - next1 ! nat j) p (0 :: int) (next1 ! nat j) \<and> (\<forall>(z :: int). next1 ! nat j + (1 :: int) < z \<and> z < i + (1 :: int) \<longrightarrow> \<not>matches1 p (i + (1 :: int) - z) p (0 :: int) z) \<and> (\<forall>(k :: int). (0 :: int) < k \<and> k \<le> i \<longrightarrow> is_next p k (next1 ! nat k))) else length next1 = length p \<and> (\<forall>(j1 :: int). (0 :: int) < j1 \<and> j1 < int (length p) \<longrightarrow> is_next p j1 (next1 ! nat j1))))) else length next = length p \<and> (\<forall>(j :: int). (0 :: int) < j \<and> j < int (length p) \<longrightarrow> is_next p j (next ! nat j))))"
  sorry
end
