theory kmp_KnuthMorrisPratt_kmpqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
typedecl  char
definition matches1 :: "char list \<Rightarrow> int \<Rightarrow> char list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "matches1 a1 i1 a2 i2 n \<longleftrightarrow> ((0 :: int) \<le> i1 \<and> i1 \<le> int (length a1) - n) \<and> ((0 :: int) \<le> i2 \<and> i2 \<le> int (length a2) - n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> a1 ! nat (i1 + i) = a2 ! nat (i2 + i))" for a1 i1 a2 i2 n
definition is_next :: "char list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "is_next p j n \<longleftrightarrow> ((0 :: int) \<le> n \<and> n < j) \<and> matches1 p (j - n) p (0 :: int) n \<and> (\<forall>(z :: int). n < z \<and> z < j \<longrightarrow> \<not>matches1 p (j - z) p (0 :: int) z)" for p j n
definition first_occur :: "char list \<Rightarrow> char list \<Rightarrow> int \<Rightarrow> _"
  where "first_occur p a r \<longleftrightarrow> ((0 :: int) \<le> r \<and> r < int (length a) \<longrightarrow> matches1 a r p (0 :: int) (int (length p))) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < r \<longrightarrow> \<not>matches1 a k p (0 :: int) (int (length p)))" for p a r
theorem kmp'vc:
  fixes p :: "char list"
  fixes a :: "char list"
  assumes fact0: "(1 :: int) \<le> int (length p)"
  shows "let m :: int = int (length p); n :: int = int (length a) in (1 :: int) \<le> int (length p) \<and> (\<forall>(next :: int list). length next = length p \<and> (\<forall>(j :: int). (0 :: int) < j \<and> j < int (length p) \<longrightarrow> is_next p j (next ! nat j)) \<longrightarrow> ((((0 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> m) \<and> (0 :: int) \<le> (0 :: int) \<and> (0 :: int) \<le> n) \<and> matches1 a ((0 :: int) - (0 :: int)) p (0 :: int) (0 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < (0 :: int) - (0 :: int) \<longrightarrow> \<not>matches1 a k p (0 :: int) m)) \<and> (\<forall>(j :: int) (i :: int). (((0 :: int) \<le> j \<and> j \<le> m) \<and> j \<le> i \<and> i \<le> n) \<and> matches1 a (i - j) p (0 :: int) j \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i - j \<longrightarrow> \<not>matches1 a k p (0 :: int) m) \<longrightarrow> (\<forall>(o1 :: bool). (if j < m then o1 = (if i < n then True else False) else o1 = False) \<longrightarrow> (if o1 = True then ((0 :: int) \<le> j \<and> j < int (length p)) \<and> ((0 :: int) \<le> i \<and> i < int (length a)) \<and> (if a ! nat i = p ! nat j then ((0 :: int) \<le> n - i \<and> n - (i + (1 :: int)) < n - i \<or> n - i = n - (i + (1 :: int)) \<and> (0 :: int) \<le> j \<and> j + (1 :: int) < j) \<and> (((0 :: int) \<le> j + (1 :: int) \<and> j + (1 :: int) \<le> m) \<and> j + (1 :: int) \<le> i + (1 :: int) \<and> i + (1 :: int) \<le> n) \<and> matches1 a (i + (1 :: int) - (j + (1 :: int))) p (0 :: int) (j + (1 :: int)) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i + (1 :: int) - (j + (1 :: int)) \<longrightarrow> \<not>matches1 a k p (0 :: int) m) else if j = (0 :: int) then ((0 :: int) \<le> n - i \<and> n - (i + (1 :: int)) < n - i \<or> n - i = n - (i + (1 :: int)) \<and> (0 :: int) \<le> j \<and> j < j) \<and> (((0 :: int) \<le> j \<and> j \<le> m) \<and> j \<le> i + (1 :: int) \<and> i + (1 :: int) \<le> n) \<and> matches1 a (i + (1 :: int) - j) p (0 :: int) j \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i + (1 :: int) - j \<longrightarrow> \<not>matches1 a k p (0 :: int) m) else ((0 :: int) \<le> j \<and> j < int (length next)) \<and> ((0 :: int) \<le> n - i \<and> n - i < n - i \<or> (0 :: int) \<le> j \<and> next ! nat j < j) \<and> (((0 :: int) \<le> next ! nat j \<and> next ! nat j \<le> m) \<and> next ! nat j \<le> i \<and> i \<le> n) \<and> matches1 a (i - next ! nat j) p (0 :: int) (next ! nat j) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < i - next ! nat j \<longrightarrow> \<not>matches1 a k p (0 :: int) m)) else \<forall>(result :: int). (if j = m then result = i - m else result = i) \<longrightarrow> first_occur p a result))))"
  sorry
end
