theory knuth_prime_numbers_PrimeNumbers_prime_numbersqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref"
begin
definition no_prime_in :: "int \<Rightarrow> int \<Rightarrow> _"
  where "no_prime_in l u \<longleftrightarrow> (\<forall>(x :: int). l < x \<and> x < u \<longrightarrow> \<not>prime x)" for l u
definition first_primes :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> _"
  where "first_primes p u \<longleftrightarrow> p (0 :: int) = (2 :: int) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < j \<and> j < u \<longrightarrow> p i < p j) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < u \<longrightarrow> prime (p i)) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < u - (1 :: int) \<longrightarrow> no_prime_in (p i) (p (i + (1 :: int))))" for p u
axiomatization where Bertrand_postulate:   "\<not>no_prime_in p ((2 :: int) * p)"
 if "prime p"
  for p :: "int"
theorem prime_numbers'vc:
  fixes m :: "int"
  assumes fact0: "(2 :: int) \<le> m"
  shows "(0 :: int) \<le> m"
  and "\<forall>(p :: int list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < m \<longrightarrow> p ! nat i = (0 :: int)) \<and> int (length p) = m \<longrightarrow> ((0 :: int) \<le> (0 :: int) \<and> (0 :: int) < int (length p)) \<and> (length (p[nat (0 :: int) := 2 :: int]) = length p \<longrightarrow> nth (p[nat (0 :: int) := 2 :: int]) o nat = (nth p o nat)(0 :: int := 2 :: int) \<longrightarrow> ((0 :: int) \<le> (1 :: int) \<and> (1 :: int) < int (length (p[nat (0 :: int) := 2 :: int]))) \<and> (length (p[nat (1 :: int) := 3 :: int, nat (0 :: int) := 2 :: int]) = length (p[nat (0 :: int) := 2 :: int]) \<longrightarrow> nth (p[nat (1 :: int) := 3 :: int, nat (0 :: int) := 2 :: int]) o nat = (nth (p[nat (0 :: int) := 2 :: int]) o nat)(1 :: int := 3 :: int) \<longrightarrow> (let o1 :: int = m - (1 :: int) in \<not>(2 :: int) \<le> o1 + (1 :: int) \<and> (o1 + (1 :: int) < (2 :: int) \<longrightarrow> int (length (p[nat (1 :: int) := 3 :: int, nat (0 :: int) := 2 :: int])) = m \<and> first_primes (nth (p[nat (1 :: int) := 3 :: int, nat (0 :: int) := 2 :: int]) o nat) m))))"
  sorry
end
