theory linear_probing_LinearProbing_deleteqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf" "Why3STD.map_Const"
begin
typedecl  key
typedecl  keym
consts keym1 :: "key \<Rightarrow> keym"
consts eq :: "key \<Rightarrow> key \<Rightarrow> bool"
axiomatization where eq'spec:   "eq x y \<longleftrightarrow> keym1 x = keym1 y"
  for x :: "key"
  and y :: "key"
definition neq :: "key \<Rightarrow> key \<Rightarrow> _"
  where "neq x y \<longleftrightarrow> \<not>eq x y" for x y
axiomatization where neq'spec:   "neq x y \<longleftrightarrow> \<not>keym1 x = keym1 y"
  for x :: "key"
  and y :: "key"
consts hash :: "key \<Rightarrow> int"
axiomatization where hash_nonneg:   "(0 :: int) \<le> hash k"
  for k :: "key"
axiomatization where hash_eq:   "hash x = hash y"
 if "eq x y"
  for x :: "key"
  and y :: "key"
consts dummy :: "key"
consts bucket :: "key \<Rightarrow> int \<Rightarrow> int"
axiomatization where bucket'def:   "bucket k n = hash k cmod n"
 if "(0 :: int) < n"
  for n :: "int"
  and k :: "key"
axiomatization where bucket'spec'0:   "(0 :: int) \<le> bucket k n"
 if "(0 :: int) < n"
  for n :: "int"
  and k :: "key"
axiomatization where bucket'spec'1:   "bucket k n < n"
 if "(0 :: int) < n"
  for n :: "int"
  and k :: "key"
definition between :: "int \<Rightarrow> int \<Rightarrow> int \<Rightarrow> _"
  where "between l j r \<longleftrightarrow> l \<le> j \<and> j < r \<or> r < l \<and> l \<le> j \<or> j < r \<and> r < l" for l j r
consts fc :: "key list \<Rightarrow> int \<Rightarrow> bool"
axiomatization where fc'def:   "fc a i = True \<longleftrightarrow> eq (a ! nat i) dummy"
  for a :: "key list"
  and i :: "int"
definition numof :: "key list \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
  where "numof a l u = int_NumOf.numof (fc a) l u" for a l u
definition valid :: "key list \<Rightarrow> (keym \<Rightarrow> bool) \<Rightarrow> (keym \<Rightarrow> int) \<Rightarrow> _"
  where "valid data view loc \<longleftrightarrow> \<not>view (keym1 dummy) = True \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length data) \<longrightarrow> (let x :: key = data ! nat i in neq x dummy \<longrightarrow> view (keym1 x) = True \<and> loc (keym1 x) = i)) \<and> (let n :: int = int (length data) in \<forall>(x :: key). view (keym1 x) = True \<longrightarrow> (let i :: int = loc (keym1 x) in ((0 :: int) \<le> i \<and> i < n) \<and> eq (data ! nat i) x \<and> (\<forall>(j :: int). (0 :: int) \<le> j \<and> j < n \<longrightarrow> between (bucket x n) j i \<longrightarrow> neq (data ! nat j) x \<and> neq (data ! nat j) dummy)))" for data view loc
typedecl  t
consts size :: "t \<Rightarrow> int"
consts data :: "t \<Rightarrow> key list"
consts view :: "t \<Rightarrow> keym \<Rightarrow> bool"
consts loc :: "t \<Rightarrow> keym \<Rightarrow> int"
axiomatization where t'invariant'0:   "(0 :: int) \<le> size self"
  for self :: "t"
axiomatization where t'invariant'1:   "size self < int (length (data self))"
  for self :: "t"
axiomatization where t'invariant'2:   "size self + numof (data self) (0 :: int) (int (length (data self))) = int (length (data self))"
  for self :: "t"
axiomatization where t'invariant'3:   "valid (data self) (view self) (loc self)"
  for self :: "t"
definition t'eq :: "t \<Rightarrow> t \<Rightarrow> _"
  where "t'eq a b \<longleftrightarrow> size a = size b \<and> data a = data b \<and> view a = view b \<and> loc a = loc b" for a b
axiomatization where t'inj:   "a = b"
 if "t'eq a b"
  for a :: "t"
  and b :: "t"
definition "next" :: "int \<Rightarrow> int \<Rightarrow> int"
  where "next n i = (let i1 :: int = i + (1 :: int) in if i1 = n then 0 :: int else i1)" for n i
theorem delete'vc:
  fixes f0 :: "int"
  fixes a :: "key list"
  fixes j :: "int"
  fixes i :: "int"
  fixes view1 :: "keym \<Rightarrow> bool"
  fixes loc1 :: "keym \<Rightarrow> int"
  assumes fact0: "(0 :: int) \<le> f0"
  assumes fact1: "f0 < int (length a)"
  assumes fact2: "(0 :: int) \<le> j"
  assumes fact3: "j < int (length a)"
  assumes fact4: "(0 :: int) \<le> i"
  assumes fact5: "i < int (length a)"
  assumes fact6: "\<not>j = f0"
  assumes fact7: "eq (a ! nat j) dummy"
  assumes fact8: "eq (a ! nat f0) dummy"
  assumes fact9: "between j i f0"
  assumes fact10: "\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length a) \<longrightarrow> between i k f0 \<longrightarrow> \<not>k = i \<longrightarrow> neq (a ! nat k) dummy"
  assumes fact11: "\<not>view1 (keym1 dummy) = True"
  assumes fact12: "\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length a) \<longrightarrow> (let x :: key = a ! nat k in neq x dummy \<longrightarrow> view1 (keym1 x) = True \<and> loc1 (keym1 x) = k)"
  assumes fact13: "let n :: int = int (length a) in \<forall>(x :: key). view1 (keym1 x) = True \<longrightarrow> (let k :: int = loc1 (keym1 x) in ((0 :: int) \<le> k \<and> k < n) \<and> eq (a ! nat k) x \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < n \<longrightarrow> between (bucket x n) l k \<longrightarrow> neq (a ! nat l) x \<and> (neq (a ! nat l) dummy \<or> l = j \<and> between j i k)))"
  shows "let n :: int = int (length a); i1 :: int = next n i in ((0 :: int) \<le> i1 \<and> i1 < int (length a)) \<and> (let xi :: key = a ! nat i1; o1 :: key = dummy in (neq xi o1 \<longleftrightarrow> \<not>keym1 xi = keym1 o1) \<longrightarrow> (if neq xi o1 then (0 :: int) < n \<and> (let r :: int = bucket xi n in (0 :: int) \<le> r \<and> r < n \<longrightarrow> (\<forall>(o2 :: bool). (if j < r then o2 = (if r \<le> i1 then True else False) else o2 = False) \<longrightarrow> (\<forall>(o3 :: bool). (if o2 = True then o3 = True else \<exists>(o4 :: bool). (if i1 < j then o4 = (if j < r then True else False) else o4 = False) \<and> (if o4 = True then o3 = True else if r \<le> i1 then o3 = (if i1 < j then True else False) else o3 = False)) \<longrightarrow> (if o3 = True then ((0 :: int) \<le> (if f0 \<le> i then int (length a) - i + f0 else f0 - i) \<and> (if f0 \<le> i1 then int (length a) - i1 + f0 else f0 - i1) < (if f0 \<le> i then int (length a) - i + f0 else f0 - i)) \<and> ((0 :: int) \<le> f0 \<and> f0 < int (length a)) \<and> ((0 :: int) \<le> j \<and> j < int (length a)) \<and> ((0 :: int) \<le> i1 \<and> i1 < int (length a)) \<and> \<not>j = f0 \<and> eq (a ! nat j) dummy \<and> eq (a ! nat f0) dummy \<and> between j i1 f0 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length a) \<longrightarrow> between i1 k f0 \<longrightarrow> \<not>k = i1 \<longrightarrow> neq (a ! nat k) dummy) \<and> \<not>view1 (keym1 dummy) = True \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length a) \<longrightarrow> (let x :: key = a ! nat k in neq x dummy \<longrightarrow> view1 (keym1 x) = True \<and> loc1 (keym1 x) = k)) \<and> (let n1 :: int = int (length a) in \<forall>(x :: key). view1 (keym1 x) = True \<longrightarrow> (let k :: int = loc1 (keym1 x) in ((0 :: int) \<le> k \<and> k < n1) \<and> eq (a ! nat k) x \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < n1 \<longrightarrow> between (bucket x n1) l k \<longrightarrow> neq (a ! nat l) x \<and> (neq (a ! nat l) dummy \<or> l = j \<and> between j i1 k)))) else \<forall>(a1 :: key list). length a1 = length a \<and> (\<forall>(i2 :: int). (0 :: int) \<le> i2 \<and> i2 < int (length a1) \<longrightarrow> a1 ! nat i2 = a ! nat i2) \<longrightarrow> ((0 :: int) \<le> j \<and> j < int (length a)) \<and> (length (a[nat j := xi]) = length a \<longrightarrow> nth (a[nat j := xi]) o nat = (nth a o nat)(j := xi) \<longrightarrow> (\<forall>(a2 :: key list). length a2 = length (a[nat j := xi]) \<and> (\<forall>(i2 :: int). (0 :: int) \<le> i2 \<and> i2 < int (length a2) \<longrightarrow> a2 ! nat i2 = a[nat j := xi] ! nat i2) \<longrightarrow> (let o4 :: key = dummy in ((0 :: int) \<le> i1 \<and> i1 < int (length (a[nat j := xi]))) \<and> (length (a[nat i1 := o4, nat j := xi]) = length (a[nat j := xi]) \<longrightarrow> nth (a[nat i1 := o4, nat j := xi]) o nat = (nth (a[nat j := xi]) o nat)(i1 := o4) \<longrightarrow> (((0 :: int) \<le> (if f0 \<le> i then int (length a) - i + f0 else f0 - i) \<and> (if f0 \<le> i1 then int (length (a[nat i1 := o4, nat j := xi])) - i1 + f0 else f0 - i1) < (if f0 \<le> i then int (length a) - i + f0 else f0 - i)) \<and> ((0 :: int) \<le> f0 \<and> f0 < int (length (a[nat i1 := o4, nat j := xi]))) \<and> ((0 :: int) \<le> i1 \<and> i1 < int (length (a[nat i1 := o4, nat j := xi]))) \<and> ((0 :: int) \<le> i1 \<and> i1 < int (length (a[nat i1 := o4, nat j := xi]))) \<and> \<not>i1 = f0 \<and> eq (a[nat i1 := o4, nat j := xi] ! nat i1) dummy \<and> eq (a[nat i1 := o4, nat j := xi] ! nat f0) dummy \<and> between i1 i1 f0 \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (a[nat i1 := o4, nat j := xi])) \<longrightarrow> between i1 k f0 \<longrightarrow> \<not>k = i1 \<longrightarrow> neq (a[nat i1 := o4, nat j := xi] ! nat k) dummy) \<and> \<not>view1 (keym1 dummy) = True \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < int (length (a[nat i1 := o4, nat j := xi])) \<longrightarrow> (let x :: key = a[nat i1 := o4, nat j := xi] ! nat k in neq x dummy \<longrightarrow> view1 (keym1 x) = True \<and> (loc1(keym1 xi := j)) (keym1 x) = k)) \<and> (let n1 :: int = int (length (a[nat i1 := o4, nat j := xi])) in \<forall>(x :: key). view1 (keym1 x) = True \<longrightarrow> (let k :: int = (loc1(keym1 xi := j)) (keym1 x) in ((0 :: int) \<le> k \<and> k < n1) \<and> eq (a[nat i1 := o4, nat j := xi] ! nat k) x \<and> (\<forall>(l :: int). (0 :: int) \<le> l \<and> l < n1 \<longrightarrow> between (bucket x n1) l k \<longrightarrow> neq (a[nat i1 := o4, nat j := xi] ! nat l) x \<and> (neq (a[nat i1 := o4, nat j := xi] ! nat l) dummy \<or> l = i1 \<and> between i1 i1 k))))) \<and> (\<forall>(loc2 :: keym \<Rightarrow> int) (a3 :: key list). length a3 = length (a[nat i1 := o4, nat j := xi]) \<longrightarrow> numof a3 (0 :: int) (int (length a3)) = numof (a[nat i1 := o4, nat j := xi]) (0 :: int) (int (length a3)) \<and> valid a3 view1 loc2 \<longrightarrow> numof a3 (0 :: int) (int (length a3)) = numof a (0 :: int) (int (length a3)) \<and> valid a3 view1 loc2))))))))) else valid a view1 loc1))"
  sorry
end
