theory linked_list_rev_Termination_list_reversalqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf"
begin
typedecl  loc
consts null :: "loc"
datatype  mem = mem'mk ("next": "loc \<Rightarrow> loc")
definition valid_cells :: "(int \<Rightarrow> loc) \<Rightarrow> int \<Rightarrow> _"
  where "valid_cells s n \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> \<not>s i = null) \<and> (\<forall>(i :: int) (j :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) \<le> j \<and> j < n \<longrightarrow> \<not>i = j \<longrightarrow> \<not>s i = s j)" for s n
definition inside_memory :: "(int \<Rightarrow> loc) \<Rightarrow> int \<Rightarrow> loc \<Rightarrow> _"
  where "inside_memory s n l \<longleftrightarrow> l = null \<or> (\<exists>(i :: int). ((0 :: int) \<le> i \<and> i < n) \<and> l = s i)" for s n l
definition finite_memory :: "mem \<Rightarrow> (int \<Rightarrow> loc) \<Rightarrow> int \<Rightarrow> _"
  where "finite_memory m s n \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> inside_memory s n (next m (s i)))" for m s n
consts fc :: "(int \<Rightarrow> loc) \<Rightarrow> (loc \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> bool"
axiomatization where fc'def:   "fc s idx i = True \<longleftrightarrow> (0 :: int) < idx (s i)"
  for s :: "int \<Rightarrow> loc"
  and idx :: "loc \<Rightarrow> int"
  and i :: "int"
definition seen :: "(int \<Rightarrow> loc) \<Rightarrow> (loc \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
  where "seen s idx lo hi = numof (fc s idx) lo hi" for s idx lo hi
consts o1 :: "loc \<Rightarrow> int"
axiomatization where o'def:   "o1 p = (if p = null then 0 :: int else -(1 :: int))"
  for p :: "loc"
theorem list_reversal'vc:
  fixes mem1 :: "loc \<Rightarrow> loc"
  shows "let mem2 :: mem = mem'mk mem1 in \<forall>(s :: int \<Rightarrow> loc) (n :: int) (l :: loc). (0 :: int) \<le> n \<and> valid_cells s n \<and> finite_memory mem2 s n \<and> inside_memory s n l \<longrightarrow> (let o2 :: loc \<Rightarrow> int = o1 in (inside_memory s n l \<and> inside_memory s n null \<and> finite_memory mem2 s n \<and> ((0 :: int) = seen s o2 (0 :: int) n \<and> (0 :: int) \<le> seen s o2 (0 :: int) n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> -(1 :: int) \<le> o2 (s i) \<and> o2 (s i) \<le> (0 :: int)) \<and> (\<forall>(p :: loc). o2 p = (0 :: int) \<longleftrightarrow> p = null) \<and> (if o2 l = -(1 :: int) then o2 null = (0 :: int) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < o2 (s i) \<longrightarrow> o2 (mem1 (s i)) = o2 (s i) - (1 :: int)) else \<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < o2 (s i) \<and> o2 (s i) \<le> o2 l \<longrightarrow> o2 (mem1 (s i)) = o2 (s i) - (1 :: int))) \<and> (\<forall>(idx :: loc \<Rightarrow> int) (r :: loc) (l1 :: loc) (mem3 :: loc \<Rightarrow> loc). inside_memory s n l1 \<and> inside_memory s n r \<and> finite_memory (mem'mk mem3) s n \<and> (0 :: int) \<le> seen s idx (0 :: int) n \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> -(1 :: int) \<le> idx (s i) \<and> idx (s i) \<le> seen s idx (0 :: int) n) \<and> (\<forall>(p :: loc). idx p = (0 :: int) \<longleftrightarrow> p = null) \<and> (if idx l1 = -(1 :: int) then idx r = seen s idx (0 :: int) n \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < idx (s i) \<longrightarrow> idx (mem3 (s i)) = idx (s i) - (1 :: int)) else \<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < idx (s i) \<and> idx (s i) \<le> idx l1 \<longrightarrow> idx (mem3 (s i)) = idx (s i) - (1 :: int)) \<longrightarrow> \<not>l1 = null \<longrightarrow> (if idx l1 = -(1 :: int) then (valid_cells s n \<and> inside_memory s n l1 \<and> \<not>l1 = null \<and> idx l1 = -(1 :: int) \<and> (0 :: int) \<le> seen s idx (0 :: int) n) \<and> (seen s (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (0 :: int) n = (1 :: int) + seen s idx (0 :: int) n \<longrightarrow> \<not>l1 = null \<and> \<not>l1 = null \<and> ((0 :: int) \<le> n - seen s idx (0 :: int) n \<and> n - (seen s idx (0 :: int) n + (1 :: int)) < n - seen s idx (0 :: int) n \<or> n - seen s idx (0 :: int) n = n - (seen s idx (0 :: int) n + (1 :: int)) \<and> (0 :: int) \<le> (1 :: int) + idx l1 \<and> (1 :: int) + (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (mem3 l1) < (1 :: int) + idx l1) \<and> inside_memory s n (mem3 l1) \<and> inside_memory s n l1 \<and> finite_memory (mem'mk (mem3(l1 := r))) s n \<and> (seen s idx (0 :: int) n + (1 :: int) = seen s (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (0 :: int) n \<and> (0 :: int) \<le> seen s (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (0 :: int) n) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> -(1 :: int) \<le> (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) \<and> (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) \<le> seen s idx (0 :: int) n + (1 :: int)) \<and> (\<forall>(p :: loc). (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) p = (0 :: int) \<longleftrightarrow> p = null) \<and> (if (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (mem3 l1) = -(1 :: int) then (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) l1 = seen s idx (0 :: int) n + (1 :: int) \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) \<longrightarrow> (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) ((mem3(l1 := r)) (s i)) = (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) - (1 :: int)) else \<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) \<and> (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) \<le> (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (mem3 l1) \<longrightarrow> (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) ((mem3(l1 := r)) (s i)) = (idx(l1 := seen s idx (0 :: int) n + (1 :: int))) (s i) - (1 :: int))) else \<not>l1 = null \<and> \<not>l1 = null \<and> ((0 :: int) \<le> n - seen s idx (0 :: int) n \<and> n - seen s idx (0 :: int) n < n - seen s idx (0 :: int) n \<or> (0 :: int) \<le> (1 :: int) + idx l1 \<and> (1 :: int) + idx (mem3 l1) < (1 :: int) + idx l1) \<and> inside_memory s n (mem3 l1) \<and> inside_memory s n l1 \<and> finite_memory (mem'mk (mem3(l1 := r))) s n \<and> (0 :: int) \<le> seen s idx (0 :: int) n \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> -(1 :: int) \<le> idx (s i) \<and> idx (s i) \<le> seen s idx (0 :: int) n) \<and> (\<forall>(p :: loc). idx p = (0 :: int) \<longleftrightarrow> p = null) \<and> (if idx (mem3 l1) = -(1 :: int) then idx l1 = seen s idx (0 :: int) n \<and> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < idx (s i) \<longrightarrow> idx ((mem3(l1 := r)) (s i)) = idx (s i) - (1 :: int)) else \<forall>(i :: int). (0 :: int) \<le> i \<and> i < n \<longrightarrow> (0 :: int) < idx (s i) \<and> idx (s i) \<le> idx (mem3 l1) \<longrightarrow> idx ((mem3(l1 := r)) (s i)) = idx (s i) - (1 :: int)))))"
  sorry
end
