From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.ieee_float.RoundingMode.
Open Scope Z_scope.
Axiom udouble : Type.
Axiom udouble_inhabited : Inhabited udouble.
Global Existing Instance udouble_inhabited.
Axiom udouble_countable : Countable udouble.
Global Existing Instance udouble_countable.
Axiom to_real : udouble -> R.
Axiom uround : mode -> R -> udouble.
Axiom uround_exact : forall  (m : mode) (x : udouble), uround m (to_real x) = x.
Axiom uzero : udouble.
Axiom to_real_uzero : to_real uzero = 0%R.
Axiom utwo : udouble.
Axiom to_real_utwo : to_real utwo = 2%R.
Definition uadd (x : udouble) (y : udouble) : udouble := uround RNE (Rplus (to_real x) (to_real y)).
Definition usub (x : udouble) (y : udouble) : udouble := uround RNE (Rminus (to_real x) (to_real y)).
Definition umul (x : udouble) (y : udouble) : udouble := uround RNE (Rmult (to_real x) (to_real y)).
Definition udiv (x : udouble) (y : udouble) : udouble := uround RNE (Rdiv (to_real x) (to_real y)).
Definition uminus (x : udouble) : udouble := uround RNE (Ropp (to_real x)).
Theorem mul_rounding'vc (x : udouble) (y : udouble) : Rle (Rabs (Rminus (to_real (umul x y)) (Rmult (to_real x) (to_real y)))) (Rplus (Rmult (Rabs (Rmult (to_real x) (to_real y))) (Rdiv (Rdiv 1%R 9007199254740992) (Rplus 1%R (Rdiv 1%R 9007199254740992)))) (Rdiv 1%R 404804506614621236704990693437834614099113299528284236713802716054860679135990693783920767402874248990374155728633623822779617474771586953734026799881477019843034848553132722728933815484186432682479535356945490137124014966849385397236206711298319112681620113024717539104666829230461005064372655017292012526615415482186989568)).
Admitted.
