theory max_matrix_Bitset
  imports "NTP4Verif.NTP4Verif"
begin
consts size :: "int"
typedecl  set
consts mem :: "int \<Rightarrow> set \<Rightarrow> bool"
consts remove :: "int \<Rightarrow> set \<Rightarrow> set"
axiomatization where remove'spec:   "mem y (remove x s) \<longleftrightarrow> \<not>y = x \<and> mem y s"
  for y :: "int"
  and x :: "int"
  and s :: "set"
consts below :: "int \<Rightarrow> set"
axiomatization where below'spec:   "mem x (below n) \<longleftrightarrow> (0 :: int) \<le> x \<and> x < n"
 if "(0 :: int) \<le> n"
 and "n \<le> size"
  for n :: "int"
  and x :: "int"
consts cardinal :: "set \<Rightarrow> int"
axiomatization where cardinal_empty:   "cardinal s = (0 :: int) \<longleftrightarrow> (\<forall>(x :: int). \<not>mem x s)"
  for s :: "set"
axiomatization where cardinal_remove:   "cardinal s = (1 :: int) + cardinal (remove x s)"
 if "mem x s"
  for x :: "int"
  and s :: "set"
axiomatization where cardinal_below:   "cardinal (below n) = (if (0 :: int) \<le> n then n else (0 :: int))"
 if "(0 :: int) \<le> n"
 and "n \<le> size"
  for n :: "int"
end
