theory max_matrix_MaxMatrixMemo_maximumqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.map_Const" "./max_matrix_Bitset" "./max_matrix_HashTable"
begin
typedecl 'a t
consts contents :: "'a t \<Rightarrow> int \<Rightarrow> 'a"
consts create :: "'a \<Rightarrow> 'a t"
axiomatization where create'spec:   "contents (create x) = (const :: 'a \<Rightarrow> int \<Rightarrow> 'a) x"
  for x :: "'a"
consts mixfix_lbrb :: "'a t \<Rightarrow> int \<Rightarrow> 'a"
axiomatization where mixfix_lbrb'spec:   "mixfix_lbrb m k = contents m k"
  for m :: "'a t"
  and k :: "int"
consts mixfix_lblsmnrb :: "'a t \<Rightarrow> int \<Rightarrow> 'a \<Rightarrow> 'a t"
axiomatization where mixfix_lblsmnrb'spec:   "contents (mixfix_lblsmnrb m k v) = (contents m)(k := v)"
  for m :: "'a t"
  and k :: "int"
  and v :: "'a"
consts n :: "int"
axiomatization where n'def'0:   "(0 :: int) \<le> n"
axiomatization where n'def'1:   "n \<le> max_matrix_Bitset.size"
consts m :: "int t t"
axiomatization where m'def:   "(0 :: int) \<le> mixfix_lbrb (mixfix_lbrb m i) j"
 if "(0 :: int) \<le> i"
 and "i < n"
 and "(0 :: int) \<le> j"
 and "j < n"
  for i :: "int"
  and j :: "int"
typedecl  mapii
definition solution :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> _"
  where "solution s i \<longleftrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> (0 :: int) \<le> s k \<and> s k < n) \<and> (\<forall>(k1 :: int) (k2 :: int). i \<le> k1 \<and> k1 < k2 \<and> k2 < n \<longrightarrow> \<not>s k1 = s k2)" for s i
definition f :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> int"
  where "f s i = mixfix_lbrb (mixfix_lbrb m i) (s i)" for s i
consts sum :: "(int \<Rightarrow> int) \<Rightarrow> int \<Rightarrow> int \<Rightarrow> int"
axiomatization where Sum_def_empty:   "sum c i j = (0 :: int)"
 if "j \<le> i"
  for j :: "int"
  and i :: "int"
  and c :: "int \<Rightarrow> int"
axiomatization where Sum_def_non_empty:   "sum c i j = f c i + sum c (i + (1 :: int)) j"
 if "i < j"
  for i :: "int"
  and j :: "int"
  and c :: "int \<Rightarrow> int"
axiomatization where Sum_right_extension:   "sum c i j = sum c i (j - (1 :: int)) + f c (j - (1 :: int))"
 if "i < j"
  for i :: "int"
  and j :: "int"
  and c :: "int \<Rightarrow> int"
axiomatization where Sum_transitivity:   "sum c i j = sum c i k + sum c k j"
 if "i \<le> k"
 and "k \<le> j"
  for i :: "int"
  and k :: "int"
  and j :: "int"
  and c :: "int \<Rightarrow> int"
axiomatization where Sum_eq:   "sum c1 i j = sum c2 i j"
 if "\<forall>(k :: int). i \<le> k \<and> k < j \<longrightarrow> f c1 k = f c2 k"
  for i :: "int"
  and j :: "int"
  and c1 :: "int \<Rightarrow> int"
  and c2 :: "int \<Rightarrow> int"
typedecl  key
typedecl  "value"
definition pre :: "int \<times> max_matrix_Bitset.set \<Rightarrow> _"
  where "pre k \<longleftrightarrow> (case k of (i, c) \<Rightarrow> ((0 :: int) \<le> i \<and> i \<le> n) \<and> cardinal c = n - i \<and> (\<forall>(k1 :: int). mem k1 c \<longrightarrow> (0 :: int) \<le> k1 \<and> k1 < n))" for k
definition post :: "int \<times> max_matrix_Bitset.set \<Rightarrow> int \<times> int t \<Rightarrow> _"
  where "post k v \<longleftrightarrow> (case k of (i, c) \<Rightarrow> (case v of (r, sol) \<Rightarrow> (0 :: int) \<le> r \<and> solution (contents sol) i \<and> (\<forall>(k1 :: int). i \<le> k1 \<and> k1 < n \<longrightarrow> mem (mixfix_lbrb sol k1) c) \<and> r = sum (contents sol) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k1 :: int). i \<le> k1 \<and> k1 < n \<longrightarrow> mem (s k1) c) \<longrightarrow> sum s i n \<le> r)))" for k v
typedecl  table
definition inv :: "(int \<times> max_matrix_Bitset.set, int \<times> int t) max_matrix_HashTable.t \<Rightarrow> _"
  where "inv t1 \<longleftrightarrow> (\<forall>(k :: int \<times> max_matrix_Bitset.set) (v :: int \<times> int t). max_matrix_HashTable.mixfix_lbrb t1 k = Some v \<longrightarrow> post k v)" for t1
theorem maximum'vc:
  fixes i :: "int"
  fixes c :: "max_matrix_Bitset.set"
  fixes table1 :: "(int \<times> max_matrix_Bitset.set, int \<times> int t) max_matrix_HashTable.t"
  assumes fact0: "pre (i, c)"
  assumes fact1: "inv table1"
  shows "if i = n then let o1 :: int t = create (0 :: int) in contents o1 = (const :: int \<Rightarrow> int \<Rightarrow> int) (0 :: int) \<longrightarrow> post (i, c) (0 :: int, o1) \<and> inv table1 else let o1 :: int t = create (0 :: int) in contents o1 = (const :: int \<Rightarrow> int \<Rightarrow> int) (0 :: int) \<longrightarrow> (let o2 :: int = n - (1 :: int) in ((0 :: int) \<le> o2 + (1 :: int) \<longrightarrow> (inv table1 \<and> ((\<forall>(k :: int). (0 :: int) \<le> k \<and> k < (0 :: int) \<longrightarrow> \<not>mem k c) \<or> (0 :: int) \<le> -(1 :: int) \<and> solution (contents o1) i \<and> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (mixfix_lbrb o1 k) c) \<and> -(1 :: int) = sum (contents o1) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (s k) c) \<longrightarrow> mem (s i) c \<longrightarrow> s i < (0 :: int) \<longrightarrow> sum s i n \<le> -(1 :: int)))) \<and> (\<forall>(sol :: int t) (r :: int) (table2 :: (int \<times> max_matrix_Bitset.set, int \<times> int t) max_matrix_HashTable.t). (\<forall>(j :: int). ((0 :: int) \<le> j \<and> j \<le> o2) \<and> inv table2 \<and> (r = -(1 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < j \<longrightarrow> \<not>mem k c) \<or> (0 :: int) \<le> r \<and> solution (contents sol) i \<and> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (mixfix_lbrb sol k) c) \<and> r = sum (contents sol) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (s k) c) \<longrightarrow> mem (s i) c \<longrightarrow> s i < j \<longrightarrow> sum s i n \<le> r)) \<longrightarrow> (if mem j c then let o3 :: max_matrix_Bitset.set = remove j c in (\<forall>(y :: int). mem y o3 \<longleftrightarrow> \<not>y = j \<and> mem y c) \<longrightarrow> (let o4 :: int = i + (1 :: int) in (((0 :: int) \<le> (2 :: int) * n - (2 :: int) * i \<and> (2 :: int) * n - (2 :: int) * o4 + (1 :: int) < (2 :: int) * n - (2 :: int) * i) \<and> pre (o4, o3) \<and> inv table2) \<and> (\<forall>(table3 :: (int \<times> max_matrix_Bitset.set, int \<times> int t) max_matrix_HashTable.t) (r' :: int) (sol' :: int t). post (o4, o3) (r', sol') \<and> inv table3 \<longrightarrow> (let o5 :: int t t = m; o6 :: int t = mixfix_lbrb o5 i in o6 = contents o5 i \<longrightarrow> (let o7 :: int = mixfix_lbrb o6 j in o7 = contents o6 j \<longrightarrow> (let x :: int = o7 + r' in if r < x then let o8 :: int t = mixfix_lblsmnrb sol' i j in contents o8 = (contents sol')(i := j) \<longrightarrow> inv table3 \<and> (x = -(1 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < j + (1 :: int) \<longrightarrow> \<not>mem k c) \<or> (0 :: int) \<le> x \<and> solution (contents o8) i \<and> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (mixfix_lbrb o8 k) c) \<and> x = sum (contents o8) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (s k) c) \<longrightarrow> mem (s i) c \<longrightarrow> s i < j + (1 :: int) \<longrightarrow> sum s i n \<le> x)) else inv table3 \<and> (r = -(1 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < j + (1 :: int) \<longrightarrow> \<not>mem k c) \<or> (0 :: int) \<le> r \<and> solution (contents sol) i \<and> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (mixfix_lbrb sol k) c) \<and> r = sum (contents sol) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (s k) c) \<longrightarrow> mem (s i) c \<longrightarrow> s i < j + (1 :: int) \<longrightarrow> sum s i n \<le> r))))))) else inv table2 \<and> (r = -(1 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < j + (1 :: int) \<longrightarrow> \<not>mem k c) \<or> (0 :: int) \<le> r \<and> solution (contents sol) i \<and> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (mixfix_lbrb sol k) c) \<and> r = sum (contents sol) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (s k) c) \<longrightarrow> mem (s i) c \<longrightarrow> s i < j + (1 :: int) \<longrightarrow> sum s i n \<le> r)))) \<and> (inv table2 \<and> (r = -(1 :: int) \<and> (\<forall>(k :: int). (0 :: int) \<le> k \<and> k < o2 + (1 :: int) \<longrightarrow> \<not>mem k c) \<or> (0 :: int) \<le> r \<and> solution (contents sol) i \<and> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (mixfix_lbrb sol k) c) \<and> r = sum (contents sol) i n \<and> (\<forall>(s :: int \<Rightarrow> int). solution s i \<longrightarrow> (\<forall>(k :: int). i \<le> k \<and> k < n \<longrightarrow> mem (s k) c) \<longrightarrow> mem (s i) c \<longrightarrow> s i < o2 + (1 :: int) \<longrightarrow> sum s i n \<le> r)) \<longrightarrow> post (i, c) (r, sol) \<and> inv table2))) \<and> (o2 + (1 :: int) < (0 :: int) \<longrightarrow> post (i, c) (-(1 :: int), o1) \<and> inv table1))"
  sorry
end
