From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.map.Const.
Require Import Why3.map.MapEq.
Require Import Why3.mach.int.Unsigned.
Require Import Why3.mach.c.C.
Require Import multiprecision.types.Config.
Require Import multiprecision.types.Types.
Require Import multiprecision.types.Int32Eq.
Require Import multiprecision.types.UInt64Eq.
Require Import multiprecision.lemmas.Lemmas.
Require Import multiprecision.compare.Compare.
Require Import multiprecision.util.Util.
Require Import multiprecision.ptralias.Alias.
Require Import multiprecision.util.UtilOld.
Require Import multiprecision.add.Add.
Require Import multiprecision.add.AddOld.
Require Import multiprecision.sub.SubOld.
Require Import multiprecision.logical.LogicalUtil.
Require Import multiprecision.logical.LogicalOld.
Require Import multiprecision.mul.Mul.
Open Scope Z_scope.
Definition reciprocal (v : bv 64%N) (d : bv 64%N) := bv_unsigned v = ZEuclid.div ((18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) - 1%Z) (bv_unsigned d) - (18446744073709551615%Z + 1%Z).
Definition reciprocal_3by2 (v : bv 64%N) (dh : bv 64%N) (dl : bv 64%N) := bv_unsigned v = ZEuclid.div ((18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) - 1%Z) (bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh) - (18446744073709551615%Z + 1%Z).
Definition normalized (x : ptr (bv 64%N)) (sz : bv 32%N) := valid x (bv_signed sz) ∧ ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned (pelts x (offset x + bv_signed sz - 1%Z)).
Theorem div_sb_qr'vc (sy : bv 32%N) (sx : bv 32%N) (x : ptr (bv 64%N)) (y : ptr (bv 64%N)) (q : ptr (bv 64%N)) (fact0 : 3%Z ≤ bv_signed sy) (fact1 : bv_signed sy ≤ bv_signed sx) (fact2 : valid x (bv_signed sx)) (fact3 : valid y (bv_signed sy)) (fact4 : valid q (bv_signed sx - bv_signed sy)) (fact5 : writable q = true) (fact6 : writable x = true) (fact7 : normalized y sy) : int'32_in_bounds (bv_signed sx - 2%Z) ∧ (∀(o1 : bv 32%N), bv_signed o1 = bv_signed sx - 2%Z -> (min x ≤ offset x + bv_signed o1 ∧ offset x + bv_signed o1 ≤ C.max x) ∧ (∀(o2 : ptr (bv 64%N)), offset o2 = offset x + bv_signed o1 ∧ plength o2 = plength x ∧ pelts o2 = pelts x ∧ data o2 = data x ∧ min o2 = min x ∧ C.max o2 = C.max x ∧ zone1 o2 = zone1 x ∧ writable o2 = writable x -> int'32_in_bounds (bv_signed sx - bv_signed sy) ∧ (∀(o3 : bv 32%N), bv_signed o3 = bv_signed sx - bv_signed sy -> (min q ≤ offset q + bv_signed o3 ∧ offset q + bv_signed o3 ≤ C.max q) ∧ (∀(o4 : ptr (bv 64%N)), offset o4 = offset q + bv_signed o3 ∧ plength o4 = plength q ∧ pelts o4 = pelts q ∧ data o4 = data q ∧ min o4 = min q ∧ C.max o4 = C.max q ∧ zone1 o4 = zone1 q ∧ writable o4 = writable q -> int'32_in_bounds (bv_signed sy - 1%Z) ∧ (∀(o5 : bv 32%N), bv_signed o5 = bv_signed sy - 1%Z -> (min y ≤ offset y + bv_signed o5 ∧ offset y + bv_signed o5 < C.max y) ∧ (let dh : bv 64%N := pelts y (offset y + bv_signed o5) in int'32_in_bounds (bv_signed sy - 2%Z) ∧ (∀(o6 : bv 32%N), bv_signed o6 = bv_signed sy - 2%Z -> (min y ≤ offset y + bv_signed o6 ∧ offset y + bv_signed o6 < C.max y) ∧ (let dl : bv 64%N := pelts y (offset y + bv_signed o6) in ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned dh ∧ (∀(v : bv 64%N), reciprocal_3by2 v dh dl -> int'32_in_bounds (bv_signed sx - bv_signed sy) ∧ (∀(o7 : bv 32%N), bv_signed o7 = bv_signed sx - bv_signed sy -> int'32_in_bounds (2%Z - bv_signed sy) ∧ (∀(mdn : bv 32%N), bv_signed mdn = 2%Z - bv_signed sy -> (min o2 ≤ offset o2 + bv_signed mdn ∧ offset o2 + bv_signed mdn ≤ C.max o2) ∧ (∀(xd : ptr (bv 64%N)), offset xd = offset o2 + bv_signed mdn ∧ plength xd = plength o2 ∧ pelts xd = pelts o2 ∧ data xd = data o2 ∧ min xd = min o2 ∧ C.max xd = C.max o2 ∧ zone1 xd = zone1 o2 ∧ writable xd = writable o2 -> (let vy : Z := value y (bv_signed sy) in (valid xd (bv_signed sy) ∧ valid y (bv_signed sy)) ∧ (∀(r : bv 32%N), bv_signed r = compare_int (value xd (bv_signed sy)) (value y (bv_signed sy)) -> (∀(qh : bv 64%N), (if decide (0%Z ≤ bv_signed r) then qh = (1%bv : bv 64%N) else qh = (0%bv : bv 64%N)) -> (∀(o8 : bool), (bv_unsigned qh = bv_unsigned (0%bv : bv 64%N) -> o8 = true) ∧ (o8 = true -> qh = (0%bv : bv 64%N)) -> ¬ o8 = true -> 0%Z ≤ bv_signed sy ∧ valid xd (bv_signed sy) ∧ valid y (bv_signed sy) ∧ writable xd = true) ∧ (∀(x1 : ptr (bv 64%N)) (xp : ptr (bv 64%N)), (∃(o8 : bool), ((bv_unsigned qh = bv_unsigned (0%bv : bv 64%N) -> o8 = true) ∧ (o8 = true -> qh = (0%bv : bv 64%N))) ∧ (if decide (¬ o8 = true) then ∃(xd1 : ptr (bv 64%N)), ((data xd1 = data x1 ∧ length (data x1) = length (data xd) ∧ offset xd1 = offset xd ∧ min xd1 = min xd ∧ C.max xd1 = C.max xd ∧ writable xd1 = writable xd ∧ zone1 xd1 = zone1 xd) ∧ (data xp = data x1 ∧ length (data x1) = length (data o2) ∧ offset xp = offset o2 ∧ min xp = min o2 ∧ C.max xp = C.max o2 ∧ writable xp = writable o2 ∧ zone1 xp = zone1 o2) ∧ length (data x1) = length (data x) ∧ offset x1 = offset x ∧ min x1 = min x ∧ C.max x1 = C.max x ∧ writable x1 = writable x ∧ zone1 x1 = zone1 x) ∧ (∃(b : bv 64%N), value xd1 (bv_signed sy) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) * bv_unsigned b = value xd (bv_signed sy) - value y (bv_signed sy) ∧ (0%Z ≤ bv_unsigned b ∧ bv_unsigned b ≤ 1%Z) ∧ (∀(j : Z), j < offset xd1 ∨ offset xd1 + bv_signed sy ≤ j -> pelts xd1 j = pelts xd j)) else x1 = x ∧ xp = o2)) -> (min xp ≤ offset xp + 1%Z ∧ offset xp + 1%Z < C.max xp) ∧ (min xp ≤ offset xp + 1%Z ∧ offset xp + 1%Z < C.max xp) ∧ ((0%Z ≤ bv_signed o7 ∧ bv_signed o7 ≤ bv_signed sx - bv_signed sy) ∧ offset o4 = offset q + bv_signed o7 ∧ offset xp = offset x1 + bv_signed sy + bv_signed o7 - 2%Z ∧ plength o4 = plength q ∧ min o4 = min q ∧ C.max o4 = C.max q ∧ plength xp = plength x1 ∧ min xp = min x1 ∧ C.max xp = C.max x1 ∧ pelts o4 = pelts q ∧ pelts xp = pelts x1 ∧ (writable o4 = true ∧ writable xp = true) ∧ value x (bv_signed sx) = (value o4 (bv_signed sx - bv_signed sy - bv_signed o7) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - bv_signed sy - bv_signed o7)) * vy * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o7) + value x1 (bv_signed sy + bv_signed o7 - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy + bv_signed o7 - 1%Z) * bv_unsigned (pelts xp (offset xp + 1%Z)) ∧ value_sub (pelts x1) (offset xp + bv_signed mdn) (offset xp + bv_signed mdn + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned (pelts xp (offset xp + 1%Z)) < vy ∧ bv_unsigned (pelts x1 (offset xp)) + (18446744073709551615%Z + 1%Z) * bv_unsigned (pelts xp (offset xp + 1%Z)) ≤ bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh) ∧ (∀(x11 : bv 64%N) (i : bv 32%N) (qp : ptr (bv 64%N)) (xp1 : ptr (bv 64%N)) (x2 : ptr (bv 64%N)) (q1 : ptr (bv 64%N)), length (data x2) = length (data x1) ∧ offset x2 = offset x1 ∧ min x2 = min x1 ∧ C.max x2 = C.max x1 ∧ writable x2 = writable x1 ∧ zone1 x2 = zone1 x1 -> length (data q1) = length (data q) ∧ offset q1 = offset q ∧ min q1 = min q ∧ C.max q1 = C.max q ∧ writable q1 = writable q ∧ zone1 q1 = zone1 q -> (0%Z ≤ bv_signed i ∧ bv_signed i ≤ bv_signed sx - bv_signed sy) ∧ offset qp = offset q1 + bv_signed i ∧ offset xp1 = offset x2 + bv_signed sy + bv_signed i - 2%Z ∧ plength qp = plength q1 ∧ min qp = min q1 ∧ C.max qp = C.max q1 ∧ plength xp1 = plength x2 ∧ min xp1 = min x2 ∧ C.max xp1 = C.max x2 ∧ pelts qp = pelts q1 ∧ pelts xp1 = pelts x2 ∧ (writable qp = true ∧ writable xp1 = true) ∧ value x (bv_signed sx) = (value qp (bv_signed sx - bv_signed sy - bv_signed i) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - bv_signed sy - bv_signed i)) * vy * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed i) + value x2 (bv_signed sy + bv_signed i - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy + bv_signed i - 1%Z) * bv_unsigned x11 ∧ value_sub (pelts x2) (offset xp1 + bv_signed mdn) (offset xp1 + bv_signed mdn + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned x11 < vy ∧ bv_unsigned (pelts x2 (offset xp1)) + (18446744073709551615%Z + 1%Z) * bv_unsigned x11 ≤ bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh -> (if decide (0%Z < bv_signed i) then int'32_in_bounds (bv_signed i - 1%Z) ∧ (∀(o8 : bv 32%N), bv_signed o8 = bv_signed i - 1%Z -> (min xp1 ≤ offset xp1 + - 1%Z ∧ offset xp1 + - 1%Z ≤ C.max xp1) ∧ (∀(o9 : ptr (bv 64%N)), offset o9 = offset xp1 + - 1%Z ∧ plength o9 = plength xp1 ∧ pelts o9 = pelts xp1 ∧ data o9 = data xp1 ∧ min o9 = min xp1 ∧ C.max o9 = C.max xp1 ∧ zone1 o9 = zone1 xp1 ∧ writable o9 = writable xp1 -> (min o9 ≤ offset o9 + bv_signed mdn ∧ offset o9 + bv_signed mdn ≤ C.max o9) ∧ (∀(xd1 : ptr (bv 64%N)), offset xd1 = offset o9 + bv_signed mdn ∧ plength xd1 = plength o9 ∧ pelts xd1 = pelts o9 ∧ data xd1 = data o9 ∧ min xd1 = min o9 ∧ C.max xd1 = C.max o9 ∧ zone1 xd1 = zone1 o9 ∧ writable xd1 = writable o9 -> (min o9 ≤ offset o9 + 1%Z ∧ offset o9 + 1%Z < C.max o9) ∧ (let nx0 : bv 64%N := pelts o9 (offset o9 + 1%Z) in ∀(o10 : bool), (bv_unsigned x11 = bv_unsigned dh -> o10 = true) ∧ (o10 = true -> x11 = dh) -> (∀(o11 : bool), (if decide (o10 = true) then (bv_unsigned nx0 = bv_unsigned dl -> o11 = true) ∧ (o11 = true -> nx0 = dl) else o11 = false) -> (if decide (o11 = true) then value_sub (pelts xd1) (offset xd1 + 1%Z) (offset xd1 + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 2%Z) * bv_unsigned dl + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned dh < vy ∧ (value_sub (pelts xd1) (offset xd1 + 1%Z) (offset xd1 + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 2%Z) * bv_unsigned dl + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned dh < vy -> (let o12 : list (bv 64%N) := data x2 in ∀(xc : list (bv 64%N)), length xc = length o12 ∧ (∀(i1 : Z), 0%Z ≤ i1 ∧ i1 < Z.of_nat (length xc) -> nth (Z.to_nat i1) xc inhabitant = nth (Z.to_nat i1) o12 inhabitant) -> (valid y (bv_signed sy) ∧ valid xd1 (bv_signed sy) ∧ writable xd1 = true) ∧ (∀(xd2 : ptr (bv 64%N)) (xp2 : ptr (bv 64%N)) (x3 : ptr (bv 64%N)), data xd2 = data x3 ∧ length (data x3) = length (data xd1) ∧ offset xd2 = offset xd1 ∧ min xd2 = min xd1 ∧ C.max xd2 = C.max xd1 ∧ writable xd2 = writable xd1 ∧ zone1 xd2 = zone1 xd1 -> data xp2 = data x3 ∧ length (data x3) = length (data o9) ∧ offset xp2 = offset o9 ∧ min xp2 = min o9 ∧ C.max xp2 = C.max o9 ∧ writable xp2 = writable o9 ∧ zone1 xp2 = zone1 o9 -> length (data x3) = length (data x2) ∧ offset x3 = offset x2 ∧ min x3 = min x2 ∧ C.max x3 = C.max x2 ∧ writable x3 = writable x2 ∧ zone1 x3 = zone1 x2 -> (∀(b : bv 64%N), value xd2 (bv_signed sy) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) * bv_unsigned b = value xd1 (bv_signed sy) - value y (bv_signed sy) * bv_unsigned uint'64_max ∧ (∀(j : Z), j < offset xd2 ∨ offset xd2 + bv_signed sy ≤ j -> pelts xd2 j = pelts xd1 j) -> value x3 (bv_signed o8) = value x2 (bv_signed o8) ∧ (value x3 (bv_signed o8) = value x2 (bv_signed o8) -> (let o13 : Z := offset x3 + (bv_signed sy + bv_signed o8 - 1%Z) in let o14 : Z := offset xd2 in let o15 : Z := offset x3 in let o16 : Z -> bv 64%N := pelts x3 in (o15 ≤ o14 ∧ o14 ≤ o13) ∧ (value_sub o16 o15 o13 = value_sub o16 o15 o14 + value_sub o16 o14 o13 * Z.pow (18446744073709551615%Z + 1%Z) (o14 - o15) -> (min xp2 ≤ offset xp2 + 1%Z ∧ offset xp2 + 1%Z < C.max xp2) ∧ (min qp ≤ offset qp + - 1%Z ∧ offset qp + - 1%Z ≤ C.max qp) ∧ (∀(o17 : ptr (bv 64%N)), offset o17 = offset qp + - 1%Z ∧ plength o17 = plength qp ∧ pelts o17 = pelts qp ∧ data o17 = data qp ∧ min o17 = min qp ∧ C.max o17 = C.max qp ∧ zone1 o17 = zone1 qp ∧ writable o17 = writable qp -> (let o18 : Z := offset o17 + bv_signed sx - bv_signed sy - bv_signed o8 in let o19 : Z := offset o17 + 1%Z in let o20 : Z := offset o17 in let o21 : Z -> bv 64%N := pelts q1 in (o19 ≤ o18 ∧ (o20 < o19 ∨ o18 ≤ o20)) ∧ (value_sub o21 o19 o18 = value_sub (fun_updt o21 o20 uint'64_max) o19 o18 -> ((min o17 ≤ offset o17 ∧ offset o17 < C.max o17) ∧ writable o17 = true) ∧ (∀(qp1 : ptr (bv 64%N)) (q2 : ptr (bv 64%N)), data qp1 = data q2 ∧ length (data q2) = length (data o17) ∧ offset qp1 = offset o17 ∧ min qp1 = min o17 ∧ C.max qp1 = C.max o17 ∧ writable qp1 = writable o17 ∧ zone1 qp1 = zone1 o17 -> data qp1 = data q2 ∧ length (data q2) = length (data o17) ∧ offset qp1 = offset o17 ∧ min qp1 = min o17 ∧ C.max qp1 = C.max o17 ∧ writable qp1 = writable o17 ∧ zone1 qp1 = zone1 o17 -> length (data q2) = length (data q1) ∧ offset q2 = offset q1 ∧ min q2 = min q1 ∧ C.max q2 = C.max q1 ∧ writable q2 = writable q1 ∧ zone1 q2 = zone1 q1 -> pelts qp1 = fun_updt (pelts o17) (offset qp1) uint'64_max -> bv_signed o8 < bv_signed i ∧ (0%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed sx - bv_signed sy) ∧ offset qp1 = offset q2 + bv_signed o8 ∧ offset xp2 = offset x3 + bv_signed sy + bv_signed o8 - 2%Z ∧ plength qp1 = plength q2 ∧ min qp1 = min q2 ∧ C.max qp1 = C.max q2 ∧ plength xp2 = plength x3 ∧ min xp2 = min x3 ∧ C.max xp2 = C.max x3 ∧ pelts qp1 = pelts q2 ∧ pelts xp2 = pelts x3 ∧ (writable qp1 = true ∧ writable xp2 = true) ∧ value x (bv_signed sx) = (value qp1 (bv_signed sx - bv_signed sy - bv_signed o8) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - bv_signed sy - bv_signed o8)) * vy * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) + value x3 (bv_signed sy + bv_signed o8 - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy + bv_signed o8 - 1%Z) * bv_unsigned (pelts xp2 (offset xp2 + 1%Z)) ∧ value_sub (pelts x3) (offset xp2 + bv_signed mdn) (offset xp2 + bv_signed mdn + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned (pelts xp2 (offset xp2 + 1%Z)) < vy ∧ bv_unsigned (pelts x3 (offset xp2)) + (18446744073709551615%Z + 1%Z) * bv_unsigned (pelts xp2 (offset xp2 + 1%Z)) ≤ bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh))))))))))) else let vlx : Z := value xd1 (bv_signed sy - 2%Z) in (min o9 ≤ offset o9 ∧ offset o9 < C.max o9) ∧ (let xp0 : bv 64%N := pelts o9 (offset o9) in (min o9 ≤ offset o9 + 1%Z ∧ offset o9 + 1%Z < C.max o9) ∧ (let xp11 : bv 64%N := pelts o9 (offset o9 + 1%Z) in value xd1 (bv_signed sy) = vlx + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 2%Z) * (bv_unsigned xp0 + (18446744073709551615%Z + 1%Z) * bv_unsigned xp11) ∧ (value xd1 (bv_signed sy) = vlx + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 2%Z) * (bv_unsigned xp0 + (18446744073709551615%Z + 1%Z) * bv_unsigned xp11) -> (ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned dh ∧ reciprocal_3by2 v dh dl ∧ bv_unsigned xp11 + (18446744073709551615%Z + 1%Z) * bv_unsigned x11 < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh) ∧ (∀(qu : bv 64%N) (rl : bv 64%N) (rh : bv 64%N), bv_unsigned qu * bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned qu * bv_unsigned dh + bv_unsigned rl + (18446744073709551615%Z + 1%Z) * bv_unsigned rh = bv_unsigned xp0 + (18446744073709551615%Z + 1%Z) * bv_unsigned xp11 + (18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) * bv_unsigned x11 ∧ 0%Z ≤ bv_unsigned rl + (18446744073709551615%Z + 1%Z) * bv_unsigned rh ∧ bv_unsigned rl + (18446744073709551615%Z + 1%Z) * bv_unsigned rh < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh -> (let o12 : Z := offset x2 + bv_signed sy + bv_signed i - 1%Z in let o13 : Z := offset xd1 in let o14 : Z := offset x2 in let o15 : Z -> bv 64%N := pelts x2 in (o14 ≤ o13 ∧ o13 ≤ o12) ∧ (value_sub o15 o14 o12 = value_sub o15 o14 o13 + value_sub o15 o13 o12 * Z.pow (18446744073709551615%Z + 1%Z) (o13 - o14) -> (let o16 : list (bv 64%N) := data x2 in ∀(xc : list (bv 64%N)), length xc = length o16 ∧ (∀(i1 : Z), 0%Z ≤ i1 ∧ i1 < Z.of_nat (length xc) -> nth (Z.to_nat i1) xc inhabitant = nth (Z.to_nat i1) o16 inhabitant) -> int'32_in_bounds (bv_signed sy - 2%Z) ∧ (∀(o17 : bv 32%N), bv_signed o17 = bv_signed sy - 2%Z -> (valid y (bv_signed o17) ∧ valid xd1 (bv_signed o17) ∧ writable xd1 = true) ∧ (∀(xd2 : ptr (bv 64%N)) (xp2 : ptr (bv 64%N)) (x3 : ptr (bv 64%N)), data xd2 = data x3 ∧ length (data x3) = length (data xd1) ∧ offset xd2 = offset xd1 ∧ min xd2 = min xd1 ∧ C.max xd2 = C.max xd1 ∧ writable xd2 = writable xd1 ∧ zone1 xd2 = zone1 xd1 -> data xp2 = data x3 ∧ length (data x3) = length (data o9) ∧ offset xp2 = offset o9 ∧ min xp2 = min o9 ∧ C.max xp2 = C.max o9 ∧ writable xp2 = writable o9 ∧ zone1 xp2 = zone1 o9 -> length (data x3) = length (data x2) ∧ offset x3 = offset x2 ∧ min x3 = min x2 ∧ C.max x3 = C.max x2 ∧ writable x3 = writable x2 ∧ zone1 x3 = zone1 x2 -> (∀(cy : bv 64%N), value xd2 (bv_signed o17) - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o17) * bv_unsigned cy = value xd1 (bv_signed o17) - value y (bv_signed o17) * bv_unsigned qu ∧ (∀(j : Z), j < offset xd2 ∨ offset xd2 + bv_signed o17 ≤ j -> pelts xd2 j = pelts xd1 j) -> value x3 (bv_signed o8) = value x2 (bv_signed o8) ∧ (value x3 (bv_signed o8) = value x2 (bv_signed o8) -> (∀(cy1 : bv 64%N), (if decide (bv_unsigned rl < bv_unsigned cy) then cy1 = (1%bv : bv 64%N) else cy1 = (0%bv : bv 64%N)) -> (∀(o18 : bv 64%N), bv_unsigned o18 = ZEuclid.modulo (bv_unsigned rl - bv_unsigned cy) (18446744073709551615%Z + 1%Z) -> (∀(cy2 : bv 64%N), (if decide (bv_unsigned rh < bv_unsigned cy1) then cy2 = (1%bv : bv 64%N) else cy2 = (0%bv : bv 64%N)) -> (∀(o19 : bv 64%N), bv_unsigned o19 = ZEuclid.modulo (bv_unsigned rh - bv_unsigned cy1) (18446744073709551615%Z + 1%Z) -> (let o20 : Z := offset xd2 + bv_signed sy - 1%Z in let o21 : Z := offset xd2 in let o22 : Z := offset xp2 in let o23 : Z -> bv 64%N := pelts x3 in (o21 ≤ o22 ∧ o22 < o20) ∧ (value_sub (fun_updt o23 o22 o18) o21 o20 = value_sub o23 o21 o20 + Z.pow (18446744073709551615%Z + 1%Z) (o22 - o21) * (bv_unsigned o18 - bv_unsigned (o23 o22)) -> (let o24 : Z := offset x3 + bv_signed o8 in let o25 : Z := offset x3 in let o26 : Z := offset xp2 in let o27 : Z -> bv 64%N := pelts x3 in (o25 ≤ o24 ∧ (o26 < o25 ∨ o24 ≤ o26)) ∧ (value_sub o27 o25 o24 = value_sub (fun_updt o27 o26 o18) o25 o24 -> (let o28 : Z := offset xd2 + bv_signed sy - 2%Z in let o29 : Z := offset xd2 in let o30 : Z := offset xp2 in let o31 : Z -> bv 64%N := pelts x3 in (o29 ≤ o28 ∧ (o30 < o29 ∨ o28 ≤ o30)) ∧ (value_sub o31 o29 o28 = value_sub (fun_updt o31 o30 o18) o29 o28 -> ((min xp2 ≤ offset xp2 ∧ offset xp2 < C.max xp2) ∧ writable xp2 = true) ∧ (∀(xd3 : ptr (bv 64%N)) (xp3 : ptr (bv 64%N)) (x4 : ptr (bv 64%N)), data xp3 = data x4 ∧ length (data x4) = length (data xp2) ∧ offset xp3 = offset xp2 ∧ min xp3 = min xp2 ∧ C.max xp3 = C.max xp2 ∧ writable xp3 = writable xp2 ∧ zone1 xp3 = zone1 xp2 -> data xd3 = data x4 ∧ length (data x4) = length (data xd2) ∧ offset xd3 = offset xd2 ∧ min xd3 = min xd2 ∧ C.max xd3 = C.max xd2 ∧ writable xd3 = writable xd2 ∧ zone1 xd3 = zone1 xd2 -> data xp3 = data x4 ∧ length (data x4) = length (data xp2) ∧ offset xp3 = offset xp2 ∧ min xp3 = min xp2 ∧ C.max xp3 = C.max xp2 ∧ writable xp3 = writable xp2 ∧ zone1 xp3 = zone1 xp2 -> length (data x4) = length (data x3) ∧ offset x4 = offset x3 ∧ min x4 = min x3 ∧ C.max x4 = C.max x3 ∧ writable x4 = writable x3 ∧ zone1 x4 = zone1 x3 -> pelts xp3 = fun_updt (pelts xp2) (offset xp3) o18 -> value xd3 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) * bv_unsigned cy2 = value xd1 (bv_signed sy) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) * bv_unsigned x11 - bv_unsigned qu * vy ∧ (value xd3 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) * bv_unsigned cy2 = value xd1 (bv_signed sy) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) * bv_unsigned x11 - bv_unsigned qu * vy -> (∀(o32 : bool), (bv_unsigned cy2 = bv_unsigned (0%bv : bv 64%N) -> o32 = true) ∧ (o32 = true -> cy2 = (0%bv : bv 64%N)) -> (if decide (¬ o32 = true) then 0%Z < bv_unsigned qu ∧ (0%Z < bv_unsigned qu -> Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) - vy ≤ value xd3 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 ∧ (Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) - vy ≤ value xd3 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 -> (let o33 : list (bv 64%N) := data x4 in ∀(xc1 : list (bv 64%N)), length xc1 = length o33 ∧ (∀(i1 : Z), 0%Z ≤ i1 ∧ i1 < Z.of_nat (length xc1) -> nth (Z.to_nat i1) xc1 inhabitant = nth (Z.to_nat i1) o33 inhabitant) -> int'32_in_bounds (bv_signed sy - 1%Z) ∧ (∀(o34 : bv 32%N), bv_signed o34 = bv_signed sy - 1%Z -> (valid xd3 (bv_signed o34) ∧ valid y (bv_signed o34) ∧ writable xd3 = true) ∧ (∀(xd4 : ptr (bv 64%N)) (xp4 : ptr (bv 64%N)) (x5 : ptr (bv 64%N)), data xd4 = data x5 ∧ length (data x5) = length (data xd3) ∧ offset xd4 = offset xd3 ∧ min xd4 = min xd3 ∧ C.max xd4 = C.max xd3 ∧ writable xd4 = writable xd3 ∧ zone1 xd4 = zone1 xd3 -> data xp4 = data x5 ∧ length (data x5) = length (data xp3) ∧ offset xp4 = offset xp3 ∧ min xp4 = min xp3 ∧ C.max xp4 = C.max xp3 ∧ writable xp4 = writable xp3 ∧ zone1 xp4 = zone1 xp3 -> length (data x5) = length (data x4) ∧ offset x5 = offset x4 ∧ min x5 = min x4 ∧ C.max x5 = C.max x4 ∧ writable x5 = writable x4 ∧ zone1 x5 = zone1 x4 -> (∀(c : bv 64%N), (0%Z ≤ bv_unsigned c ∧ bv_unsigned c ≤ 1%Z) ∧ value xd4 (bv_signed o34) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o34) * bv_unsigned c = value xd3 (bv_signed o34) + value y (bv_signed o34) ∧ (∀(j : Z), j < offset xd4 ∨ offset xd4 + bv_signed o34 ≤ j -> pelts xd4 j = pelts xd3 j) -> value x5 (bv_signed o8) = value x4 (bv_signed o8) ∧ (value x5 (bv_signed o8) = value x4 (bv_signed o8) -> (¬ 18446744073709551615%Z + 1%Z = 0%Z ∧ (∀(o35 : bv 64%N), bv_unsigned o35 = ZEuclid.modulo (bv_unsigned dh + bv_unsigned c) (18446744073709551615%Z + 1%Z) -> (∀(o36 : bv 64%N), bv_unsigned o36 = ZEuclid.modulo (bv_unsigned o19 + bv_unsigned o35) (18446744073709551615%Z + 1%Z) -> value xd4 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o36 = value xd3 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 + vy - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy)))) ∧ (∀(x12 : bv 64%N), value xd4 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned x12 = value xd3 (bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 + vy - Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy) -> uint'64_in_bounds (bv_unsigned qu - 1%Z) ∧ (∀(o35 : bv 64%N), bv_unsigned o35 = bv_unsigned qu - 1%Z -> (min qp ≤ offset qp + - 1%Z ∧ offset qp + - 1%Z ≤ C.max qp) ∧ (∀(o36 : ptr (bv 64%N)), offset o36 = offset qp + - 1%Z ∧ plength o36 = plength qp ∧ pelts o36 = pelts qp ∧ data o36 = data qp ∧ min o36 = min qp ∧ C.max o36 = C.max qp ∧ zone1 o36 = zone1 qp ∧ writable o36 = writable qp -> (let o37 : Z := offset o36 + bv_signed sx - bv_signed sy - bv_signed o8 in let o38 : Z := offset o36 + 1%Z in let o39 : Z := offset o36 in let o40 : Z -> bv 64%N := pelts q1 in (o38 ≤ o37 ∧ (o39 < o38 ∨ o37 ≤ o39)) ∧ (value_sub o40 o38 o37 = value_sub (fun_updt o40 o39 o35) o38 o37 -> ((min o36 ≤ offset o36 ∧ offset o36 < C.max o36) ∧ writable o36 = true) ∧ (∀(qp1 : ptr (bv 64%N)) (q2 : ptr (bv 64%N)), data qp1 = data q2 ∧ length (data q2) = length (data o36) ∧ offset qp1 = offset o36 ∧ min qp1 = min o36 ∧ C.max qp1 = C.max o36 ∧ writable qp1 = writable o36 ∧ zone1 qp1 = zone1 o36 -> data qp1 = data q2 ∧ length (data q2) = length (data o36) ∧ offset qp1 = offset o36 ∧ min qp1 = min o36 ∧ C.max qp1 = C.max o36 ∧ writable qp1 = writable o36 ∧ zone1 qp1 = zone1 o36 -> length (data q2) = length (data q1) ∧ offset q2 = offset q1 ∧ min q2 = min q1 ∧ C.max q2 = C.max q1 ∧ writable q2 = writable q1 ∧ zone1 q2 = zone1 q1 -> pelts qp1 = fun_updt (pelts o36) (offset qp1) o35 -> bv_signed o8 < bv_signed i ∧ (0%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed sx - bv_signed sy) ∧ offset qp1 = offset q2 + bv_signed o8 ∧ offset xp4 = offset x5 + bv_signed sy + bv_signed o8 - 2%Z ∧ plength qp1 = plength q2 ∧ min qp1 = min q2 ∧ C.max qp1 = C.max q2 ∧ plength xp4 = plength x5 ∧ min xp4 = min x5 ∧ C.max xp4 = C.max x5 ∧ pelts qp1 = pelts q2 ∧ pelts xp4 = pelts x5 ∧ (writable qp1 = true ∧ writable xp4 = true) ∧ value x (bv_signed sx) = (value qp1 (bv_signed sx - bv_signed sy - bv_signed o8) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - bv_signed sy - bv_signed o8)) * vy * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) + value x5 (bv_signed sy + bv_signed o8 - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy + bv_signed o8 - 1%Z) * bv_unsigned x12 ∧ value_sub (pelts x5) (offset xp4 + bv_signed mdn) (offset xp4 + bv_signed mdn + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned x12 < vy ∧ bv_unsigned (pelts x5 (offset xp4)) + (18446744073709551615%Z + 1%Z) * bv_unsigned x12 ≤ bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh))))))))))))) else (min qp ≤ offset qp + - 1%Z ∧ offset qp + - 1%Z ≤ C.max qp) ∧ (∀(o33 : ptr (bv 64%N)), offset o33 = offset qp + - 1%Z ∧ plength o33 = plength qp ∧ pelts o33 = pelts qp ∧ data o33 = data qp ∧ min o33 = min qp ∧ C.max o33 = C.max qp ∧ zone1 o33 = zone1 qp ∧ writable o33 = writable qp -> (let o34 : Z := offset o33 + bv_signed sx - bv_signed sy - bv_signed o8 in let o35 : Z := offset o33 + 1%Z in let o36 : Z := offset o33 in let o37 : Z -> bv 64%N := pelts q1 in (o35 ≤ o34 ∧ (o36 < o35 ∨ o34 ≤ o36)) ∧ (value_sub o37 o35 o34 = value_sub (fun_updt o37 o36 qu) o35 o34 -> ((min o33 ≤ offset o33 ∧ offset o33 < C.max o33) ∧ writable o33 = true) ∧ (∀(qp1 : ptr (bv 64%N)) (q2 : ptr (bv 64%N)), data qp1 = data q2 ∧ length (data q2) = length (data o33) ∧ offset qp1 = offset o33 ∧ min qp1 = min o33 ∧ C.max qp1 = C.max o33 ∧ writable qp1 = writable o33 ∧ zone1 qp1 = zone1 o33 -> data qp1 = data q2 ∧ length (data q2) = length (data o33) ∧ offset qp1 = offset o33 ∧ min qp1 = min o33 ∧ C.max qp1 = C.max o33 ∧ writable qp1 = writable o33 ∧ zone1 qp1 = zone1 o33 -> length (data q2) = length (data q1) ∧ offset q2 = offset q1 ∧ min q2 = min q1 ∧ C.max q2 = C.max q1 ∧ writable q2 = writable q1 ∧ zone1 q2 = zone1 q1 -> pelts qp1 = fun_updt (pelts o33) (offset qp1) qu -> bv_signed o8 < bv_signed i ∧ (0%Z ≤ bv_signed o8 ∧ bv_signed o8 ≤ bv_signed sx - bv_signed sy) ∧ offset qp1 = offset q2 + bv_signed o8 ∧ offset xp3 = offset x4 + bv_signed sy + bv_signed o8 - 2%Z ∧ plength qp1 = plength q2 ∧ min qp1 = min q2 ∧ C.max qp1 = C.max q2 ∧ plength xp3 = plength x4 ∧ min xp3 = min x4 ∧ C.max xp3 = C.max x4 ∧ pelts qp1 = pelts q2 ∧ pelts xp3 = pelts x4 ∧ (writable qp1 = true ∧ writable xp3 = true) ∧ value x (bv_signed sx) = (value qp1 (bv_signed sx - bv_signed sy - bv_signed o8) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - bv_signed sy - bv_signed o8)) * vy * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o8) + value x4 (bv_signed sy + bv_signed o8 - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy + bv_signed o8 - 1%Z) * bv_unsigned o19 ∧ value_sub (pelts x4) (offset xp3 + bv_signed mdn) (offset xp3 + bv_signed mdn + bv_signed sy - 1%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sy - 1%Z) * bv_unsigned o19 < vy ∧ bv_unsigned (pelts x4 (offset xp3)) + (18446744073709551615%Z + 1%Z) * bv_unsigned o19 ≤ bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh))))))))))))))))))))))))))))))))))) else let o8 : Z := offset xp1 in let o9 : Z := offset x2 in let o10 : Z := offset xp1 + 1%Z in let o11 : Z -> bv 64%N := pelts x2 in (o9 ≤ o8 ∧ (o10 < o9 ∨ o8 ≤ o10)) ∧ (value_sub o11 o9 o8 = value_sub (fun_updt o11 o10 x11) o9 o8 -> ((min xp1 ≤ offset xp1 + 1%Z ∧ offset xp1 + 1%Z < C.max xp1) ∧ writable xp1 = true) ∧ (∀(o12 : ptr (bv 64%N)) (x3 : ptr (bv 64%N)), data o12 = data x3 ∧ length (data x3) = length (data xp1) ∧ offset o12 = offset xp1 ∧ min o12 = min xp1 ∧ C.max o12 = C.max xp1 ∧ writable o12 = writable xp1 ∧ zone1 o12 = zone1 xp1 -> length (data x3) = length (data x2) ∧ offset x3 = offset x2 ∧ min x3 = min x2 ∧ C.max x3 = C.max x2 ∧ writable x3 = writable x2 ∧ zone1 x3 = zone1 x2 -> pelts o12 = fun_updt (pelts xp1) (offset o12 + 1%Z) x11 ∧ pelts o12 (offset o12 + 1%Z) = x11 -> value x (bv_signed sx) = (value q1 (bv_signed sx - bv_signed sy) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - bv_signed sy) * bv_unsigned qh) * value y (bv_signed sy) + value x3 (bv_signed sy) ∧ value x3 (bv_signed sy) < value y (bv_signed sy) ∧ 0%Z ≤ bv_unsigned qh ∧ bv_unsigned qh ≤ 1%Z)))))))))))))))))))).
Admitted.
