From Stdlib Require Import Strings.String.
From Stdlib Require Import String Ascii.
From Stdlib Require Arith.
From stdpp Require Import base.
From stdpp Require Import fin_maps.
From stdpp Require Import gmap.
From stdpp Require Import base gmultiset.
From Stdlib Require Classical.
From Stdlib Require Import ZArith.
From stdpp.bitvector Require Import definitions tactics.
From Stdlib Require Import Sorting.Sorted.
From Stdlib Require Import Reals.Rbasic_fun.
From Stdlib Require Import Reals.Abstract.ConstructiveAbs.
From Stdlib Require Import Reals.Rdefinitions.
From stdpp Require Import list_relations.
From stdpp Require Import list_numbers.
From stdpp Require Import functions.
From Stdlib Require Import ClassicalEpsilon.
From stdpp Require Import base decidable.
From Stdlib Require Import ZArith.Zeuclid.
From Stdlib Require Import ZArith.Znumtheory.
From stdpp Require Import propset.
From Stdlib Require Import Reals.
Require Import Why3.Base.
Require Import Why3.why3.Ref.Ref.
Require Import Why3.map.Const.
Require Import Why3.map.MapEq.
Require Import Why3.mach.int.Unsigned.
Require Import Why3.mach.c.C.
Require Import multiprecision.types.Config.
Require Import multiprecision.types.Types.
Require Import multiprecision.types.Int32Eq.
Require Import multiprecision.types.UInt64Eq.
Require Import multiprecision.lemmas.Lemmas.
Require Import multiprecision.compare.Compare.
Require Import multiprecision.util.Util.
Require Import multiprecision.ptralias.Alias.
Require Import multiprecision.util.UtilOld.
Require Import multiprecision.add.Add.
Require Import multiprecision.add.AddOld.
Require Import multiprecision.sub.SubOld.
Require Import multiprecision.logical.LogicalUtil.
Require Import multiprecision.logical.LogicalOld.
Require Import multiprecision.mul.Mul.
Open Scope Z_scope.
Definition reciprocal (v : bv 64%N) (d : bv 64%N) := bv_unsigned v = ZEuclid.div ((18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) - 1%Z) (bv_unsigned d) - (18446744073709551615%Z + 1%Z).
Definition reciprocal_3by2 (v : bv 64%N) (dh : bv 64%N) (dl : bv 64%N) := bv_unsigned v = ZEuclid.div ((18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) - 1%Z) (bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh) - (18446744073709551615%Z + 1%Z).
Definition normalized (x : ptr (bv 64%N)) (sz : bv 32%N) := valid x (bv_signed sz) ∧ ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned (pelts x (offset x + bv_signed sz - 1%Z)).
Theorem wmpn_divrem_2'vc (sx : bv 32%N) (x : ptr (bv 64%N)) (y : ptr (bv 64%N)) (q : ptr (bv 64%N)) (fact0 : 2%Z ≤ bv_signed sx) (fact1 : valid x (bv_signed sx)) (fact2 : valid y 2%Z) (fact3 : valid q (bv_signed sx - 2%Z)) (fact4 : ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned (pelts y (offset y + 1%Z))) (fact5 : writable q = true) (fact6 : writable x = true) : int'32_in_bounds (bv_signed sx - 2%Z) ∧ (∀(o1 : bv 32%N), bv_signed o1 = bv_signed sx - 2%Z -> (min x ≤ offset x + bv_signed o1 ∧ offset x + bv_signed o1 ≤ C.max x) ∧ (∀(o2 : ptr (bv 64%N)), offset o2 = offset x + bv_signed o1 ∧ plength o2 = plength x ∧ pelts o2 = pelts x ∧ data o2 = data x ∧ min o2 = min x ∧ C.max o2 = C.max x ∧ zone1 o2 = zone1 x ∧ writable o2 = writable x -> (min y ≤ offset y + 1%Z ∧ offset y + 1%Z < C.max y) ∧ (let dh : bv 64%N := pelts y (offset y + 1%Z) in (min y ≤ offset y ∧ offset y < C.max y) ∧ (let dl : bv 64%N := pelts y (offset y) in (min o2 ≤ offset o2 + 1%Z ∧ offset o2 + 1%Z < C.max o2) ∧ (let o3 : bv 64%N := pelts o2 (offset o2 + 1%Z) in (min o2 ≤ offset o2 ∧ offset o2 < C.max o2) ∧ (let o4 : bv 64%N := pelts o2 (offset o2) in int'32_in_bounds (bv_signed sx - 2%Z) ∧ (∀(o5 : bv 32%N), bv_signed o5 = bv_signed sx - 2%Z -> ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned dh ∧ (∀(dinv : bv 64%N), reciprocal_3by2 dinv dh dl -> ((if decide (bv_unsigned dh ≤ bv_unsigned o3) then if decide (bv_unsigned dh < bv_unsigned o3) then True else true = (if decide (bv_unsigned dl ≤ bv_unsigned o4) then true else false) else true = false) -> (0%Z ≤ 0%Z ∧ 0%Z ≤ 1%Z) ∧ (∀(r0 : bv 64%N) (b : bv 64%N), bv_unsigned r0 - (18446744073709551615%Z + 1%Z) * bv_unsigned b = bv_unsigned o4 - bv_unsigned dl - 0%Z ∧ 0%Z ≤ bv_unsigned b ∧ bv_unsigned b ≤ 1%Z -> 0%Z ≤ bv_unsigned b ∧ bv_unsigned b ≤ 1%Z)) ∧ (∀(rh : bv 64%N) (rl : bv 64%N) (qh : bv 64%N), (∃(o6 : bool), (if decide (bv_unsigned dh ≤ bv_unsigned o3) then if decide (bv_unsigned dh < bv_unsigned o3) then o6 = true else o6 = (if decide (bv_unsigned dl ≤ bv_unsigned o4) then true else false) else o6 = false) ∧ (if decide (o6 = true) then ∃(d : bv 64%N), (bv_unsigned rl - (18446744073709551615%Z + 1%Z) * bv_unsigned d = bv_unsigned o4 - bv_unsigned dl - 0%Z ∧ 0%Z ≤ bv_unsigned d ∧ bv_unsigned d ≤ 1%Z) ∧ (∃(d1 : bv 64%N), (bv_unsigned rh - (18446744073709551615%Z + 1%Z) * bv_unsigned d1 = bv_unsigned o3 - bv_unsigned dh - bv_unsigned d ∧ 0%Z ≤ bv_unsigned d1 ∧ bv_unsigned d1 ≤ 1%Z) ∧ qh = (1%bv : bv 64%N)) else (rh = o3 ∧ rl = o4) ∧ qh = (0%bv : bv 64%N))) -> ((0%Z ≤ bv_signed o5 ∧ bv_signed o5 ≤ bv_signed sx - 2%Z) ∧ offset o2 = offset x + bv_signed o5 ∧ plength o2 = plength x ∧ min o2 = min x ∧ C.max o2 = C.max x ∧ pelts o2 = pelts x ∧ writable o2 = true ∧ value x (bv_signed sx) = (value_sub (pelts q) (offset q + bv_signed o5) (offset q + bv_signed sx - 2%Z) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - 2%Z - bv_signed o5)) * value y 2%Z * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o5) + value x (bv_signed o5) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o5) * (bv_unsigned rl + (18446744073709551615%Z + 1%Z) * bv_unsigned rh) ∧ bv_unsigned rl + (18446744073709551615%Z + 1%Z) * bv_unsigned rh < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh) ∧ (∀(i : bv 32%N) (rl1 : bv 64%N) (rh1 : bv 64%N) (xp : ptr (bv 64%N)) (q1 : ptr (bv 64%N)), length (data q1) = length (data q) ∧ offset q1 = offset q ∧ min q1 = min q ∧ C.max q1 = C.max q ∧ writable q1 = writable q ∧ zone1 q1 = zone1 q -> (0%Z ≤ bv_signed i ∧ bv_signed i ≤ bv_signed sx - 2%Z) ∧ offset xp = offset x + bv_signed i ∧ plength xp = plength x ∧ min xp = min x ∧ C.max xp = C.max x ∧ pelts xp = pelts x ∧ writable xp = true ∧ value x (bv_signed sx) = (value_sub (pelts q1) (offset q1 + bv_signed i) (offset q1 + bv_signed sx - 2%Z) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - 2%Z - bv_signed i)) * value y 2%Z * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed i) + value x (bv_signed i) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed i) * (bv_unsigned rl1 + (18446744073709551615%Z + 1%Z) * bv_unsigned rh1) ∧ bv_unsigned rl1 + (18446744073709551615%Z + 1%Z) * bv_unsigned rh1 < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh -> (if decide (0%Z < bv_signed i) then (min xp ≤ offset xp + - 1%Z ∧ offset xp + - 1%Z ≤ C.max xp) ∧ (∀(o6 : ptr (bv 64%N)), offset o6 = offset xp + - 1%Z ∧ plength o6 = plength xp ∧ pelts o6 = pelts xp ∧ data o6 = data xp ∧ min o6 = min xp ∧ C.max o6 = C.max xp ∧ zone1 o6 = zone1 xp ∧ writable o6 = writable xp -> (min o6 ≤ offset o6 ∧ offset o6 < C.max o6) ∧ (ZEuclid.div (18446744073709551615%Z + 1%Z) 2%Z ≤ bv_unsigned dh ∧ reciprocal_3by2 dinv dh dl ∧ bv_unsigned rl1 + (18446744073709551615%Z + 1%Z) * bv_unsigned rh1 < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh) ∧ (∀(qu : bv 64%N) (r0 : bv 64%N) (r1 : bv 64%N), bv_unsigned qu * bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned qu * bv_unsigned dh + bv_unsigned r0 + (18446744073709551615%Z + 1%Z) * bv_unsigned r1 = bv_unsigned (pelts o6 (offset o6)) + (18446744073709551615%Z + 1%Z) * bv_unsigned rl1 + (18446744073709551615%Z + 1%Z) * (18446744073709551615%Z + 1%Z) * bv_unsigned rh1 ∧ 0%Z ≤ bv_unsigned r0 + (18446744073709551615%Z + 1%Z) * bv_unsigned r1 ∧ bv_unsigned r0 + (18446744073709551615%Z + 1%Z) * bv_unsigned r1 < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh -> int'32_in_bounds (bv_signed i - 1%Z) ∧ (∀(o7 : bv 32%N), bv_signed o7 = bv_signed i - 1%Z -> ((min q1 ≤ offset q1 + bv_signed o7 ∧ offset q1 + bv_signed o7 < C.max q1) ∧ writable q1 = true) ∧ (∀(q2 : ptr (bv 64%N)), length (data q2) = length (data q1) ∧ offset q2 = offset q1 ∧ min q2 = min q1 ∧ C.max q2 = C.max q1 ∧ writable q2 = writable q1 ∧ zone1 q2 = zone1 q1 -> pelts q2 = fun_updt (pelts q1) (offset q2 + bv_signed o7) qu ∧ pelts q2 (offset q2 + bv_signed o7) = qu -> bv_signed o7 < bv_signed i ∧ (0%Z ≤ bv_signed o7 ∧ bv_signed o7 ≤ bv_signed sx - 2%Z) ∧ offset o6 = offset x + bv_signed o7 ∧ plength o6 = plength x ∧ min o6 = min x ∧ C.max o6 = C.max x ∧ pelts o6 = pelts x ∧ writable o6 = true ∧ value x (bv_signed sx) = (value_sub (pelts q2) (offset q2 + bv_signed o7) (offset q2 + bv_signed sx - 2%Z) + bv_unsigned qh * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - 2%Z - bv_signed o7)) * value y 2%Z * Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o7) + value x (bv_signed o7) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed o7) * (bv_unsigned r0 + (18446744073709551615%Z + 1%Z) * bv_unsigned r1) ∧ bv_unsigned r0 + (18446744073709551615%Z + 1%Z) * bv_unsigned r1 < bv_unsigned dl + (18446744073709551615%Z + 1%Z) * bv_unsigned dh)))) else ((min x ≤ offset x + 1%Z ∧ offset x + 1%Z < C.max x) ∧ writable x = true) ∧ (∀(x1 : ptr (bv 64%N)), length (data x1) = length (data x) ∧ offset x1 = offset x ∧ min x1 = min x ∧ C.max x1 = C.max x ∧ writable x1 = writable x ∧ zone1 x1 = zone1 x -> pelts x1 = fun_updt (pelts x) (offset x1 + 1%Z) rh1 ∧ pelts x1 (offset x1 + 1%Z) = rh1 -> ((min x1 ≤ offset x1 ∧ offset x1 < C.max x1) ∧ writable x1 = true) ∧ (∀(x2 : ptr (bv 64%N)), length (data x2) = length (data x1) ∧ offset x2 = offset x1 ∧ min x2 = min x1 ∧ C.max x2 = C.max x1 ∧ writable x2 = writable x1 ∧ zone1 x2 = zone1 x1 -> pelts x2 = fun_updt (pelts x1) (offset x2) rl1 -> value x (bv_signed sx) = (value q1 (bv_signed sx - 2%Z) + Z.pow (18446744073709551615%Z + 1%Z) (bv_signed sx - 2%Z) * bv_unsigned qh) * value y 2%Z + value x2 2%Z ∧ value x2 2%Z < value y 2%Z ∧ 0%Z ≤ bv_unsigned qh ∧ bv_unsigned qh ≤ 1%Z))))))))))))).
Admitted.
