theory lineardecision_EqPropMP_max_var_ctxqtqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "mach.matrix_Matrix63" "Why3STD.debug_Debug" "../../lib/isabelle/lineardecision_RationalCoeffs" "../../lib/isabelle/lineardecision_MP64Coeffs" "../../lib/isabelle/lineardecision_LinearDecisionRationalMP" "../../lib/isabelle/lineardecision_LinearDecisionIntMP"
begin
fun expr_bound' :: "lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int \<Rightarrow> _"
  where "expr_bound' (lineardecision_LinearDecisionIntMP.Sum e1 e2) b = (expr_bound' e1 b \<and> expr_bound' e2 b)" for e1 e2 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Diff e1 e2) b = (expr_bound' e1 b \<and> expr_bound' e2 b)" for e1 e2 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.ProdL e1 x) b = expr_bound' e1 b" for e1 x b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.ProdR x e1) b = expr_bound' e1 b" for x e1 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Var n) b = ((0 :: int) \<le> n \<and> n \<le> b)" for n b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Coeff x) b = True" for x b
definition eq_bound' :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int \<Rightarrow> _"
  where "eq_bound' eq b \<longleftrightarrow> (case eq of (e1, e2) \<Rightarrow> expr_bound' e1 b \<and> expr_bound' e2 b)" for eq b
fun ctx_bound' :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> int \<Rightarrow> _"
  where "ctx_bound' (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) b = True" for b
      | "ctx_bound' (Cons eq t) b = (eq_bound' eq b \<and> ctx_bound' t b)" for eq t b
consts max_var' :: "lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int"
axiomatization where max_var''def:   "case e of lineardecision_LinearDecisionIntMP.Var i \<Rightarrow> max_var' e = i | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> max_var' e = (0 :: int) | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> max_var' e = max (max_var' e1) (max_var' e2) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> max_var' e = max (max_var' e1) (max_var' e2) | lineardecision_LinearDecisionIntMP.ProdL e1 _ \<Rightarrow> max_var' e = max_var' e1 | lineardecision_LinearDecisionIntMP.ProdR _ e1 \<Rightarrow> max_var' e = max_var' e1"
 if "lineardecision_LinearDecisionIntMP.valid_expr' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var''spec'0:   "(0 :: int) \<le> max_var' e"
 if "lineardecision_LinearDecisionIntMP.valid_expr' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var''spec:   "expr_bound' e (max_var' e)"
 if "lineardecision_LinearDecisionIntMP.valid_expr' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr'"
consts max_var_e' :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int"
axiomatization where max_var_e''def:   "case e of (e1, e2) \<Rightarrow> max_var_e' e = max (max_var' e1) (max_var' e2)"
 if "lineardecision_LinearDecisionIntMP.valid_eq' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var_e''spec'0:   "(0 :: int) \<le> max_var_e' e"
 if "lineardecision_LinearDecisionIntMP.valid_eq' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var_e''spec:   "eq_bound' e (max_var_e' e)"
 if "lineardecision_LinearDecisionIntMP.valid_eq' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr'"
theorem max_var_ctx''vc:
  fixes l :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list"
  assumes fact0: "lineardecision_LinearDecisionIntMP.valid_ctx' l"
  shows "case l of Nil \<Rightarrow> True | Cons e t \<Rightarrow> ((case l of Nil \<Rightarrow> False | Cons _ f \<Rightarrow> f = t) \<and> lineardecision_LinearDecisionIntMP.valid_ctx' t) \<and> (\<forall>(o1 :: int). (0 :: int) \<le> o1 \<and> ctx_bound' t o1 \<longrightarrow> lineardecision_LinearDecisionIntMP.valid_eq' e)"
  and "\<forall>(result :: int). (case l of Nil \<Rightarrow> result = (0 :: int) | Cons e t \<Rightarrow> (\<exists>(o1 :: int). ((0 :: int) \<le> o1 \<and> ctx_bound' t o1) \<and> (let o2 :: int = max_var_e' e in ((0 :: int) \<le> o2 \<and> eq_bound' e o2) \<and> result = max o2 o1))) \<longrightarrow> (0 :: int) \<le> result \<and> ctx_bound' l result"
  sorry
end
