theory lineardecision_EqPropMP_max_varqtqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "mach.matrix_Matrix63" "Why3STD.debug_Debug" "../../lib/isabelle/lineardecision_RationalCoeffs" "../../lib/isabelle/lineardecision_MP64Coeffs" "../../lib/isabelle/lineardecision_LinearDecisionRationalMP" "../../lib/isabelle/lineardecision_LinearDecisionIntMP"
begin
fun expr_bound' :: "lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int \<Rightarrow> _"
  where "expr_bound' (lineardecision_LinearDecisionIntMP.Sum e1 e2) b = (expr_bound' e1 b \<and> expr_bound' e2 b)" for e1 e2 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Diff e1 e2) b = (expr_bound' e1 b \<and> expr_bound' e2 b)" for e1 e2 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.ProdL e1 x) b = expr_bound' e1 b" for e1 x b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.ProdR x e1) b = expr_bound' e1 b" for x e1 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Var n) b = ((0 :: int) \<le> n \<and> n \<le> b)" for n b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Coeff x) b = True" for x b
definition eq_bound' :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int \<Rightarrow> _"
  where "eq_bound' eq b \<longleftrightarrow> (case eq of (e1, e2) \<Rightarrow> expr_bound' e1 b \<and> expr_bound' e2 b)" for eq b
fun ctx_bound' :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> int \<Rightarrow> _"
  where "ctx_bound' (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) b = True" for b
      | "ctx_bound' (Cons eq t) b = (eq_bound' eq b \<and> ctx_bound' t b)" for eq t b
theorem max_var''vc:
  fixes e :: "lineardecision_LinearDecisionIntMP.expr'"
  assumes fact0: "lineardecision_LinearDecisionIntMP.valid_expr' e"
  shows "case e of lineardecision_LinearDecisionIntMP.Var i \<Rightarrow> True | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> True | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e2) \<and> (\<forall>(o1 :: int). (0 :: int) \<le> o1 \<and> expr_bound' e2 o1 \<longrightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e2) \<and> (\<forall>(o1 :: int). (0 :: int) \<le> o1 \<and> expr_bound' e2 o1 \<longrightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) | lineardecision_LinearDecisionIntMP.ProdL e1 _ \<Rightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1 | lineardecision_LinearDecisionIntMP.ProdR _ e1 \<Rightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1"
  and "\<forall>(result :: int). (case e of lineardecision_LinearDecisionIntMP.Var i \<Rightarrow> result = i | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> result = (0 :: int) | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> (\<exists>(o1 :: int). ((0 :: int) \<le> o1 \<and> expr_bound' e2 o1) \<and> (\<exists>(o2 :: int). ((0 :: int) \<le> o2 \<and> expr_bound' e1 o2) \<and> result = max o2 o1)) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> (\<exists>(o1 :: int). ((0 :: int) \<le> o1 \<and> expr_bound' e2 o1) \<and> (\<exists>(o2 :: int). ((0 :: int) \<le> o2 \<and> expr_bound' e1 o2) \<and> result = max o2 o1)) | lineardecision_LinearDecisionIntMP.ProdL e1 _ \<Rightarrow> (0 :: int) \<le> result \<and> expr_bound' e1 result | lineardecision_LinearDecisionIntMP.ProdR _ e1 \<Rightarrow> (0 :: int) \<le> result \<and> expr_bound' e1 result) \<longrightarrow> (0 :: int) \<le> result \<and> expr_bound' e result"
  sorry
end
