theory lineardecision_EqPropMP_prop_ctxqtvc
  imports "NTP4Verif.NTP4Verif" "Why3STD.Ref_Ref" "Why3STD.int_NumOf" "mach.matrix_Matrix63" "Why3STD.debug_Debug" "../../lib/isabelle/lineardecision_RationalCoeffs" "../../lib/isabelle/lineardecision_MP64Coeffs" "../../lib/isabelle/lineardecision_LinearDecisionRationalMP" "../../lib/isabelle/lineardecision_LinearDecisionIntMP"
begin
fun expr_bound' :: "lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int \<Rightarrow> _"
  where "expr_bound' (lineardecision_LinearDecisionIntMP.Sum e1 e2) b = (expr_bound' e1 b \<and> expr_bound' e2 b)" for e1 e2 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Diff e1 e2) b = (expr_bound' e1 b \<and> expr_bound' e2 b)" for e1 e2 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.ProdL e1 x) b = expr_bound' e1 b" for e1 x b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.ProdR x e1) b = expr_bound' e1 b" for x e1 b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Var n) b = ((0 :: int) \<le> n \<and> n \<le> b)" for n b
      | "expr_bound' (lineardecision_LinearDecisionIntMP.Coeff x) b = True" for x b
definition eq_bound' :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int \<Rightarrow> _"
  where "eq_bound' eq b \<longleftrightarrow> (case eq of (e1, e2) \<Rightarrow> expr_bound' e1 b \<and> expr_bound' e2 b)" for eq b
fun ctx_bound' :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> int \<Rightarrow> _"
  where "ctx_bound' (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) b = True" for b
      | "ctx_bound' (Cons eq t) b = (eq_bound' eq b \<and> ctx_bound' t b)" for eq t b
consts max_var' :: "lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int"
axiomatization where max_var''def:   "case e of lineardecision_LinearDecisionIntMP.Var i \<Rightarrow> max_var' e = i | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> max_var' e = (0 :: int) | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> max_var' e = max (max_var' e1) (max_var' e2) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> max_var' e = max (max_var' e1) (max_var' e2) | lineardecision_LinearDecisionIntMP.ProdL e1 _ \<Rightarrow> max_var' e = max_var' e1 | lineardecision_LinearDecisionIntMP.ProdR _ e1 \<Rightarrow> max_var' e = max_var' e1"
 if "lineardecision_LinearDecisionIntMP.valid_expr' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var''spec'0:   "(0 :: int) \<le> max_var' e"
 if "lineardecision_LinearDecisionIntMP.valid_expr' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var''spec:   "expr_bound' e (max_var' e)"
 if "lineardecision_LinearDecisionIntMP.valid_expr' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr'"
consts max_var_e' :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' \<Rightarrow> int"
axiomatization where max_var_e''def:   "case e of (e1, e2) \<Rightarrow> max_var_e' e = max (max_var' e1) (max_var' e2)"
 if "lineardecision_LinearDecisionIntMP.valid_eq' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var_e''spec'0:   "(0 :: int) \<le> max_var_e' e"
 if "lineardecision_LinearDecisionIntMP.valid_eq' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr'"
axiomatization where max_var_e''spec:   "eq_bound' e (max_var_e' e)"
 if "lineardecision_LinearDecisionIntMP.valid_eq' e"
  for e :: "lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr'"
consts max_var_ctx' :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> int"
axiomatization where max_var_ctx''def:   "case l of Nil \<Rightarrow> max_var_ctx' l = (0 :: int) | Cons e t \<Rightarrow> max_var_ctx' l = max (max_var_e' e) (max_var_ctx' t)"
 if "lineardecision_LinearDecisionIntMP.valid_ctx' l"
  for l :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list"
axiomatization where max_var_ctx''spec'0:   "(0 :: int) \<le> max_var_ctx' l"
 if "lineardecision_LinearDecisionIntMP.valid_ctx' l"
  for l :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list"
axiomatization where max_var_ctx''spec:   "ctx_bound' l (max_var_ctx' l)"
 if "lineardecision_LinearDecisionIntMP.valid_ctx' l"
  for l :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list"
fun ctx_impl_ctx' :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> _"
  where "ctx_impl_ctx' c1 (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) = True" for c1
      | "ctx_impl_ctx' c1 (Cons eq t) = (ctx_impl_ctx' c1 t \<and> (\<forall>(y :: int \<Rightarrow> int) (z :: int \<Rightarrow> int). y = z \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' c1 eq y z = True))" for c1 eq t
fun ctx_holds' :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> (int \<Rightarrow> int) \<Rightarrow> _"
  where "ctx_holds' (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) y z = True" for y z
      | "ctx_holds' (Cons h t) y z = (lineardecision_LinearDecisionIntMP.interp_eq' h y z = True \<and> ctx_holds' t y z)" for h t y z
definition is_eq_tbl :: "exp option list \<Rightarrow> (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list \<Rightarrow> _"
  where "is_eq_tbl a l \<longleftrightarrow> (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < int (length a) \<longrightarrow> (case a ! nat i of None \<Rightarrow> True | Some e \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int) (z :: int \<Rightarrow> int). y = z \<longrightarrow> ctx_holds' l y z \<longrightarrow> interp_exp (lineardecision_MP64Coeffs.Var i) z = interp_exp e z)))" for a l
consts fc :: "'a list \<Rightarrow> 'a \<Rightarrow> int \<Rightarrow> bool"
axiomatization where fc'def:   "fc a v i = True \<longleftrightarrow> a ! nat i = v"
  for a :: "'a list"
  and v :: "'a"
  and i :: "int"
theorem prop_ctx'vc:
  fixes g :: "lineardecision_LinearDecisionIntMP.expr'"
  fixes g1 :: "lineardecision_LinearDecisionIntMP.expr'"
  fixes l :: "(lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list"
  shows "let g2 :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (g, g1) in lineardecision_LinearDecisionIntMP.valid_ctx' l \<and> lineardecision_LinearDecisionIntMP.valid_eq' g2 \<longrightarrow> lineardecision_LinearDecisionIntMP.valid_eq' g2 \<and> (let o1 :: int = max_var_e' g2 in (0 :: int) \<le> o1 \<and> eq_bound' g2 o1 \<longrightarrow> lineardecision_LinearDecisionIntMP.valid_ctx' l \<and> (let o2 :: int = max_var_ctx' l in (0 :: int) \<le> o2 \<and> ctx_bound' l o2 \<longrightarrow> (let m :: int = max o2 o1; o3 :: int = m + (1 :: int) in (0 :: int) \<le> o3 \<and> (\<forall>(a :: exp option list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o3 \<longrightarrow> a ! nat i = None) \<and> int (length a) = o3 \<longrightarrow> (\<forall>(e :: lineardecision_LinearDecisionIntMP.expr'). (case e of lineardecision_LinearDecisionIntMP.Var i \<Rightarrow> True | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> (\<forall>(o4 :: exp option). (case o4 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e2 y y = interp_exp ex y)) \<longrightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> (\<forall>(o5 :: exp option). (case o5 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e1 y y = interp_exp ex y)) \<longrightarrow> (case o4 of Some x \<Rightarrow> (case o5 of Some x1 \<Rightarrow> True | _ \<Rightarrow> True) | _ \<Rightarrow> True))) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> (\<forall>(o4 :: exp option). (case o4 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e2 y y = interp_exp ex y)) \<longrightarrow> (case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> (\<forall>(o5 :: exp option). (case o5 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e1 y y = interp_exp ex y)) \<longrightarrow> (case o4 of Some x \<Rightarrow> (case o5 of Some x1 \<Rightarrow> True | _ \<Rightarrow> True) | _ \<Rightarrow> True))) | lineardecision_LinearDecisionIntMP.Coeff (I n) \<Rightarrow> True | _ \<Rightarrow> True) \<and> (\<forall>(result :: exp option). (case e of lineardecision_LinearDecisionIntMP.Var i \<Rightarrow> result = Some (lineardecision_MP64Coeffs.Var i) | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> (\<exists>(o4 :: exp option). (case o4 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e2 y y = interp_exp ex y)) \<and> (\<exists>(o5 :: exp option). (case o5 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e1 y y = interp_exp ex y)) \<and> (case o4 of Some x \<Rightarrow> (case o5 of Some x1 \<Rightarrow> result = Some (Plus x1 x) | _ \<Rightarrow> result = None) | _ \<Rightarrow> result = None))) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> (\<exists>(o4 :: exp option). (case o4 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e2 y y = interp_exp ex y)) \<and> (\<exists>(o5 :: exp option). (case o5 of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e1 y y = interp_exp ex y)) \<and> (case o4 of Some x \<Rightarrow> (case o5 of Some x1 \<Rightarrow> result = Some (Sub x1 x) | _ \<Rightarrow> result = None) | _ \<Rightarrow> result = None))) | lineardecision_LinearDecisionIntMP.Coeff (I n) \<Rightarrow> result = Some (Lit n) | _ \<Rightarrow> result = None) \<longrightarrow> (case result of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' e y y = interp_exp ex y)))) \<and> (\<forall>(a1 :: exp option list). length a1 = length a \<longrightarrow> (\<forall>(eq :: lineardecision_LinearDecisionIntMP.expr') (eq1 :: lineardecision_LinearDecisionIntMP.expr'). let eq2 :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (eq, eq1) in eq_bound' eq2 m \<longrightarrow> (case eq1 of lineardecision_LinearDecisionIntMP.Var x \<Rightarrow> (case eq of lineardecision_LinearDecisionIntMP.Var x1 \<Rightarrow> (\<forall>(r :: exp option). (case r of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' eq1 y y = interp_exp ex y)) \<longrightarrow> (case r of None \<Rightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl a1 (Cons eq2 l1)) | Some ex \<Rightarrow> (let o4 :: exp option = Some ex in ((0 :: int) \<le> x1 \<and> x1 < int (length a1)) \<and> (length (a1[nat x1 := o4]) = length a1 \<longrightarrow> nth (a1[nat x1 := o4]) o nat = (nth a1 o nat)(x1 := o4) \<longrightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl (a1[nat x1 := o4]) (Cons eq2 l1)))))) | _ \<Rightarrow> (\<forall>(r :: exp option). (case r of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' eq y y = interp_exp ex y)) \<longrightarrow> (case r of None \<Rightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl a1 (Cons eq2 l1)) | Some ex \<Rightarrow> (let o4 :: exp option = Some ex in ((0 :: int) \<le> x \<and> x < int (length a1)) \<and> (length (a1[nat x := o4]) = length a1 \<longrightarrow> nth (a1[nat x := o4]) o nat = (nth a1 o nat)(x := o4) \<longrightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl (a1[nat x := o4]) (Cons eq2 l1))))))) | _ \<Rightarrow> (case eq of lineardecision_LinearDecisionIntMP.Var x \<Rightarrow> (\<forall>(r :: exp option). (case r of None \<Rightarrow> True | Some ex \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp' eq1 y y = interp_exp ex y)) \<longrightarrow> (case r of None \<Rightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl a1 (Cons eq2 l1)) | Some ex \<Rightarrow> (let o4 :: exp option = Some ex in ((0 :: int) \<le> x \<and> x < int (length a1)) \<and> (length (a1[nat x := o4]) = length a1 \<longrightarrow> nth (a1[nat x := o4]) o nat = (nth a1 o nat)(x := o4) \<longrightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl (a1[nat x := o4]) (Cons eq2 l1)))))) | _ \<Rightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 l1 \<longrightarrow> is_eq_tbl a1 (Cons eq2 l1)))))) \<and> (\<forall>(a1 :: exp option list). length a1 = length a \<longrightarrow> (\<forall>(l1 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a1 (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) \<and> ctx_bound' l1 m \<longrightarrow> (case l1 of Nil \<Rightarrow> is_eq_tbl a1 l1 | Cons eq l2 \<Rightarrow> ((case l1 of Nil \<Rightarrow> False | Cons _ f \<Rightarrow> f = l2) \<and> is_eq_tbl a1 (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) \<and> ctx_bound' l2 m) \<and> (\<forall>(a2 :: exp option list). length a2 = length a1 \<longrightarrow> is_eq_tbl a2 l2 \<longrightarrow> eq_bound' eq m \<and> (\<forall>(a3 :: exp option list). length a3 = length a2 \<longrightarrow> (\<forall>(l3 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). is_eq_tbl a2 l3 \<longrightarrow> is_eq_tbl a3 (Cons eq l3)) \<longrightarrow> is_eq_tbl a3 l1))))) \<and> (is_eq_tbl a (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) \<and> ctx_bound' l m) \<and> (\<forall>(a1 :: exp option list). length a1 = length a \<longrightarrow> is_eq_tbl a1 l \<longrightarrow> (let o4 :: int = m + (1 :: int) in (0 :: int) \<le> o4 \<and> (\<forall>(seen :: bool list). (\<forall>(i :: int). (0 :: int) \<le> i \<and> i < o4 \<longrightarrow> seen ! nat i = False) \<and> int (length seen) = o4 \<longrightarrow> (\<forall>(seen1 :: bool list) (a2 :: exp option list). length seen1 = length seen \<longrightarrow> length a2 = length a1 \<longrightarrow> (\<forall>(i :: int). is_eq_tbl a2 l \<and> seen1 ! nat i = False \<longrightarrow> (\<forall>(seen2 :: bool list) (a3 :: exp option list). length seen2 = length seen1 \<longrightarrow> length a3 = length a2 \<longrightarrow> (\<forall>(e :: exp). is_eq_tbl a3 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen2)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False \<longrightarrow> (case e of Lit _ \<Rightarrow> is_eq_tbl a3 l | lineardecision_MP64Coeffs.Var j \<Rightarrow> (0 :: int) \<le> j \<and> j < int (length seen2) \<longrightarrow> (if \<not>seen2 ! nat j = True then (((0 :: int) \<le> int (count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen2)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> is_eq_tbl a3 l \<and> seen2 ! nat j = False) \<and> (\<forall>(seen3 :: bool list) (a4 :: exp option list). length seen3 = length seen2 \<longrightarrow> length a4 = length a3 \<longrightarrow> is_eq_tbl a4 l \<and> seen3 ! nat j = True \<and> (\<forall>(j1 :: int). seen2 ! nat j1 = True \<longrightarrow> seen3 ! nat j1 = True) \<longrightarrow> (0 :: int) \<le> j \<and> j < int (length a4) \<longrightarrow> (\<forall>(result :: exp). (case a4 ! nat j of None \<Rightarrow> result = e | Some e' \<Rightarrow> result = e') \<longrightarrow> is_eq_tbl a4 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp result y) \<and> (\<forall>(j1 :: int). seen2 ! nat j1 = True \<longrightarrow> seen3 ! nat j1 = True))) else (0 :: int) \<le> j \<and> j < int (length a3) \<longrightarrow> (\<forall>(result :: exp). (case a3 ! nat j of None \<Rightarrow> result = e | Some e' \<Rightarrow> result = e') \<longrightarrow> is_eq_tbl a3 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp result y))) | Plus e1 e2 \<Rightarrow> ((case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Minus f \<Rightarrow> f = e2 | Sub f f1 \<Rightarrow> f = e2 \<or> f1 = e2) \<and> is_eq_tbl a3 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen2)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> (\<forall>(seen3 :: bool list) (a4 :: exp option list). length seen3 = length seen2 \<longrightarrow> length a4 = length a3 \<longrightarrow> (\<forall>(o5 :: exp). is_eq_tbl a4 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e2 y = interp_exp o5 y) \<and> (\<forall>(j :: int). seen2 ! nat j = True \<longrightarrow> seen3 ! nat j = True) \<longrightarrow> ((case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> is_eq_tbl a4 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen3)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> (\<forall>(seen4 :: bool list) (a5 :: exp option list). length seen4 = length seen3 \<longrightarrow> length a5 = length a4 \<longrightarrow> (\<forall>(o6 :: exp). is_eq_tbl a5 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o6 y) \<and> (\<forall>(j :: int). seen3 ! nat j = True \<longrightarrow> seen4 ! nat j = True) \<longrightarrow> is_eq_tbl a5 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Plus o6 o5) y) \<and> (\<forall>(j :: int). seen2 ! nat j = True \<longrightarrow> seen4 ! nat j = True))))) | Sub e1 e2 \<Rightarrow> ((case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Minus f \<Rightarrow> f = e2 | Sub f f1 \<Rightarrow> f = e2 \<or> f1 = e2) \<and> is_eq_tbl a3 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen2)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> (\<forall>(seen3 :: bool list) (a4 :: exp option list). length seen3 = length seen2 \<longrightarrow> length a4 = length a3 \<longrightarrow> (\<forall>(o5 :: exp). is_eq_tbl a4 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e2 y = interp_exp o5 y) \<and> (\<forall>(j :: int). seen2 ! nat j = True \<longrightarrow> seen3 ! nat j = True) \<longrightarrow> ((case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> is_eq_tbl a4 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen3)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> (\<forall>(seen4 :: bool list) (a5 :: exp option list). length seen4 = length seen3 \<longrightarrow> length a5 = length a4 \<longrightarrow> (\<forall>(o6 :: exp). is_eq_tbl a5 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o6 y) \<and> (\<forall>(j :: int). seen3 ! nat j = True \<longrightarrow> seen4 ! nat j = True) \<longrightarrow> is_eq_tbl a5 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Sub o6 o5) y) \<and> (\<forall>(j :: int). seen2 ! nat j = True \<longrightarrow> seen4 ! nat j = True))))) | Minus e1 \<Rightarrow> ((case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> is_eq_tbl a3 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen2)) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> (\<forall>(seen3 :: bool list) (a4 :: exp option list). length seen3 = length seen2 \<longrightarrow> length a4 = length a3 \<longrightarrow> (\<forall>(o5 :: exp). is_eq_tbl a4 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o5 y) \<and> (\<forall>(j :: int). seen2 ! nat j = True \<longrightarrow> seen3 ! nat j = True) \<longrightarrow> is_eq_tbl a4 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Minus o5) y) \<and> (\<forall>(j :: int). seen2 ! nat j = True \<longrightarrow> seen3 ! nat j = True)))))) \<and> (length (seen1[nat i := True]) = length seen1 \<longrightarrow> (0 :: int) \<le> i \<and> i < int (length (seen1[nat i := True])) \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length a2)) \<and> (case a2 ! nat i of None \<Rightarrow> is_eq_tbl a2 l \<and> seen1[nat i := True] ! nat i = True \<and> (\<forall>(j :: int). seen1 ! nat j = True \<longrightarrow> seen1[nat i := True] ! nat j = True) | Some e \<Rightarrow> (is_eq_tbl a2 l \<and> count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) (seen1[nat i := True]))) False < count_list (drop (0 :: nat) (take (nat (m + (1 :: int)) - (0 :: nat)) seen1)) False) \<and> (\<forall>(seen2 :: bool list) (a3 :: exp option list). length seen2 = length (seen1[nat i := True]) \<longrightarrow> length a3 = length a2 \<longrightarrow> (\<forall>(o5 :: exp). is_eq_tbl a3 l \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp o5 y) \<and> (\<forall>(j :: int). seen1[nat i := True] ! nat j = True \<longrightarrow> seen2 ! nat j = True) \<longrightarrow> (let o6 :: exp option = Some o5 in ((0 :: int) \<le> i \<and> i < int (length a3)) \<and> (length (a3[nat i := o6]) = length a3 \<longrightarrow> nth (a3[nat i := o6]) o nat = (nth a3 o nat)(i := o6) \<longrightarrow> is_eq_tbl (a3[nat i := o6]) l \<and> seen2 ! nat i = True \<and> (\<forall>(j :: int). seen1 ! nat j = True \<longrightarrow> seen2 ! nat j = True))))))))) \<and> ((0 :: int) \<le> m + (1 :: int) \<longrightarrow> is_eq_tbl a1 l \<and> (\<forall>(seen1 :: bool list) (a2 :: exp option list). length seen1 = length seen \<longrightarrow> length a2 = length a1 \<longrightarrow> (\<forall>(i :: int). ((0 :: int) \<le> i \<and> i \<le> m) \<and> is_eq_tbl a2 l \<longrightarrow> ((0 :: int) \<le> i \<and> i < int (length seen1)) \<and> (if \<not>seen1 ! nat i = True then (is_eq_tbl a2 l \<and> seen1 ! nat i = False) \<and> (\<forall>(seen2 :: bool list) (a3 :: exp option list). length seen2 = length seen1 \<longrightarrow> length a3 = length a2 \<longrightarrow> is_eq_tbl a3 l \<and> seen2 ! nat i = True \<and> (\<forall>(j :: int). seen1 ! nat j = True \<longrightarrow> seen2 ! nat j = True) \<longrightarrow> is_eq_tbl a3 l) else is_eq_tbl a2 l)) \<and> (is_eq_tbl a2 l \<longrightarrow> (\<forall>(e :: exp). (case e of Lit _ \<Rightarrow> True | lineardecision_MP64Coeffs.Var i \<Rightarrow> (0 :: int) \<le> i \<and> i < int (length a2) \<longrightarrow> (\<forall>(result :: exp). (case a2 ! nat i of Some e' \<Rightarrow> result = e' | None \<Rightarrow> result = e) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp result y)) | Plus e1 e2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Minus f \<Rightarrow> f = e2 | Sub f f1 \<Rightarrow> f = e2 \<or> f1 = e2) \<and> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e2 y = interp_exp o5 y) \<longrightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> (\<forall>(o6 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o6 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Plus o6 o5) y))) | Sub e1 e2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Minus f \<Rightarrow> f = e2 | Sub f f1 \<Rightarrow> f = e2 \<or> f1 = e2) \<and> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e2 y = interp_exp o5 y) \<longrightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> (\<forall>(o6 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o6 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Sub o6 o5) y))) | Minus e1 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o5 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Minus o5) y)))) \<and> (\<forall>(c :: lineardecision_LinearDecisionIntMP.t). (case c of I _ \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff c) y y = True) | E e \<Rightarrow> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp o5 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.t = (E :: exp \<Rightarrow> lineardecision_LinearDecisionIntMP.t) o5 in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff result) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c y \<longrightarrow> pos_exp result y))) | R \<Rightarrow> (let result :: lineardecision_LinearDecisionIntMP.t = R in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff result) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c y \<longrightarrow> pos_exp result y)))) \<and> (\<forall>(c :: lineardecision_LinearDecisionIntMP.cprod). (case c of lineardecision_LinearDecisionIntMP.C c1 \<Rightarrow> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.t). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c1, lineardecision_LinearDecisionIntMP.Coeff o5) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c1 y \<longrightarrow> pos_exp o5 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.cprod = lineardecision_LinearDecisionIntMP.C o5 in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c result y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod result y))) | lineardecision_LinearDecisionIntMP.Times c1 c2 \<Rightarrow> (case c of lineardecision_LinearDecisionIntMP.C _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Times f f1 \<Rightarrow> f = c2 \<or> f1 = c2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c2 y y = lineardecision_LinearDecisionIntMP.interp_c o5 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c2 y \<longrightarrow> pos_cprod o5 y) \<longrightarrow> (case c of lineardecision_LinearDecisionIntMP.C _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Times f f1 \<Rightarrow> f = c1 \<or> f1 = c1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c1 y y = lineardecision_LinearDecisionIntMP.interp_c o6 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c1 y \<longrightarrow> pos_cprod o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.cprod = lineardecision_LinearDecisionIntMP.Times o6 o5 in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c result y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod result y)))))) \<and> (\<forall>(e :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' e m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e \<longrightarrow> (case e of lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> expr_bound' e m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, e) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e | lineardecision_LinearDecisionIntMP.ProdL e1 c \<Rightarrow> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c o5 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod o5 y) \<longrightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.ProdL o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.ProdR c e1 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c o6 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.ProdR o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e2 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e2, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e2 y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.Sum o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e2 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e2, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e2 y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.Diff o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.Coeff c \<Rightarrow> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.t). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff o5) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c y \<longrightarrow> pos_exp o5 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.Coeff o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y))))) \<and> (\<forall>(a3 :: lineardecision_LinearDecisionIntMP.expr') (b :: lineardecision_LinearDecisionIntMP.expr'). let eq :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (a3, b) in eq_bound' eq m \<and> lineardecision_LinearDecisionIntMP.valid_eq' eq \<longrightarrow> (expr_bound' b m \<and> lineardecision_LinearDecisionIntMP.valid_expr' b) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (b, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' b y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> (expr_bound' a3 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' a3) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (a3, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' a3 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (o6, o5) in eq_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' l eq y y = True \<longleftrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l result y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_eq' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_eq' eq y \<longrightarrow> pos_eq' result y))))) \<and> (\<forall>(acc :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). ctx_bound' acc m \<and> ctx_impl_ctx' l acc \<and> lineardecision_LinearDecisionIntMP.valid_ctx' acc \<longrightarrow> (case acc of Nil \<Rightarrow> (let result :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list = (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) in ctx_bound' result m \<and> ctx_impl_ctx' l result \<and> length result = length acc \<and> lineardecision_LinearDecisionIntMP.valid_ctx' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' acc y \<longrightarrow> pos_ctx' result y)) | Cons h t \<Rightarrow> (eq_bound' h m \<and> lineardecision_LinearDecisionIntMP.valid_eq' h) \<and> (\<forall>(h' :: lineardecision_LinearDecisionIntMP.expr') (h'1 :: lineardecision_LinearDecisionIntMP.expr'). let h'2 :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (h', h'1) in eq_bound' h'2 m \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' l h y y = True \<longleftrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l h'2 y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_eq' h'2 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_eq' h y \<longrightarrow> pos_eq' h'2 y) \<longrightarrow> ((case acc of Nil \<Rightarrow> False | Cons _ f \<Rightarrow> f = t) \<and> ctx_bound' t m \<and> ctx_impl_ctx' l t \<and> lineardecision_LinearDecisionIntMP.valid_ctx' t) \<and> (\<forall>(t' :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). ctx_bound' t' m \<and> ctx_impl_ctx' l t' \<and> length t' = length t \<and> lineardecision_LinearDecisionIntMP.valid_ctx' t' \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' t y \<longrightarrow> pos_ctx' t' y) \<longrightarrow> (let result :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list = Cons h'2 t' in ctx_bound' result m \<and> ctx_impl_ctx' l result \<and> length result = length acc \<and> lineardecision_LinearDecisionIntMP.valid_ctx' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' acc y \<longrightarrow> pos_ctx' result y)))))) \<and> (eq_bound' g2 m \<and> lineardecision_LinearDecisionIntMP.valid_eq' g2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr') (o6 :: lineardecision_LinearDecisionIntMP.expr'). let o7 :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (o5, o6) in eq_bound' o7 m \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' l g2 y y = True \<longleftrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l o7 y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_eq' o7 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_eq' g2 y \<longrightarrow> pos_eq' o7 y) \<longrightarrow> (ctx_bound' l m \<and> ctx_impl_ctx' l l \<and> lineardecision_LinearDecisionIntMP.valid_ctx' l) \<and> (\<forall>(o8 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). ctx_bound' o8 m \<and> ctx_impl_ctx' l o8 \<and> length o8 = length l \<and> lineardecision_LinearDecisionIntMP.valid_ctx' o8 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' l y \<longrightarrow> pos_ctx' o8 y) \<longrightarrow> length o8 = length l \<and> (lineardecision_LinearDecisionIntMP.valid_ctx' o8 \<and> lineardecision_LinearDecisionIntMP.valid_eq' o7 \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' o8 o7 y y = True \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l g2 y y = True)) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' l y \<longrightarrow> pos_eq' g2 y \<longrightarrow> pos_ctx' o8 y \<and> pos_eq' o7 y)))))) \<and> (m + (1 :: int) < (0 :: int) \<longrightarrow> (\<forall>(e :: exp). (case e of Lit _ \<Rightarrow> True | lineardecision_MP64Coeffs.Var i \<Rightarrow> (0 :: int) \<le> i \<and> i < int (length a1) \<longrightarrow> (\<forall>(result :: exp). (case a1 ! nat i of Some e' \<Rightarrow> result = e' | None \<Rightarrow> result = e) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp result y)) | Plus e1 e2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Minus f \<Rightarrow> f = e2 | Sub f f1 \<Rightarrow> f = e2 \<or> f1 = e2) \<and> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e2 y = interp_exp o5 y) \<longrightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> (\<forall>(o6 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o6 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Plus o6 o5) y))) | Sub e1 e2 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Minus f \<Rightarrow> f = e2 | Sub f f1 \<Rightarrow> f = e2 \<or> f1 = e2) \<and> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e2 y = interp_exp o5 y) \<longrightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> (\<forall>(o6 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o6 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Sub o6 o5) y))) | Minus e1 \<Rightarrow> (case e of Lit _ \<Rightarrow> False | lineardecision_MP64Coeffs.Var _ \<Rightarrow> False | Plus f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Minus f \<Rightarrow> f = e1 | Sub f f1 \<Rightarrow> f = e1 \<or> f1 = e1) \<and> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e1 y = interp_exp o5 y) \<longrightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp (Minus o5) y)))) \<and> (\<forall>(c :: lineardecision_LinearDecisionIntMP.t). (case c of I _ \<Rightarrow> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff c) y y = True) | E e \<Rightarrow> (\<forall>(o5 :: exp). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> interp_exp e y = interp_exp o5 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.t = (E :: exp \<Rightarrow> lineardecision_LinearDecisionIntMP.t) o5 in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff result) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c y \<longrightarrow> pos_exp result y))) | R \<Rightarrow> (let result :: lineardecision_LinearDecisionIntMP.t = R in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff result) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c y \<longrightarrow> pos_exp result y)))) \<and> (\<forall>(c :: lineardecision_LinearDecisionIntMP.cprod). (case c of lineardecision_LinearDecisionIntMP.C c1 \<Rightarrow> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.t). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c1, lineardecision_LinearDecisionIntMP.Coeff o5) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c1 y \<longrightarrow> pos_exp o5 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.cprod = lineardecision_LinearDecisionIntMP.C o5 in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c result y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod result y))) | lineardecision_LinearDecisionIntMP.Times c1 c2 \<Rightarrow> (case c of lineardecision_LinearDecisionIntMP.C _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Times f f1 \<Rightarrow> f = c2 \<or> f1 = c2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c2 y y = lineardecision_LinearDecisionIntMP.interp_c o5 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c2 y \<longrightarrow> pos_cprod o5 y) \<longrightarrow> (case c of lineardecision_LinearDecisionIntMP.C _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Times f f1 \<Rightarrow> f = c1 \<or> f1 = c1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c1 y y = lineardecision_LinearDecisionIntMP.interp_c o6 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c1 y \<longrightarrow> pos_cprod o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.cprod = lineardecision_LinearDecisionIntMP.Times o6 o5 in (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c result y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod result y)))))) \<and> (\<forall>(e :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' e m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e \<longrightarrow> (case e of lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> expr_bound' e m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, e) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' e | lineardecision_LinearDecisionIntMP.ProdL e1 c \<Rightarrow> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c o5 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod o5 y) \<longrightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.ProdL o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.ProdR c e1 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.cprod). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_c c y y = lineardecision_LinearDecisionIntMP.interp_c o6 y y) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_cprod c y \<longrightarrow> pos_cprod o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.ProdR o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.Sum e1 e2 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e2 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e2, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e2 y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.Sum o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.Diff e1 e2 \<Rightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e2 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e2 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e2, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e2 y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> ((case e of lineardecision_LinearDecisionIntMP.Sum f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.ProdL f _ \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.ProdR _ f \<Rightarrow> f = e1 | lineardecision_LinearDecisionIntMP.Diff f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | lineardecision_LinearDecisionIntMP.Var _ \<Rightarrow> False | lineardecision_LinearDecisionIntMP.Coeff _ \<Rightarrow> False) \<and> expr_bound' e1 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' e1) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e1, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e1 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.Diff o6 o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y)))) | lineardecision_LinearDecisionIntMP.Coeff c \<Rightarrow> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.t). (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (lineardecision_LinearDecisionIntMP.Coeff c, lineardecision_LinearDecisionIntMP.Coeff o5) y y = True) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_exp c y \<longrightarrow> pos_exp o5 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' = lineardecision_LinearDecisionIntMP.Coeff o5 in expr_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (e, result) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' e y \<longrightarrow> pos_expr' result y))))) \<and> (\<forall>(a2 :: lineardecision_LinearDecisionIntMP.expr') (b :: lineardecision_LinearDecisionIntMP.expr'). let eq :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (a2, b) in eq_bound' eq m \<and> lineardecision_LinearDecisionIntMP.valid_eq' eq \<longrightarrow> (expr_bound' b m \<and> lineardecision_LinearDecisionIntMP.valid_expr' b) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o5 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (b, o5) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o5 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' b y \<longrightarrow> pos_expr' o5 y) \<longrightarrow> (expr_bound' a2 m \<and> lineardecision_LinearDecisionIntMP.valid_expr' a2) \<and> (\<forall>(o6 :: lineardecision_LinearDecisionIntMP.expr'). expr_bound' o6 m \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_eq' (a2, o6) y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_expr' o6 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_expr' a2 y \<longrightarrow> pos_expr' o6 y) \<longrightarrow> (let result :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (o6, o5) in eq_bound' result m \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' l eq y y = True \<longleftrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l result y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_eq' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_eq' eq y \<longrightarrow> pos_eq' result y))))) \<and> (\<forall>(acc :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). ctx_bound' acc m \<and> ctx_impl_ctx' l acc \<and> lineardecision_LinearDecisionIntMP.valid_ctx' acc \<longrightarrow> (case acc of Nil \<Rightarrow> (let result :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list = (Nil :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list) in ctx_bound' result m \<and> ctx_impl_ctx' l result \<and> length result = length acc \<and> lineardecision_LinearDecisionIntMP.valid_ctx' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' acc y \<longrightarrow> pos_ctx' result y)) | Cons h t \<Rightarrow> (eq_bound' h m \<and> lineardecision_LinearDecisionIntMP.valid_eq' h) \<and> (\<forall>(h' :: lineardecision_LinearDecisionIntMP.expr') (h'1 :: lineardecision_LinearDecisionIntMP.expr'). let h'2 :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (h', h'1) in eq_bound' h'2 m \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' l h y y = True \<longleftrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l h'2 y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_eq' h'2 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_eq' h y \<longrightarrow> pos_eq' h'2 y) \<longrightarrow> ((case acc of Nil \<Rightarrow> False | Cons _ f \<Rightarrow> f = t) \<and> ctx_bound' t m \<and> ctx_impl_ctx' l t \<and> lineardecision_LinearDecisionIntMP.valid_ctx' t) \<and> (\<forall>(t' :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). ctx_bound' t' m \<and> ctx_impl_ctx' l t' \<and> length t' = length t \<and> lineardecision_LinearDecisionIntMP.valid_ctx' t' \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' t y \<longrightarrow> pos_ctx' t' y) \<longrightarrow> (let result :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list = Cons h'2 t' in ctx_bound' result m \<and> ctx_impl_ctx' l result \<and> length result = length acc \<and> lineardecision_LinearDecisionIntMP.valid_ctx' result \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' acc y \<longrightarrow> pos_ctx' result y)))))) \<and> (eq_bound' g2 m \<and> lineardecision_LinearDecisionIntMP.valid_eq' g2) \<and> (\<forall>(o5 :: lineardecision_LinearDecisionIntMP.expr') (o6 :: lineardecision_LinearDecisionIntMP.expr'). let o7 :: lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr' = (o5, o6) in eq_bound' o7 m \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' l g2 y y = True \<longleftrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l o7 y y = True) \<and> lineardecision_LinearDecisionIntMP.valid_eq' o7 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_eq' g2 y \<longrightarrow> pos_eq' o7 y) \<longrightarrow> (ctx_bound' l m \<and> ctx_impl_ctx' l l \<and> lineardecision_LinearDecisionIntMP.valid_ctx' l) \<and> (\<forall>(o8 :: (lineardecision_LinearDecisionIntMP.expr' \<times> lineardecision_LinearDecisionIntMP.expr') list). ctx_bound' o8 m \<and> ctx_impl_ctx' l o8 \<and> length o8 = length l \<and> lineardecision_LinearDecisionIntMP.valid_ctx' o8 \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' l y \<longrightarrow> pos_ctx' o8 y) \<longrightarrow> length o8 = length l \<and> (lineardecision_LinearDecisionIntMP.valid_ctx' o8 \<and> lineardecision_LinearDecisionIntMP.valid_eq' o7 \<and> (\<forall>(y :: int \<Rightarrow> int). lineardecision_LinearDecisionIntMP.interp_ctx' o8 o7 y y = True \<longrightarrow> lineardecision_LinearDecisionIntMP.interp_ctx' l g2 y y = True)) \<and> (\<forall>(y :: int \<Rightarrow> int). ctx_holds' l y y \<longrightarrow> pos_ctx' l y \<longrightarrow> pos_eq' g2 y \<longrightarrow> pos_ctx' o8 y \<and> pos_eq' o7 y)))))))))))"
  sorry
end
