theory lineardecision_LinearEquationsDecision_expr_boundqtvc
  imports "NTP4Verif.NTP4Verif"
begin
typedecl  coeff
typedecl  a
consts infix_pl :: "a \<Rightarrow> a \<Rightarrow> a"
consts infix_as :: "a \<Rightarrow> a \<Rightarrow> a"
consts prefix_mn :: "a \<Rightarrow> a"
consts azero :: "a"
consts aone :: "a"
consts ale :: "a \<Rightarrow> a \<Rightarrow> bool"
axiomatization where Assoc:   "infix_pl (infix_pl x y) z = infix_pl x (infix_pl y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Unit_def_l:   "infix_pl azero x = x"
  for x :: "a"
axiomatization where Unit_def_r:   "infix_pl x azero = x"
  for x :: "a"
axiomatization where Inv_def_l:   "infix_pl (prefix_mn x) x = azero"
  for x :: "a"
axiomatization where Inv_def_r:   "infix_pl x (prefix_mn x) = azero"
  for x :: "a"
axiomatization where Comm:   "infix_pl x y = infix_pl y x"
  for x :: "a"
  and y :: "a"
axiomatization where Assoc1:   "infix_as (infix_as x y) z = infix_as x (infix_as y z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_l:   "infix_as x (infix_pl y z) = infix_pl (infix_as x y) (infix_as x z)"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Mul_distr_r:   "infix_as (infix_pl y z) x = infix_pl (infix_as y x) (infix_as z x)"
  for y :: "a"
  and z :: "a"
  and x :: "a"
axiomatization where Comm1:   "infix_as x y = infix_as y x"
  for x :: "a"
  and y :: "a"
axiomatization where Unitary:   "infix_as aone x = x"
  for x :: "a"
axiomatization where NonTrivialRing:   "\<not>azero = aone"
axiomatization where Refl:   "ale x x"
  for x :: "a"
axiomatization where Trans:   "ale x z"
 if "ale x y"
 and "ale y z"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where Antisymm:   "x = y"
 if "ale x y"
 and "ale y x"
  for x :: "a"
  and y :: "a"
axiomatization where Total:   "ale x y \<or> ale y x"
  for x :: "a"
  and y :: "a"
axiomatization where ZeroLessOne:   "ale azero aone"
axiomatization where CompatOrderAdd:   "ale (infix_pl x z) (infix_pl y z)"
 if "ale x y"
  for x :: "a"
  and y :: "a"
  and z :: "a"
axiomatization where CompatOrderMult:   "ale (infix_as x z) (infix_as y z)"
 if "ale x y"
 and "ale azero z"
  for x :: "a"
  and y :: "a"
  and z :: "a"
consts infix_mn :: "a \<Rightarrow> a \<Rightarrow> a"
axiomatization where sub_def:   "infix_mn a1 a2 = infix_pl a1 (prefix_mn a2)"
  for a1 :: "a"
  and a2 :: "a"
typedecl  vars
typedecl  cvars
consts interp :: "coeff \<Rightarrow> cvars \<Rightarrow> a"
consts czero :: "coeff"
consts cone :: "coeff"
axiomatization where zero_def:   "interp czero y = azero"
  for y :: "cvars"
axiomatization where one_def:   "interp cone y = aone"
  for y :: "cvars"
consts eq :: "coeff \<Rightarrow> coeff \<Rightarrow> bool"
axiomatization where eq'spec:   "interp a1 y = interp b y"
 if "eq a1 b"
  for a1 :: "coeff"
  and b :: "coeff"
  and y :: "cvars"
typedecl  vars1
datatype  expr = Term "coeff" "int" | Add "expr" "expr" | Cst "coeff"
fun valid_expr :: "expr \<Rightarrow> _"
  where "valid_expr (Term x i) = ((0 :: int) \<le> i)" for x i
      | "valid_expr (Cst x) = True" for x
      | "valid_expr (Add e1 e2) = (valid_expr e1 \<and> valid_expr e2)" for e1 e2
theorem expr_bound'vc:
  fixes e :: "expr"
  shows "case e of Term _ i \<Rightarrow> True | Cst _ \<Rightarrow> True | Add e1 e2 \<Rightarrow> (case e of Term _ _ \<Rightarrow> False | Add f f1 \<Rightarrow> f = e1 \<or> f1 = e1 | Cst _ \<Rightarrow> False) \<and> (case e of Term _ _ \<Rightarrow> False | Add f f1 \<Rightarrow> f = e2 \<or> f1 = e2 | Cst _ \<Rightarrow> False)"
  sorry
end
